package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.ProjectTeamService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoProjectTeamHisBO;
import com.tydic.dict.service.course.bo.InfoProjectTeamHisRspBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.ProjectTeamServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class ProjectTeamServDuImpl implements ProjectTeamServDu {
    private final ProjectTeamService projectTeamService;
    @Override
    public InfoProjectTeamHisRspBO queryTeamByPage(InfoProjectTeamHisBO infoProjectTeamHisBO0) {
        try{
            return projectTeamService.queryTeamByPage(infoProjectTeamHisBO0);
        }catch (Exception e){
            InfoProjectTeamHisRspBO result = new InfoProjectTeamHisRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public BaseRspBO addProjectTeam(InfoProjectTeamHisBO infoProjectTeamHisBO0) {
        try{
            return projectTeamService.addProjectTeam(infoProjectTeamHisBO0);
        }catch (Exception e){
            BaseRspBO result = new BaseRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public BaseRspBO deleteProjectTeam(InfoProjectTeamHisBO infoProjectTeamHisBO0) {
        try{
            return projectTeamService.deleteProjectTeam(infoProjectTeamHisBO0);
        }catch (Exception e){
            BaseRspBO result = new BaseRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }
}
