package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.QueryDemandForImoprtService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoDemandDetailsBO;
import com.tydic.dict.service.course.bo.InfoDemandTabulationAndDetailsRspBO;
import com.tydic.dict.service.course.bo.SaveDemandReqBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.QueryDemandForImoprtServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class QueryDemandForImoprtServDuImpl implements QueryDemandForImoprtServDu {
    private final QueryDemandForImoprtService queryDemandForImoprtService;
    @Override
    public InfoDemandTabulationAndDetailsRspBO queryDemandByPage(InfoDemandDetailsBO infoDemandDetailsBO0) {
        try{
            return queryDemandForImoprtService.queryDemandByPage(infoDemandDetailsBO0);
        }catch (Exception e){
            log.error("分页查询需求失败："+e.getMessage());
            InfoDemandTabulationAndDetailsRspBO result = new InfoDemandTabulationAndDetailsRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public BaseRspBO saveDemand(SaveDemandReqBO saveDemandReqBO0) {
        try{
            return queryDemandForImoprtService.saveDemand(saveDemandReqBO0);
        }catch (Exception e){
            log.error("保存失败："+e.getMessage());
            BaseRspBO result = new BaseRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }
}
