package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.QueryInfoDemandDetailsService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoDemandDetailsBO;
import com.tydic.dict.service.course.bo.InfoDemandDetailsRspBO;
import com.tydic.dict.service.course.bo.InfoDemandTabulationAndDetailsRspBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.QueryInfoDemandDetailsServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class QueryInfoDemandDetailsServDuImpl implements QueryInfoDemandDetailsServDu {
    private final QueryInfoDemandDetailsService queryInfoDemandDetailsService;
    @Override
    public InfoDemandDetailsRspBO queryDemandDetailsByPage(InfoDemandDetailsBO infoDemandDetailsBO0) {
        try{
            return queryInfoDemandDetailsService.queryDemandDetailsByPage(infoDemandDetailsBO0);
        }catch (Exception e){
            log.error("分页查询需求失败："+e.getMessage());
            InfoDemandDetailsRspBO result = new InfoDemandDetailsRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public BaseRspBO editDemandDetails(InfoDemandDetailsBO infoDemandDetailsBO0) {
        try{
            return queryInfoDemandDetailsService.editDemandDetails(infoDemandDetailsBO0);
        }catch (Exception e){
            log.error("分页查询需求失败："+e.getMessage());
            BaseRspBO result = new BaseRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public BaseRspBO addDemandDetails(InfoDemandDetailsBO infoDemandDetailsBO0) {
        try{
            return queryInfoDemandDetailsService.addDemandDetails(infoDemandDetailsBO0);
        }catch (Exception e){
            log.error("分页查询需求失败："+e.getMessage());
            BaseRspBO result = new BaseRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public InfoDemandDetailsRspBO queryDemandDetailsById(InfoDemandDetailsBO infoDemandDetailsBO0) {
        try{
            return queryInfoDemandDetailsService.queryDemandDetailsById(infoDemandDetailsBO0);
        }catch (Exception e){
            log.error("分页查询需求失败："+e.getMessage());
            InfoDemandDetailsRspBO result = new InfoDemandDetailsRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }
}
