package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.QueryInfoProjectPrimaryService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.QueryInfoProjectPrimaryServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class QueryInfoProjectPrimaryServDuImpl implements QueryInfoProjectPrimaryServDu {
    private final QueryInfoProjectPrimaryService queryInfoProjectPrimaryService;
    @Override
    public InfoProjectPrimaryRspBO queryInfoProject(InfoProjectPrimaryBO infoProjectPrimaryBO0) {
        try{
            return queryInfoProjectPrimaryService.queryInfoProject(infoProjectPrimaryBO0);
        }catch (Exception e){
            log.error("分页查询需求失败："+e.getMessage());
            InfoProjectPrimaryRspBO result = new InfoProjectPrimaryRspBO();
            result.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            result.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
            return result;
        }
    }

    @Override
    public InfoProjectPrimaryRspBO queryAddProjectManagerOne(QueryAddProjectManagerReqBO reqBO) {
        log.info("-------[QueryInfoProjectPrimaryServDuImpl-QueryAddProjectManagerOne]-------，入参{}", reqBO.toString());
        InfoProjectPrimaryRspBO rspBO = new InfoProjectPrimaryRspBO();
        try {
            rspBO = queryInfoProjectPrimaryService.queryAddProjectManagerOne(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[QueryInfoProjectPrimaryServDuImpl-QueryAddProjectManagerOne]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoProjectPrimaryRspBO queryInfoProjectSelct(InfoProjectPrimaryBO reqBO) {
        log.info("-------[QueryInfoProjectPrimaryServDuImpl-queryInfoProjectSelct]-------，入参{}", reqBO.toString());
        InfoProjectPrimaryRspBO rspBO = new InfoProjectPrimaryRspBO();
        try{
            rspBO = queryInfoProjectPrimaryService.queryInfoProjectSelct(reqBO);
        }catch (Exception e){
            log.error("queryInfoProjectSelct失败："+e.getMessage());

            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);

        }
        log.info("-------[QueryInfoProjectPrimaryServDuImpl-queryInfoProjectSelct]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
