package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.QueryProjectCostService;
import com.tydic.dict.service.course.bo.InfoProjectPrimaryRspBO;
import com.tydic.dict.service.course.bo.QueryProjectCostReqBO;
import com.tydic.dict.service.course.bo.QueryProjectCostRspBO;
import com.tydic.dict.service.course.constants.BaseRspConstant;
import com.tydic.dict.service.course.servDu.QueryProjectCostServDu;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

/**
 * @program: markedeve-service-udp
 * @ClassName: QueryProjectCostServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-28 18:12
 */
@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class QueryProjectCostServDuImpl implements QueryProjectCostServDu {
    private final QueryProjectCostService queryInfoProjectPrimaryService;
    @Override
    public QueryProjectCostRspBO queryProjectCostData(QueryProjectCostReqBO reqBO) {
        log.info("-------[QueryProjectCostServDuImpl-queryProjectCostData]-------，入参{}", reqBO.toString());
        QueryProjectCostRspBO rspBO = new QueryProjectCostRspBO();
        try {
            rspBO = queryInfoProjectPrimaryService.queryProjectCostData(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[QueryProjectCostServDuImpl-queryProjectCostData]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
