package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.RequirementPreReviewResultInputService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.InfoDemandDetailsHisReqBO;
import com.tydic.dict.service.course.bo.InfoDemandDetailsHisRspBO;
import com.tydic.dict.service.course.bo.RequirementPreReviewResultInputReqBO;
import com.tydic.dict.service.course.servDu.RequirementPreReviewResultInputServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: RequirementPreReviewResultInputServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-02-22 15:09
 */
@HTServiceImpl
@Slf4j
public class RequirementPreReviewResultInputServDuImpl implements RequirementPreReviewResultInputServDu {
    @Resource
    private RequirementPreReviewResultInputService requirementPreReviewResultInputService;

    @Override
    public BaseRspBO doRequirementPreReviewResultInput(RequirementPreReviewResultInputReqBO reqBO) throws Exception {
        log.info("-------[RequirementPreReviewResultInputServDuImpl-doRequirementPreReviewResultInput]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = requirementPreReviewResultInputService.doRequirementPreReviewResultInput(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
        }
        log.info("-------[RequirementPreReviewResultInputServDuImpl-doRequirementPreReviewResultInput]-------，出参{}", rspBO.toString());
        return rspBO;
    }

    @Override
    public InfoDemandDetailsHisRspBO queryInfoDemandDetailsHisLists(InfoDemandDetailsHisReqBO reqBO) {
        log.info("-------[RequirementPreReviewResultInputServDuImpl-queryInfoDemandDetailsHisLists]-------，入参{}", reqBO.toString());
        InfoDemandDetailsHisRspBO rspBO = new InfoDemandDetailsHisRspBO();
        try {
            rspBO = requirementPreReviewResultInputService.queryInfoDemandDetailsHisLists(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL);
        }
        log.info("-------[RequirementPreReviewResultInputServDuImpl-queryInfoDemandDetailsHisLists]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
