package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.SysUserService;
import com.tydic.dict.service.course.bo.*;
import com.tydic.dict.service.course.servDu.SysUserServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

@HTServiceImpl
@Slf4j
@RequiredArgsConstructor
public class SysUserServDuImpl implements SysUserServDu {

    private final SysUserService sysUserService;

    @Override
    public SysUserTokenRspBO getToken(SysUserTokenReqBO reqBO) {
        log.info("-------[SysUserServDuImpl-getToken被调用]-------，入参{}", reqBO.toString());
        SysUserTokenRspBO rspBO = new SysUserTokenRspBO();
        try {
            rspBO = sysUserService.getToken(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return rspBO;
    }

    @Override
    public SysUserRspBO getUserInfo(SysUserReqBO reqBO) {
        log.info("-------[SysUserServDuImpl-getUserInfo被调用]-------，入参{}", reqBO.toString());
        SysUserRspBO rspBO = new SysUserRspBO();
        try {
            rspBO = sysUserService.getUserInfo(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        return rspBO;
    }
}
