package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.TaskInstService;
import com.tydic.dict.service.course.TaskInstService;
import com.tydic.dict.service.course.bo.BaseReqBO;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.TaskInstReqBO;
import com.tydic.dict.service.course.bo.TaskInstRspBO;
import com.tydic.dict.service.course.servDu.TaskInstServDu;
import lombok.extern.ohaotian.HTServiceAPI;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @Description:
 * @Author: xsl
 * @Date: 2024/2/5 14:01
 */
@HTServiceImpl
@Slf4j
public class TaskInstServDuImpl implements TaskInstServDu {

    @Resource
    private TaskInstService taskInstService;
    @Override
    public BaseRspBO queryTaskInst(BaseReqBO reqBO) {
        BaseRspBO rspBO = new BaseRspBO();
        log.info("-------- [TaskInstServDuImpl.queryTaskInst] 入参：" + reqBO.toString());
        String s = taskInstService.queryTaskInst(reqBO.getPageSize());
        log.info("-------" + s);
        rspBO.setRespCode("111");
        rspBO.setRespDesc("查询成功");
        return rspBO;
    }

    @Override
    public TaskInstRspBO queryTaskInstBy(TaskInstReqBO taskInstReqBO) {
        return taskInstService.queryTaskInstBy(taskInstReqBO);
    }
}
