package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.TechnicalLeaderDepartmentApprovesSubmitService;
import com.tydic.dict.service.course.bo.BaseRspBO;
import com.tydic.dict.service.course.bo.TechLeaderDeApproveSubmitReqBO;
import com.tydic.dict.service.course.servDu.TechnicalLeaderDepartmentApprovesSubmitServDu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.Resource;

/**
 * @program: markedeve-service-udp
 * @ClassName: TechnicalLeaderDepartmentApprovesSubmitServDuImpl
 * @description:
 * @author: wuzhixiang
 * @create: 2024-03-06 15:54
 */
@HTServiceImpl
@Slf4j
public class TechnicalLeaderDepartmentApprovesSubmitServDuImpl implements TechnicalLeaderDepartmentApprovesSubmitServDu {

    @Resource
    private TechnicalLeaderDepartmentApprovesSubmitService submitService;
    @Override
    public BaseRspBO doApprovalDepartmentLeaderSubmit(TechLeaderDeApproveSubmitReqBO reqBO) {
        log.info("-------[TechnicalLeaderDepartmentApprovesSubmitServDuImpl-doApprovalDepartmentLeaderSubmit]-------，入参{}", reqBO.toString());
        BaseRspBO rspBO = new BaseRspBO();
        try {
            rspBO = submitService.doApprovalDepartmentLeaderSubmit(reqBO);
        } catch (Exception e) {
            e.printStackTrace();
            log.error("调用service异常：" + e.getMessage());
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_FAIL);
            rspBO.setRespDesc(BaseRspConstant.RSP_DESC_FAIL + e.getMessage());
        }
        log.info("-------[TechnicalLeaderDepartmentApprovesSubmitServDuImpl-doApprovalDepartmentLeaderSubmit]-------，出参{}", rspBO.toString());
        return rspBO;
    }
}
