package com.tydic.dict.servDuImpl;

import com.tydic.dict.service.course.bo.ParaEncryptionReqBO;
import com.tydic.dict.service.course.bo.ParaEncryptionRspBO;
import com.tydic.dict.service.course.servDu.ToolUnificationServDu;
import com.tydic.dict.utils.AesUtils;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.StringUtils;

/**
 * @Description:
 * @Author: xsl
 * @Date: 2024/4/28 17:01
 */
@HTServiceImpl
@Slf4j
public class ToolUnificationServDuImpl implements ToolUnificationServDu {

    @Override
    public ParaEncryptionRspBO paraEncryption(ParaEncryptionReqBO reqBO) {
        ParaEncryptionRspBO rspBO = new ParaEncryptionRspBO();
        if (!StringUtils.hasText(reqBO.getEncryptMessage())){
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("入参 加密报文 为空！");
            return rspBO;
        }
        try{
            String decrypt = AesUtils.decrypt(reqBO.getEncryptMessage());
            rspBO.setRespDesc("解密成功！");
            rspBO.setRespCode("0000");
            rspBO.setPlaintext(decrypt);
        }catch (Exception e){
            log.error("解密异常：{}" , e.getMessage());
            rspBO.setRespDesc("解密异常：" + e.getMessage());
            rspBO.setRespCode("9999");
        }
        return rspBO;
    }

    @Override
    public ParaEncryptionRspBO paraDecryption(ParaEncryptionReqBO reqBO) {
        ParaEncryptionRspBO rspBO = new ParaEncryptionRspBO();
        if (!StringUtils.hasText(reqBO.getPlaintext())){
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("入参 明文 为空！");
            return rspBO;
        }
        try{
            String encrypt = AesUtils.encrypt(reqBO.getPlaintext());
            rspBO.setRespDesc("加密成功！");
            rspBO.setRespCode("0000");
            rspBO.setParaEncryption(encrypt);
        }catch (Exception e){
            log.error("加密异常：{}" , e.getMessage());
            rspBO.setRespDesc("加密异常：" + e.getMessage());
            rspBO.setRespCode("9999");
        }
        return rspBO;
    }
}
