package com.tydic.dict.service.course;

import com.tydic.dict.service.course.bo.*;

public interface ProjectCostManageService {

    /*
    * @Description: 项目成本信息查询
    * @Param: [reqBO]
    * @return: com.tydic.dict.service.course.bo.ProjectCostManageRspBO
    * @Author: xsl
    * @Date: 2024/7/31 15:06
    */
    ProjectCostManageRspBO getProjectCostManageInfo(ProjectCostManageReqBO reqBO);
    /*
     * @Description: 项目最新节点信息查询
     * @Param: [reqBO]
     * @return: com.tydic.dict.service.course.bo.ProjectCostManageRspBO
     * @Author: xsl
     * @Date: 2024/7/31 15:06
     */
    ProjectCostManageRspBO getLatestNodeInfo(ProjectCostManageReqBO reqBO);
    /*
     * @Description: 项目外协信息查询-项目成本管理使用
     * @Param: [reqBO]
     * @return: com.tydic.dict.service.course.bo.ProjectCostManageRspBO
     * @Author: xsl
     * @Date: 2024/7/31 15:06
     */
    InfoDemandTaskRspBO getOutsourceInfo(ProjectCostManageReqBO reqBO);
    /*
    * @Description: 工单支撑分页查询-项目成本管理使用
    * @Param: [reqBO]
    * @return: com.tydic.dict.service.course.bo.InfoDemandTaskRspBO
    * @Author: xsl
    * @Date: 2024/8/5 16:17
    */
    InfoWorkOrderSupportRspBO getInfoWorkOrderSupportPageList(ProjectCostManageReqBO reqBO);
}
