package com.tydic.dict.utils;

import com.alibaba.fastjson.JSONObject;
import org.springframework.util.StringUtils;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

/**
 * 类名称:AesUtils
 * 说明：AES加解密工具类
 * 时间：2024/4/15 11:30
 * 作者 @author jingxin
 */
public class AesUtils {
    private static final String AES_ECB_KEY = "G34jK6y7uN1f2E8D5xB9vC0Z4pQRs7T6";
    /**
     * 加密模式之ECB,算法/模式/补码方式
     */
    private static final String AES_ECB = "AES/ECB/PKCS5Padding";
    /**
     * 加密模式之CBC,算法/模式/补码方式
     */
    private static final String AES_CBC = "AES/CBC/PKCS5Padding";
    /**
     * 加密模式之CFB,算法/模式/补码方式
     */
    private static final String AES_CFB = "AES/CFB/PKCS5Padding";
    /**
     * AES
     */
    private static final String AES = "AES";


    /**
     * 描述 加密 ECB模式
     *
     * @param content 内容
     * @return java.lang.String
     * @author liugs
     * @date 2024/4/11 0011 10:14
     */
    public static String encrypt(String content) {
        if (!StringUtils.hasText(content)) {
            return null;
        }

        try {
            // 创建AES加密器
            Cipher cipher = Cipher.getInstance(AES_ECB);
            // 获取命名规范
            SecretKeySpec sks = getSecretKeySpec(AES_ECB_KEY);

            cipher.init(Cipher.ENCRYPT_MODE, sks);
            // 加密字节数组
            byte[] encryptedBytes = cipher.doFinal(getBytes(content));
            // 将密文转为Base64编码字符串
            return Base64.getEncoder().encodeToString(encryptedBytes);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 描述 解密 ECB模式
     *
     * @param content 内容
     * @return java.lang.String
     * @author liugs
     * @date 2024/4/11 0011 10:14
     */
    public static String decrypt(String content) {
        if (StringUtils.isEmpty(content)) {
            return null;
        }
        byte[] contentBytes = Base64.getDecoder().decode(content);
        try {
            // 创建AES加密器
            Cipher cipher = Cipher.getInstance(AES_ECB);
            // 获取命名规范
            SecretKeySpec sks = getSecretKeySpec(AES_ECB_KEY);
            cipher.init(Cipher.DECRYPT_MODE, sks);

            byte[] decryptedBytes = cipher.doFinal(contentBytes);

            return new String(decryptedBytes, StandardCharsets.UTF_8);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * 描述 加密
     *
     * @param content 内容
     * @param mode    加密模式
     * @return java.lang.String
     * @author liugs
     * @date 2024/4/11 0011 10:14
     */
    public static String encrypt(String content, String mode) {
        if (StringUtils.isEmpty(content) || StringUtils.isEmpty(mode)) {
            return null;
        }
        try {
            // 创建AES加密器
            Cipher cipher = Cipher.getInstance(mode);
            // 获取命名规范
            SecretKeySpec sks = getSecretKeySpec(AES_ECB_KEY);

            cipher.init(Cipher.ENCRYPT_MODE, sks, new IvParameterSpec(new byte[cipher.getBlockSize()]));

            byte[] encryptedBytes = cipher.doFinal(getBytes(content));

            // 将密文转为Base64编码字符串
            return Base64.getEncoder().encodeToString(encryptedBytes);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 描述 解密
     *
     * @param content 内容
     * @param mode    加密模式
     * @return java.lang.String
     * @author liugs
     * @date 2024/4/11 0011 10:14
     */
    public static String decrypt(String content, String mode) {
        if (StringUtils.isEmpty(content) || StringUtils.isEmpty(mode)) {
            return null;
        }

        byte[] contentBytes = Base64.getDecoder().decode(content);
        try {
            // 创建AES解密器
            Cipher cipher = Cipher.getInstance(mode);
            // 获取命名规范
            SecretKeySpec sks = getSecretKeySpec(AES_ECB_KEY);

            // 初始化解密器
            cipher.init(Cipher.DECRYPT_MODE, sks, new IvParameterSpec(new byte[cipher.getBlockSize()]));
            // 解密
            byte[] decryptedBytes = cipher.doFinal(contentBytes);

            return new String(decryptedBytes, StandardCharsets.UTF_8);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 描述 获取字节数组
     *
     * @param iv 初始化向量
     * @return byte[]
     * @author liugs
     * @date 2024/4/11 0011 10:14
     */
    private static byte[] getBytes(String iv) {
        if (null == iv) {
            return null;
        }
        try {
            return iv.getBytes(StandardCharsets.UTF_8);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 描述 获取密钥规范
     *
     * @param key 密钥
     * @return javax.crypto.spec.SecretKeySpec
     * @author liugs
     * @date 2024/4/11 0011 10:14
     */
    private static SecretKeySpec getSecretKeySpec(String key) {
        return new SecretKeySpec(getBytes(key), AES);
    }

    public static void main(String[] args) {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("userName","admin");
        String content = jsonObject.toJSONString();
        System.out.println("AES_ECB模式：=====");
        String encryptECB = encrypt(content);
//        System.out.println("加密后的字符串：" + encryptECB);
        encryptECB = "Wzzk+CNqKkdSgr9rXT2XpEWSwE21nNXIMTYEqqRW5xV8s9uf+YIoFFcR02jj0m0r2hkMbZO+wgU+ofUG2leEQ6o9Knnfkgqbxybu7rnHyQFgKQRn4xY5rGO2YUbtrQxJvsyx+BdT2Cj86uNQfrWGjubDjJFM7NOo4/XV4IBr239Nad/OAee7M/05nY/KolX2fsrLywlSK9/jobguIXyCcmdi9OKx/Eai5NcLYSeewJEP1AFxqyCXzY4V6X1t+/nXct3JrqVs9l3PbRU2x4ZMpTcedUOXqoI004jAjzSax6c9MVMPbPA/3BMZPp/HGSOY9y39xMETgz4aE5t78JiQuYTQiqFDefhf3EYpP85YryGzd4R3aL7Nu55/F6vHFCXLK1O38As2QCwoSqCtZsaSQwox3i2KzWA4vuZI8h8Zuguch2XWFHtnl8P+lPpEn9gB3IQmOFEg7GXl+QIK7NEXdw==";
        System.out.println("解密后的字符串：" + decrypt(encryptECB));

        /*System.out.println("AES_CBC模式：=====");
        String encryptCBC = encrypt(content, AES_CBC);
        System.out.println("加密后的字符串：" + encryptCBC);
//        encryptCBC = "WZ0n3rxUPxi9qooMu3GHJTLvw/ag8kHehlhc/APCPi8Rqx+sL9fnnhgvJ+Ajm1yBwlvdz9UA2bX/PYw9oSN1eggrPlT79ocGcrZOSOpF2Nvg00HfQGPe79Wuo0DD/XXN";
        System.out.println("解密后的字符串：" + decrypt(encryptCBC, AES_CBC));

        System.out.println("AES_CFB模式：=====");
        String encryptCFB = encrypt(content, AES_CFB);
        System.out.println("加密后的字符串：" + encryptCFB);
        System.out.println("解密后的字符串：" + decrypt(encryptCFB, AES_CFB));*/
    }
}

