package com.tydic.dict.utils;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * 标题：NumberGenServiceImpl
 * 说明：
 * 时间：2023/10/10 22:49
 *
 * @author 马冲
 **/
@Service
public class NumberGenUtils{
    @Autowired
    private CacheClient redisUtils;

    private static final int LENGTH = 3;

    private static final String INITIAL_COUNT = "0";
    private static final String REDIS_FILE = "NUMBER_GEN:";

    private static final DateTimeFormatter YEAR_FORMAT = DateTimeFormatter.ofPattern("yyyy");

    private static final DateTimeFormatter MONTH_FORMAT = DateTimeFormatter.ofPattern("yyyyMM");

    private static final DateTimeFormatter DAY_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd");


    public String generateNumber (String code) {
        return getNumber(code, "", LENGTH, INITIAL_COUNT);
    }


    public String generateNumberByMonth (String code) {
        return getNumber(code, MONTH_FORMAT.format(LocalDate.now()), LENGTH, INITIAL_COUNT);
    }


    public String generateNumberByDay (String code) {
        return getNumber(code, DAY_FORMAT.format(LocalDate.now()), LENGTH, INITIAL_COUNT);
    }


    public String generateNumberByDay(String code, int length) {
        return getNumber(code, DAY_FORMAT.format(LocalDate.now()), length, INITIAL_COUNT);
    }


    public String generateNumberByDay(String code, int length, String initialCount) {
        return getNumber(code, DAY_FORMAT.format(LocalDate.now()), length, initialCount);
    }

    /**
     * 根据code及年生成编号
     * 例子:20190001
     *
     * @param code         前缀
     * @param length       编号长度
     * @param initialCount 初始化
     * @return 编号
     */

    public String generateNumberByYear(String code, int length, String initialCount) {
        return getNumber(code, YEAR_FORMAT.format(LocalDate.now()), length, initialCount);
    }

    private String getNumber(String code, String month, int length, @Nullable String initialCount) {
        String key = REDIS_FILE + code;
        if(redisUtils.get(key) == null){
            if(initialCount == null){
                return null;
            }
            redisUtils.set(key, initialCount);
        }
        Object o = redisUtils.get(key);
        Integer number = JSON.parseObject(o.toString(), Integer.class);
        redisUtils.set(key, String.valueOf(++number));
        return month + StringUtils.leftPad(number.toString(), length, '0');
    }

}
