package com.tydic.dict.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.StringReader;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: xsl
 * @Date: 2024/7/19 10:55
 */
public class XmlParserUtils {

    public static List<Map<String,String>> parseFlowXml(String xmlString) throws Exception {
        List<Map<String,String>> rspList = new ArrayList<>();
        // 使用 DocumentBuilderFactory 创建 DocumentBuilder
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();

        // 使用 DocumentBuilder 解析 XML 字符串
        Document document = builder.parse(new InputSource(new StringReader(xmlString)));
        // 获取所有 flow 节点
        NodeList flowNodes = document.getElementsByTagName("flow");

        // 遍历 flow 节点
        for (int i = 0; i < flowNodes.getLength(); i++) {
            Node node = flowNodes.item(i);
            if (node.getNodeType() == Node.ELEMENT_NODE) {
                Element element = (Element) node;

                // 获取 flow 标签的属性
                /*String id = element.getAttribute("id");
                String name = element.getAttribute("name");
                String defaultStream = element.getAttribute("defaultStream");*/
                String sourceRef = element.getAttribute("sourceRef");
                String targetRef = element.getAttribute("targetRef");

                // 打印属性值
                /*System.out.println("Flow " + i + ":");
                System.out.println("  id: " + id);
                System.out.println("  name: " + name);
                System.out.println("  defaultStream: " + defaultStream);
                System.out.println("  sourceRef: " + sourceRef);
                System.out.println("  targetRef: " + targetRef);*/

                HashMap<String, String> stringStringHashMap = new HashMap<>();
                stringStringHashMap.put("sourceRef",sourceRef);
                stringStringHashMap.put("targetRef",targetRef);
                rspList.add(stringStringHashMap);
            }
        }
        return rspList;
    }

    public static void main(String[] args) {
        String xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" +
                "<bpmn>\n" +
                "    <workflow id=\"961979812501581824\" name=\"项目立项审批\" description=\"\">\n" +
                "        <baseInfo processCode=\"PD961978735286874113\" processName=\"项目立项审批\" processType=\"APPROVE\">\n" +
                "            <business businessId=\"busid\" businessKey=\"projectProductType\" businessType=\"projectReview\" tag=\"TASK_TAG\"/>\n" +
                "            <paramList>\n" +
                "                <param paramName=\"projectProductType\" paramDesc=\"项目产品类型\" paramType=\"String\" busiObjectCode=\"projectReview\" busiObjectName=\"项目评审流程参数\">\n" +
                "                </param>\n" +
                "            </paramList>\n" +
                "        </baseInfo>\n" +
                "        <start id=\"start2\" name=\"\">\n" +
                "        </start>\n" +
                "\t\t<flow id=\"flow17\" name=\"\" defaultStream=\"false\" sourceRef=\"XM003\" targetRef=\"XM004\">\n" +
                "        </flow>\n" +
                "        <flow id=\"flow10\" name=\"\" defaultStream=\"false\" sourceRef=\"start2\" targetRef=\"XM001\">\n" +
                "        </flow>\n" +
                "        <flow id=\"flow11\" name=\"\" defaultStream=\"false\" sourceRef=\"XM001\" targetRef=\"XM002\">\n" +
                "        </flow>\n" +
                "        <step id=\"XM001\" name=\"产品中心负责人发起项目立项\" isSubprocess=\"false\">\n" +
                "            <approve id=\"approve3\" isUrge=\"false\" day=\"\" hour=\"\">\n" +
                "                <returnPhase id=\"returnPhase3\" isInitiateLink=\"false\" isBeforeLink=\"false\" isAllLink=\"false\" isStopLink=\"false\"/>\n" +
                "                <submitMethod id=\"submitMethod3\" isAgainSubmit=\"true\" isSubmitRejectLink=\"false\"/>\n" +
                "                <treatmentMethod id=\"treatmentMethod3\" method=\"3\" value=\"\"/>\n" +
                "                <timeOutProMethod id=\"timeOutProMethod3\" method=\"1\" noticeTaskId=\"\" noticeTaskName=\"\"/>\n" +
                "                <controlType id=\"controlType3\" beforeCountersign=\"false\" afterCountersign=\"false\" transferCountersign=\"false\" circulate=\"false\" noticeTaskId=\"\" noticeTaskName=\"\"/>\n" +
                "                <autoDeRepeatMethod id=\"autoDeRepeatMethod3\" theSamePerson=\"false\" keepOne=\"false\" isEmpty=\"false\">\n" +
                "                </autoDeRepeatMethod>\n" +
                "                <recallTacheMethod id=\"submitUserMethod3\" handlerRecall=\"false\">\n" +
                "                </recallTacheMethod>\n" +
                "                <submitUserMethod id=\"submitUserMethod3\" handlerCancel=\"false\">\n" +
                "                </submitUserMethod>\n" +
                "            </approve>\n" +
                "        </step>\n" +
                "        <flow id=\"flow12\" name=\"\" defaultStream=\"false\" sourceRef=\"XM002\" targetRef=\"XM003\">\n" +
                "        </flow>\n" +
                "        <step id=\"XM002\" name=\"产品中心负责人部门领导审批\" isSubprocess=\"false\">\n" +
                "            <approve id=\"approve4\" isUrge=\"false\" day=\"\" hour=\"\">\n" +
                "                <returnPhase id=\"returnPhase4\" isInitiateLink=\"false\" isBeforeLink=\"false\" isAllLink=\"false\" isStopLink=\"false\"/>\n" +
                "                <submitMethod id=\"submitMethod4\" isAgainSubmit=\"true\" isSubmitRejectLink=\"false\"/>\n" +
                "                <treatmentMethod id=\"treatmentMethod4\" method=\"3\" value=\"\"/>\n" +
                "                <timeOutProMethod id=\"timeOutProMethod4\" method=\"1\" noticeTaskId=\"\" noticeTaskName=\"\"/>\n" +
                "                <controlType id=\"controlType4\" beforeCountersign=\"false\" afterCountersign=\"false\" transferCountersign=\"false\" circulate=\"false\" noticeTaskId=\"\" noticeTaskName=\"\"/>\n" +
                "                <autoDeRepeatMethod id=\"autoDeRepeatMethod4\" theSamePerson=\"false\" keepOne=\"false\" isEmpty=\"false\">\n" +
                "                </autoDeRepeatMethod>\n" +
                "                <recallTacheMethod id=\"submitUserMethod4\" handlerRecall=\"false\">\n" +
                "                </recallTacheMethod>\n" +
                "                <submitUserMethod id=\"submitUserMethod4\" handlerCancel=\"false\">\n" +
                "                </submitUserMethod>\n" +
                "            </approve>\n" +
                "        </step>\n" +
                "\t\t<flow id=\"flow22\" name=\"\" defaultStream=\"false\" sourceRef=\"XM006\" targetRef=\"end18\">\n" +
                "        </flow>\n" +
                "        <step id=\"XM003\" name=\"研发部门项目经理审批\" isSubprocess=\"false\">\n" +
                "            <approve id=\"approve5\" isUrge=\"false\" day=\"\" hour=\"\">\n" +
                "                <returnPhase id=\"returnPhase5\" isInitiateLink=\"false\" isBeforeLink=\"false\" isAllLink=\"false\" isStopLink=\"false\"/>\n" +
                "                <submitMethod id=\"submitMethod5\" isAgainSubmit=\"true\" isSubmitRejectLink=\"false\"/>\n" +
                "                <treatmentMethod id=\"treatmentMethod5\" method=\"3\" value=\"\"/>\n" +
                "                <timeOutProMethod id=\"timeOutProMethod5\" method=\"1\" noticeTaskId=\"\" noticeTaskName=\"\"/>\n" +
                "                <controlType id=\"controlType5\" beforeCountersign=\"false\" afterCountersign=\"false\" transferCountersign=\"false\" circulate=\"false\" noticeTaskId=\"\" noticeTaskName=\"\"/>\n" +
                "                <autoDeRepeatMethod id=\"autoDeRepeatMethod5\" theSamePerson=\"false\" keepOne=\"false\" isEmpty=\"false\">\n" +
                "                </autoDeRepeatMethod>\n" +
                "                <recallTacheMethod id=\"submitUserMethod5\" handlerRecall=\"false\">\n" +
                "                </recallTacheMethod>\n" +
                "                <submitUserMethod id=\"submitUserMethod5\" handlerCancel=\"false\">\n" +
                "                </submitUserMethod>\n" +
                "            </approve>\n" +
                "        </step>\n" +
                "        <flow id=\"flow19\" name=\"\" defaultStream=\"false\" sourceRef=\"XM004\" targetRef=\"XM005\">\n" +
                "        </flow>\n" +
                "        <step id=\"XM004\" name=\"研发部门领导审批\" isSubprocess=\"false\">\n" +
                "            <approve id=\"approve6\" isUrge=\"false\" day=\"\" hour=\"\">\n" +
                "                <returnPhase id=\"returnPhase6\" isInitiateLink=\"false\" isBeforeLink=\"false\" isAllLink=\"false\" isStopLink=\"false\"/>\n" +
                "                <submitMethod id=\"submitMethod6\" isAgainSubmit=\"true\" isSubmitRejectLink=\"false\"/>\n" +
                "                <treatmentMethod id=\"treatmentMethod6\" method=\"3\" value=\"\"/>\n" +
                "                <timeOutProMethod id=\"timeOutProMethod6\" method=\"1\" noticeTaskId=\"\" noticeTaskName=\"\"/>\n" +
                "                <controlType id=\"controlType6\" beforeCountersign=\"false\" afterCountersign=\"false\" transferCountersign=\"false\" circulate=\"false\" noticeTaskId=\"\" noticeTaskName=\"\"/>\n" +
                "                <autoDeRepeatMethod id=\"autoDeRepeatMethod6\" theSamePerson=\"false\" keepOne=\"false\" isEmpty=\"false\">\n" +
                "                </autoDeRepeatMethod>\n" +
                "                <recallTacheMethod id=\"submitUserMethod6\" handlerRecall=\"false\">\n" +
                "                </recallTacheMethod>\n" +
                "                <submitUserMethod id=\"submitUserMethod6\" handlerCancel=\"false\">\n" +
                "                </submitUserMethod>\n" +
                "            </approve>\n" +
                "        </step>\n" +
                "        <flow id=\"flow20\" name=\"\" defaultStream=\"false\" sourceRef=\"XM005\" targetRef=\"XM006\">\n" +
                "        </flow>\n" +
                "        <step id=\"XM005\" name=\"技术规划部对口项目经理审批\" isSubprocess=\"false\">\n" +
                "            <approve id=\"approve7\" isUrge=\"false\" day=\"\" hour=\"\">\n" +
                "                <returnPhase id=\"returnPhase7\" isInitiateLink=\"false\" isBeforeLink=\"false\" isAllLink=\"false\" isStopLink=\"false\"/>\n" +
                "                <submitMethod id=\"submitMethod7\" isAgainSubmit=\"true\" isSubmitRejectLink=\"false\"/>\n" +
                "                <treatmentMethod id=\"treatmentMethod7\" method=\"3\" value=\"\"/>\n" +
                "                <timeOutProMethod id=\"timeOutProMethod7\" method=\"1\" noticeTaskId=\"\" noticeTaskName=\"\"/>\n" +
                "                <controlType id=\"controlType7\" beforeCountersign=\"false\" afterCountersign=\"false\" transferCountersign=\"false\" circulate=\"false\" noticeTaskId=\"\" noticeTaskName=\"\"/>\n" +
                "                <autoDeRepeatMethod id=\"autoDeRepeatMethod7\" theSamePerson=\"false\" keepOne=\"false\" isEmpty=\"false\">\n" +
                "                </autoDeRepeatMethod>\n" +
                "                <recallTacheMethod id=\"submitUserMethod7\" handlerRecall=\"false\">\n" +
                "                </recallTacheMethod>\n" +
                "                <submitUserMethod id=\"submitUserMethod7\" handlerCancel=\"false\">\n" +
                "                </submitUserMethod>\n" +
                "            </approve>\n" +
                "        </step>\n" +
                "        <step id=\"XM006\" name=\"技术规划部领导审批\" isSubprocess=\"false\">\n" +
                "            <approve id=\"approve8\" isUrge=\"false\" day=\"\" hour=\"\">\n" +
                "                <returnPhase id=\"returnPhase8\" isInitiateLink=\"false\" isBeforeLink=\"false\" isAllLink=\"false\" isStopLink=\"false\"/>\n" +
                "                <submitMethod id=\"submitMethod8\" isAgainSubmit=\"true\" isSubmitRejectLink=\"false\"/>\n" +
                "                <treatmentMethod id=\"treatmentMethod8\" method=\"3\" value=\"\"/>\n" +
                "                <timeOutProMethod id=\"timeOutProMethod8\" method=\"1\" noticeTaskId=\"\" noticeTaskName=\"\"/>\n" +
                "                <controlType id=\"controlType8\" beforeCountersign=\"false\" afterCountersign=\"false\" transferCountersign=\"false\" circulate=\"false\" noticeTaskId=\"\" noticeTaskName=\"\"/>\n" +
                "                <autoDeRepeatMethod id=\"autoDeRepeatMethod8\" theSamePerson=\"false\" keepOne=\"false\" isEmpty=\"false\">\n" +
                "                </autoDeRepeatMethod>\n" +
                "                <recallTacheMethod id=\"submitUserMethod8\" handlerRecall=\"false\">\n" +
                "                </recallTacheMethod>\n" +
                "                <submitUserMethod id=\"submitUserMethod8\" handlerCancel=\"false\">\n" +
                "                </submitUserMethod>\n" +
                "            </approve>\n" +
                "        </step>\n" +
                "        <end id=\"end18\" name=\"\">\n" +
                "        </end>\n" +
                "    </workflow>\n" +
                "<workflowDI>\n" +
                "    <object id=\"0\">\n" +
                "      <mxCell/>\n" +
                "    </object>\n" +
                "    <mxCell id=\"1\" parent=\"0\"/>\n" +
                "    <mxCell id=\"10\" style=\"edgeStyle=orthogonalEdgeStyle;rounded=0;orthogonalLoop=1;jettySize=auto;html=1;entryX=0;entryY=0.5;entryDx=0;entryDy=0;\" edge=\"1\" parent=\"1\" source=\"2\" target=\"3\">\n" +
                "      <mxGeometry relative=\"1\" as=\"geometry\"/>\n" +
                "    </mxCell>\n" +
                "    <object label=\"\" name=\"\" id=\"2\">\n" +
                "      <mxCell style=\"shape=mytriangle;whiteSpace=wrap;html=1;rounded=1;fillColor=rgba(255, 255, 255, 0.1);strokeColor=rgb(50,151,253);verticalLabelPosition=bottom;labelBackgroundColor=#ffffff;verticalAlign=top;align=center;outline=none;symbol=start;\" vertex=\"1\" parent=\"1\">\n" +
                "        <mxGeometry x=\"-609\" y=\"186\" width=\"40\" height=\"40\" as=\"geometry\"/>\n" +
                "      </mxCell>\n" +
                "    </object>\n" +
                "    <mxCell id=\"11\" style=\"edgeStyle=orthogonalEdgeStyle;rounded=0;orthogonalLoop=1;jettySize=auto;html=1;entryX=0;entryY=0.5;entryDx=0;entryDy=0;\" edge=\"1\" parent=\"1\" source=\"3\" target=\"4\">\n" +
                "      <mxGeometry relative=\"1\" as=\"geometry\"/>\n" +
                "    </mxCell>\n" +
                "    <object label=\"产品中心负责人发起项目立项\" name=\"用户步骤\" formData=\"{&quot;theSamePerson&quot;:false,&quot;keepOne&quot;:false,&quot;isEmpty&quot;:false,&quot;timeOutProMethod&quot;:&quot;1&quot;,&quot;submitMethod&quot;:&quot;isAgainSubmit&quot;,&quot;treatmentMethod&quot;:&quot;3&quot;,&quot;taskId2&quot;:&quot;&quot;,&quot;taskName2&quot;:&quot;&quot;,&quot;scaleValue&quot;:&quot;&quot;,&quot;numValue&quot;:&quot;&quot;,&quot;scriptText&quot;:&quot;&quot;}\" noticeInfoTableData=\"[]\" ruleTableData=\"[]\" serviceTableData=\"[]\" approvalCode=\"XM001\" approvalName=\"产品中心负责人发起项目立项\" id=\"3\">\n" +
                "      <mxCell style=\"html=1;whiteSpace=wrap;fillColor=rgba(50, 151, 253, 0.1);strokeColor=rgb(50,151,253);fontColor=rgb(50,151,253);symbol=userStep;\" vertex=\"1\" parent=\"1\">\n" +
                "        <mxGeometry x=\"-483\" y=\"176\" width=\"100\" height=\"60\" as=\"geometry\"/>\n" +
                "      </mxCell>\n" +
                "    </object>\n" +
                "    <mxCell id=\"12\" style=\"edgeStyle=orthogonalEdgeStyle;rounded=0;orthogonalLoop=1;jettySize=auto;html=1;entryX=0;entryY=0.5;entryDx=0;entryDy=0;\" edge=\"1\" parent=\"1\" source=\"4\" target=\"5\">\n" +
                "      <mxGeometry relative=\"1\" as=\"geometry\"/>\n" +
                "    </mxCell>\n" +
                "    <object label=\"产品中心负责人部门领导审批\" name=\"用户步骤\" formData=\"{&quot;theSamePerson&quot;:false,&quot;keepOne&quot;:false,&quot;isEmpty&quot;:false,&quot;timeOutProMethod&quot;:&quot;1&quot;,&quot;submitMethod&quot;:&quot;isAgainSubmit&quot;,&quot;treatmentMethod&quot;:&quot;3&quot;,&quot;scaleValue&quot;:&quot;&quot;,&quot;numValue&quot;:&quot;&quot;,&quot;scriptText&quot;:&quot;&quot;}\" noticeInfoTableData=\"[]\" ruleTableData=\"[]\" serviceTableData=\"[]\" approvalCode=\"XM002\" approvalName=\"产品中心负责人部门领导审批\" id=\"4\">\n" +
                "      <mxCell style=\"html=1;whiteSpace=wrap;fillColor=rgba(50, 151, 253, 0.1);strokeColor=rgb(50,151,253);fontColor=rgb(50,151,253);symbol=userStep;\" vertex=\"1\" parent=\"1\">\n" +
                "        <mxGeometry x=\"-259\" y=\"176\" width=\"100\" height=\"60\" as=\"geometry\"/>\n" +
                "      </mxCell>\n" +
                "    </object>\n" +
                "    <mxCell id=\"17\" style=\"edgeStyle=orthogonalEdgeStyle;rounded=0;orthogonalLoop=1;jettySize=auto;html=1;entryX=1;entryY=0.5;entryDx=0;entryDy=0;\" edge=\"1\" parent=\"1\" source=\"5\" target=\"6\">\n" +
                "      <mxGeometry relative=\"1\" as=\"geometry\"/>\n" +
                "    </mxCell>\n" +
                "    <object label=\"研发部门项目经理审批\" name=\"用户步骤\" formData=\"{&quot;theSamePerson&quot;:false,&quot;keepOne&quot;:false,&quot;isEmpty&quot;:false,&quot;timeOutProMethod&quot;:&quot;1&quot;,&quot;submitMethod&quot;:&quot;isAgainSubmit&quot;,&quot;treatmentMethod&quot;:&quot;3&quot;,&quot;scaleValue&quot;:&quot;&quot;,&quot;numValue&quot;:&quot;&quot;,&quot;scriptText&quot;:&quot;&quot;}\" noticeInfoTableData=\"[]\" ruleTableData=\"[]\" serviceTableData=\"[]\" approvalCode=\"XM003\" approvalName=\"研发部门项目经理审批\" id=\"5\">\n" +
                "      <mxCell style=\"html=1;whiteSpace=wrap;fillColor=rgba(50, 151, 253, 0.1);strokeColor=rgb(50,151,253);fontColor=rgb(50,151,253);symbol=userStep;\" vertex=\"1\" parent=\"1\">\n" +
                "        <mxGeometry x=\"-49\" y=\"176\" width=\"100\" height=\"60\" as=\"geometry\"/>\n" +
                "      </mxCell>\n" +
                "    </object>\n" +
                "    <mxCell id=\"19\" style=\"edgeStyle=orthogonalEdgeStyle;rounded=0;orthogonalLoop=1;jettySize=auto;html=1;entryX=1;entryY=0.5;entryDx=0;entryDy=0;\" edge=\"1\" parent=\"1\" source=\"6\" target=\"7\">\n" +
                "      <mxGeometry relative=\"1\" as=\"geometry\"/>\n" +
                "    </mxCell>\n" +
                "    <object label=\"研发部门领导审批\" name=\"用户步骤\" formData=\"{&quot;theSamePerson&quot;:false,&quot;keepOne&quot;:false,&quot;isEmpty&quot;:false,&quot;timeOutProMethod&quot;:&quot;1&quot;,&quot;submitMethod&quot;:&quot;isAgainSubmit&quot;,&quot;treatmentMethod&quot;:&quot;3&quot;,&quot;scaleValue&quot;:&quot;&quot;,&quot;numValue&quot;:&quot;&quot;,&quot;scriptText&quot;:&quot;&quot;}\" noticeInfoTableData=\"[]\" ruleTableData=\"[]\" serviceTableData=\"[]\" approvalCode=\"XM004\" approvalName=\"研发部门领导审批\" id=\"6\">\n" +
                "      <mxCell style=\"html=1;whiteSpace=wrap;fillColor=rgba(50, 151, 253, 0.1);strokeColor=rgb(50,151,253);fontColor=rgb(50,151,253);symbol=userStep;\" vertex=\"1\" parent=\"1\">\n" +
                "        <mxGeometry x=\"70\" y=\"294\" width=\"100\" height=\"60\" as=\"geometry\"/>\n" +
                "      </mxCell>\n" +
                "    </object>\n" +
                "    <mxCell id=\"20\" style=\"edgeStyle=orthogonalEdgeStyle;rounded=0;orthogonalLoop=1;jettySize=auto;html=1;entryX=1;entryY=0.5;entryDx=0;entryDy=0;\" edge=\"1\" parent=\"1\" source=\"7\" target=\"8\">\n" +
                "      <mxGeometry relative=\"1\" as=\"geometry\"/>\n" +
                "    </mxCell>\n" +
                "    <object label=\"技术规划部对口项目经理审批\" name=\"用户步骤\" formData=\"{&quot;theSamePerson&quot;:false,&quot;keepOne&quot;:false,&quot;isEmpty&quot;:false,&quot;timeOutProMethod&quot;:&quot;1&quot;,&quot;submitMethod&quot;:&quot;isAgainSubmit&quot;,&quot;treatmentMethod&quot;:&quot;3&quot;,&quot;scaleValue&quot;:&quot;&quot;,&quot;numValue&quot;:&quot;&quot;,&quot;scriptText&quot;:&quot;&quot;}\" noticeInfoTableData=\"[]\" ruleTableData=\"[]\" serviceTableData=\"[]\" approvalCode=\"XM005\" approvalName=\"技术规划部对口项目经理审批\" id=\"7\">\n" +
                "      <mxCell style=\"html=1;whiteSpace=wrap;fillColor=rgba(50, 151, 253, 0.1);strokeColor=rgb(50,151,253);fontColor=rgb(50,151,253);symbol=userStep;\" vertex=\"1\" parent=\"1\">\n" +
                "        <mxGeometry x=\"-126\" y=\"294\" width=\"100\" height=\"60\" as=\"geometry\"/>\n" +
                "      </mxCell>\n" +
                "    </object>\n" +
                "    <mxCell id=\"22\" style=\"edgeStyle=orthogonalEdgeStyle;rounded=0;orthogonalLoop=1;jettySize=auto;html=1;entryX=1;entryY=0.5;entryDx=0;entryDy=0;\" edge=\"1\" parent=\"1\" source=\"8\" target=\"18\">\n" +
                "      <mxGeometry relative=\"1\" as=\"geometry\"/>\n" +
                "    </mxCell>\n" +
                "    <object label=\"技术规划部领导审批\" name=\"用户步骤\" formData=\"{&quot;theSamePerson&quot;:false,&quot;keepOne&quot;:false,&quot;isEmpty&quot;:false,&quot;timeOutProMethod&quot;:&quot;1&quot;,&quot;submitMethod&quot;:&quot;isAgainSubmit&quot;,&quot;treatmentMethod&quot;:&quot;3&quot;,&quot;scaleValue&quot;:&quot;&quot;,&quot;numValue&quot;:&quot;&quot;,&quot;scriptText&quot;:&quot;&quot;}\" noticeInfoTableData=\"[]\" ruleTableData=\"[]\" serviceTableData=\"[]\" approvalCode=\"XM006\" approvalName=\"技术规划部领导审批\" id=\"8\">\n" +
                "      <mxCell style=\"html=1;whiteSpace=wrap;fillColor=rgba(50, 151, 253, 0.1);strokeColor=rgb(50,151,253);fontColor=rgb(50,151,253);symbol=userStep;\" vertex=\"1\" parent=\"1\">\n" +
                "        <mxGeometry x=\"-309\" y=\"294\" width=\"100\" height=\"60\" as=\"geometry\"/>\n" +
                "      </mxCell>\n" +
                "    </object>\n" +
                "    <object label=\"\" name=\"\" id=\"18\">\n" +
                "      <mxCell style=\"shape=mxgraph.bpmn.shape;html=1;verticalLabelPosition=bottom;labelBackgroundColor=#ffffff;verticalAlign=top;align=center;perimeter=ellipsePerimeter;outlineConnect=0;fillColor=none;strokeColor=rgb(50,151,253);strokeWidth=1;fontColor=rgb(50,151,253);outline=end;symbol=end;\" vertex=\"1\" parent=\"1\">\n" +
                "        <mxGeometry x=\"-403\" y=\"304\" width=\"40\" height=\"40\" as=\"geometry\"/>\n" +
                "      </mxCell>\n" +
                "    </object>\n" +
                "  </workflowDI>\n" +
                "</bpmn>";
        try {
            List<Map<String, String>> maps = parseFlowXml(xmlString);
            System.out.println(maps.toString());

            String[] refs = new String[maps.size()-1];
            Map<String, String> first = maps.stream().filter(item -> item.get("sourceRef").contains("start")).findFirst().get();
            refs[0] = first.get("targetRef");
            for (int i = 1; i < refs.length; i++) {
                for (Map<String, String> item : maps) {
                    if (item.get("sourceRef").equals(refs[i-1])){
                        refs[i] = item.get("targetRef");
                        break;
                    }
                }
            }
            for (String s: refs) {
                System.out.println(s);
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class Edge {
        String source;
        String target;

        Edge(String source, String target) {
            this.source = source;
            this.target = target;
        }
    }

}


