/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.config;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.pesapp.commom.dao.UmcInfoRspDescConvertMapper;
import com.tydic.pesapp.common.po.UmcInfoRspDescConvertPo;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;

@Component
@Aspect
@Order(value=0)
public class AppCenterAbilityRespDescResoverAspect {
    private static final Logger log = LoggerFactory.getLogger(AppCenterAbilityRespDescResoverAspect.class);
    public static final String CENTER_RESP_CODE_SUC = "0000";
    public static final String CENTER_RESP_CODE_FAI = "8888";
    public static final String CENTER_RESP_CODE_FIELD = "respCode";
    public static final String CENTER_RESP_DESC_FIELD = "respDesc";
    private static final String CENTER_RESP_MESSAGE_HASH_KEY = "CENTER_RESP_MESSAGE_HASH_KEY";
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UmcInfoRspDescConvertMapper umcInfoRspDescConvertMapper;
    @Value(value="${pesapp.common.respcode.convert.enable:true}")
    private boolean convertEnable;

    @Pointcut(value="execution(public * com.tydic.merchant.mmc.ability..*.*(..)) ")
    public void abilityPointCut() {
    }

    @Around(value="abilityPointCut()")
    public Object throwAopTreat(ProceedingJoinPoint pjp) throws Throwable {
        Object rspObj = null;
        try {
            String respCode;
            rspObj = pjp.proceed();
            if (this.convertEnable && !CENTER_RESP_CODE_SUC.equals(respCode = AppCenterAbilityRespDescResoverAspect.getRespCode(rspObj))) {
                String newRespDesc;
                if (AppCenterAbilityRespDescResoverAspect.isEmpty(this.cacheClient, CENTER_RESP_MESSAGE_HASH_KEY)) {
                    this.queryConfig();
                }
                if (!StrUtil.isEmpty((CharSequence)(newRespDesc = AppCenterAbilityRespDescResoverAspect.hget(this.cacheClient, CENTER_RESP_MESSAGE_HASH_KEY, respCode)))) {
                    AppCenterAbilityRespDescResoverAspect.setRespDesc(rspObj, newRespDesc);
                }
            }
        }
        catch (Throwable e) {
            String message = e.getMessage();
            if (rspObj != null) {
                AppCenterAbilityRespDescResoverAspect.setRespDesc(rspObj, message);
            } else if (pjp.getClass() == MethodInvocationProceedingJoinPoint.class) {
                MethodInvocationProceedingJoinPoint methodPjp = (MethodInvocationProceedingJoinPoint)pjp;
                Object methodInvocation = ReflectUtil.getFieldValue((Object)methodPjp, (String)"methodInvocation");
                Method method = (Method)ReflectUtil.getFieldValue((Object)methodInvocation, (String)"method");
                Class<?> returnType = method.getReturnType();
                Object createObj = returnType.newInstance();
                AppCenterAbilityRespDescResoverAspect.setRespDesc(createObj, message);
                AppCenterAbilityRespDescResoverAspect.setCommonErrorRespDesc(createObj);
                rspObj = createObj;
            }
            log.error("\u8c03\u7528\u5f02\u5e38:{}", (Object)message);
        }
        return rspObj;
    }

    private void queryConfig() {
        log.info("--------------------------------------------------------\u66f4\u65b0redis\u4e2drespCode\u7f13\u5b58--------------------------------------------------------");
        UmcInfoRspDescConvertPo qryPo = new UmcInfoRspDescConvertPo();
        List<UmcInfoRspDescConvertPo> umcInfoRspDescConvertPos = this.umcInfoRspDescConvertMapper.qryByCondition(qryPo);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (UmcInfoRspDescConvertPo descConvertPo : umcInfoRspDescConvertPos) {
            dataMap.put(descConvertPo.getCenterRespCode(), descConvertPo.getAppMsg());
        }
        AppCenterAbilityRespDescResoverAspect.hmset(this.cacheClient, CENTER_RESP_MESSAGE_HASH_KEY, dataMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEmpty(CacheClient cacheClient, String hashKey) {
        try (Jedis resource = null;){
            resource = cacheClient.getJedisPool().getResource();
            Boolean keyExists = resource.exists(hashKey);
            if (!keyExists.booleanValue()) {
                boolean bl = true;
                return bl;
            }
            Long hlen = resource.hlen(hashKey);
            boolean bl = hlen == 0L;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hget(CacheClient cacheClient, String hashKey, String key) {
        try (Jedis resource = null;){
            resource = cacheClient.getJedisPool().getResource();
            String string = resource.hget(hashKey, key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hmset(CacheClient cacheClient, String hashKey, Map<String, String> dataMap) {
        try (Jedis resource = null;){
            resource = cacheClient.getJedisPool().getResource();
            resource.hmset(hashKey, dataMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hset(CacheClient cacheClient, String hashKey, String key, String value) {
        try (Jedis resource = null;){
            resource = cacheClient.getJedisPool().getResource();
            resource.hset(hashKey, key, value);
        }
    }

    public static String getRespCode(Object obj) {
        return (String)ReflectUtil.getFieldValue((Object)obj, (String)CENTER_RESP_CODE_FIELD);
    }

    public static void setRespDesc(Object obj, String desc) {
        ReflectUtil.setFieldValue((Object)obj, (String)CENTER_RESP_DESC_FIELD, (Object)desc);
    }

    public static void setCommonErrorRespDesc(Object obj) {
        ReflectUtil.setFieldValue((Object)obj, (String)CENTER_RESP_CODE_FIELD, (Object)CENTER_RESP_CODE_FAI);
    }
}

