/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.controller;

import com.ohaotian.plugin.file.FileClient;
import com.tydic.pesapp.base.api.JsonBusiResponseBody;
import com.tydic.pesapp.common.ability.bo.ComPesCommonOssUploadReqBO;
import com.tydic.pesapp.common.ability.bo.ComPesCommonOssUploadRspBO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/pes/ossUpload"})
public class ComPesCommonOssUploadController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean isDebugEnable = this.logger.isDebugEnabled();
    public static final String RSP_CODE_SUCCESS = "0000";
    public static final String RSP_CODE_FAILURE = "8888";
    public static final String RSP_CODE_OSS_UOLOAD_FAILURE = "0010";
    public static final String OSS_SERVER_URL = "https://dev-zhongtai.oss-cn-beijing.aliyuncs.com/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private FileClient fileClient;

    @PostMapping(value={"/fileUpload"})
    @JsonBusiResponseBody
    public ComPesCommonOssUploadRspBO queryData(ComPesCommonOssUploadReqBO reqBO) {
        ComPesCommonOssUploadRspBO rspBO;
        if (this.isDebugEnable) {
            this.logger.debug("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (!(rspBO = this.validateParam(reqBO)).getRespCode().equals(RSP_CODE_SUCCESS)) {
            return rspBO;
        }
        try {
            byte[] b = reqBO.getInput().getBytes();
            ByteArrayInputStream input = new ByteArrayInputStream(b);
            String fileName = UUID.randomUUID() + "." + StringUtils.substringAfterLast((String)reqBO.getInput().getOriginalFilename(), (String)".");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String uploadPath = sdf.format(new Date());
            rspBO.setFilePath(fileName);
            String result = this.fileClient.uploadFileByInputStream(uploadPath, fileName, (InputStream)input);
            rspBO.setFilePath(OSS_SERVER_URL + result);
            rspBO.setFileClientType(this.fileType);
            rspBO.setRespCode(RSP_CODE_SUCCESS);
            rspBO.setRespDesc("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\u5931\u8d25", (Throwable)e);
            rspBO.setRespCode(RSP_CODE_OSS_UOLOAD_FAILURE);
            rspBO.setRespDesc("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\u5931\u8d25");
        }
        return rspBO;
    }

    private ComPesCommonOssUploadRspBO validateParam(ComPesCommonOssUploadReqBO reqBO) {
        ComPesCommonOssUploadRspBO rspBO = new ComPesCommonOssUploadRspBO();
        rspBO.setRespCode(RSP_CODE_SUCCESS);
        rspBO.setRespDesc("oss\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1\u5fc5\u4f20\u53c2\u6570-");
        if (null == reqBO.getInput()) {
            rspBO.setRespCode(RSP_CODE_FAILURE);
            rspBO.setRespDesc(rspBO.getRespDesc() + "-\u6587\u4ef6\u3010input\u3011");
        }
        return rspBO;
    }
}

