/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.estore.operator.ability.impl.deal;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.tydic.pesapp.estore.operator.ability.bo.OperatorBillNotificationInfoVO;
import com.tydic.pesapp.estore.operator.ability.bo.OperatorInvoiceDetailVO;
import com.tydic.pesapp.estore.operator.ability.deal.OperatorBusiProcessInvoiceDataInOutService;
import com.tydic.pesapp.estore.operator.ability.deal.bo.OperatorBusiProcessInvoiceInOutReqBO;
import com.tydic.pesapp.estore.operator.ability.deal.bo.OperatorBusiProcessInvoiceInOutRspBO;
import com.tydic.pesapp.estore.operator.ability.deal.bo.OperatorBusiProcessInvoiceInOutVO;
import com.tydic.pesapp.estore.operator.ability.deal.bo.OperatorInvoiceInfoVO;
import com.tydic.pfscext.api.busi.vo.BillNotificationInfoVO;
import com.tydic.pfscext.api.busi.vo.BusiProcessInvoiceInOutVO;
import com.tydic.pfscext.api.deal.BusiBillNotificationService;
import com.tydic.pfscext.api.deal.BusiPayItemService;
import com.tydic.pfscext.api.deal.QueryPayInvoiceDetailService;
import com.tydic.pfscext.api.deal.QueryPayInvoiceService;
import com.tydic.pfscext.api.deal.bo.BusiPayInvoiceInfoReqBO;
import com.tydic.pfscext.api.deal.bo.BusiPayInvoiceInfoRspBO;
import com.tydic.pfscext.api.deal.bo.BusiPayItemReqBO;
import com.tydic.pfscext.api.deal.bo.BusiPayItemRspBO;
import com.tydic.pfscext.api.deal.bo.PayInvoiceDetailBO;
import com.tydic.pfscext.api.deal.bo.PayInvoiceInfoBO;
import com.tydic.pfscext.api.deal.bo.PayItemInfoBO;
import com.tydic.pfscext.api.deal.bo.PayItemInfoExtBO;
import com.tydic.pfscext.api.deal.bo.QueryPayInvoiceDetailReqBO;
import com.tydic.pfscext.api.deal.bo.QueryPayInvoiceDetailRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OperatorBusiProcessInvoiceDataInOutServiceImpl
implements OperatorBusiProcessInvoiceDataInOutService {
    private static final Logger logger = LoggerFactory.getLogger(OperatorBusiProcessInvoiceDataInOutServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private QueryPayInvoiceService queryPayInvoiceService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private QueryPayInvoiceDetailService queryPayInvoiceDetailService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private BusiBillNotificationService busiBillNotificationService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private BusiPayItemService busiPayItemService;

    public OperatorBusiProcessInvoiceInOutRspBO processInvoiceInOut(OperatorBusiProcessInvoiceInOutReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u7968\u6570\u636e\u5bfc\u5165\u5bfc\u51fa\u5165\u53c2=" + reqBO);
        }
        OperatorBusiProcessInvoiceInOutRspBO resp = new OperatorBusiProcessInvoiceInOutRspBO();
        OperatorBusiProcessInvoiceInOutVO data = reqBO.getData();
        if (data == null) {
            resp.setRespCode("RSP_CODE_PARAM_ERROR");
            resp.setRespDesc("\u672a\u53d1\u73b0\u6709\u6548\u7684\u6570\u636e(data)");
            return resp;
        }
        Integer processType = data.getProcessType();
        String notificationNo = data.getNotificationNo();
        Long companyId = reqBO.getCompanyId();
        Long supplierNo = data.getSupplierNo();
        if (processType == null) {
            resp.setRespCode("RSP_CODE_PARAM_ERROR");
            resp.setRespDesc("\u5fc5\u987b\u6307\u5b9a\u5904\u7406\u7c7b\u578b(processType)");
            return resp;
        }
        if (companyId == null) {
            resp.setRespCode("RSP_CODE_PARAM_ERROR");
            resp.setRespDesc("\u65e0\u6cd5\u786e\u5b9a\u4e13\u4e1a\u516c\u53f8(companyId)");
            return resp;
        }
        if (supplierNo == null) {
            resp.setRespCode("RSP_CODE_PARAM_ERROR");
            resp.setRespDesc("\u5fc5\u987b\u6307\u5b9a\u4f9b\u5e94\u5546ID(supplierNo)");
            return resp;
        }
        BusiProcessInvoiceInOutVO busiProcessInvoiceInOutVO = new BusiProcessInvoiceInOutVO();
        busiProcessInvoiceInOutVO.setNotificationNo(notificationNo);
        busiProcessInvoiceInOutVO.setCompanyId(companyId);
        BillNotificationInfoVO bill = this.busiBillNotificationService.selectByPrimaryAndCompany(busiProcessInvoiceInOutVO);
        if (bill == null) {
            logger.info("\u53d1\u7968\u5bfc\u5165\u5bfc\u51fa\u5904\u7406\u5931\u8d25,\u5f00\u7968\u901a\u77e5\u5355\u4e0d\u5b58\u5728,\u901a\u77e5\u5355=" + notificationNo + ",companyID=" + companyId);
            resp.setRespCode("RSP_CODE_PARAM_ERROR");
            resp.setRespDesc("\u5f00\u7968\u901a\u77e5\u5355\"+notificationNo+\"\u4e0d\u5b58\u5728");
            return resp;
        }
        if (!bill.getSupplierNo().equals(supplierNo)) {
            logger.info("\u53d1\u7968\u5bfc\u5165\u5bfc\u51fa\u5904\u7406\u5931\u8d25,\u5f00\u7968\u901a\u77e5\u5355\u4e0d\u5c5e\u4e8e\u6307\u5b9a\u7684\u4f9b\u5e94\u5546,\u901a\u77e5\u5355=" + notificationNo + ",supplierNo=" + supplierNo);
            resp.setRespCode("RSP_CODE_PARAM_ERROR");
            resp.setRespDesc("\u5f00\u7968\u901a\u77e5\u5355" + notificationNo + "\u4e0d\u5b58\u5728!!!");
            return resp;
        }
        String invoiceStatus = bill.getInvoiceStatus();
        if (null != invoiceStatus && "03".equals(invoiceStatus)) {
            resp.setRespCode("RSP_CODE_PARAM_ERROR");
            resp.setRespDesc("\u5f00\u7968\u901a\u77e5\u5355\u53f7\u7684\u53d1\u7968\u5df2\u6536\u7968,\u4e0d\u5141\u8bb8\u518d\u5904\u7406");
            return resp;
        }
        resp.setData(new OperatorBusiProcessInvoiceInOutVO());
        if (processType == 1) {
            data = resp.getData();
            OperatorBillNotificationInfoVO vo = new OperatorBillNotificationInfoVO();
            BeanUtils.copyProperties((Object)bill, (Object)vo);
            data.setNotification(vo);
            Integer invoceType = bill.getInvoceType();
            if (invoceType != null && invoceType == 1) {
                vo.setInvoiceTypeDescr("\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968");
            } else {
                vo.setInvoiceTypeDescr("\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968");
            }
            if (StringUtils.hasText((String)vo.getBankAccNo())) {
                vo.setBankAccNo(vo.getBankAccNo().replaceAll(" ", ""));
            }
            data.setInvoices(new ArrayList());
            BusiPayItemReqBO busiPayItemReqBO = new BusiPayItemReqBO();
            busiPayItemReqBO.setNotificationNo(notificationNo);
            BusiPayItemRspBO busiPayItemRspBO = this.busiPayItemService.selectListByNotificationNo(busiPayItemReqBO);
            List payItemExtList = new ArrayList();
            if (null != busiPayItemRspBO) {
                payItemExtList = busiPayItemRspBO.getPayItemInfoExtBOs();
            }
            logger.debug("--\u5bfc\u51fa\u5f00\u7968\u901a\u77e5\u5355[" + notificationNo + "]\u6570\u636e,\u6d89\u53ca\u5546\u54c1\u660e\u7ec6\u6570\u91cf=" + payItemExtList.size());
            OperatorInvoiceInfoVO invoice = new OperatorInvoiceInfoVO();
            data.getInvoices().add(invoice);
            invoice.setNotificationNo(notificationNo);
            invoice.setInvoiceDetails(new ArrayList());
            for (PayItemInfoExtBO payItemInfoExt : payItemExtList) {
                OperatorInvoiceDetailVO ivDetail = new OperatorInvoiceDetailVO();
                invoice.getInvoiceDetails().add(ivDetail);
                ivDetail.setOrderId(payItemInfoExt.getPurchaseOrderCode());
                ivDetail.setItemNo(payItemInfoExt.getItemNo());
                ivDetail.setItemName(payItemInfoExt.getItemName());
                ivDetail.setSpecOrModel(payItemInfoExt.getSpec());
                ivDetail.setItemUnit(payItemInfoExt.getUnitName());
                ivDetail.setQuantity(payItemInfoExt.getQuantity());
                ivDetail.setPriceIntax(payItemInfoExt.getPurchaseUnitPrice());
                ivDetail.setIdentify(payItemInfoExt.getItemNo() + "-" + payItemInfoExt.getSeq());
                ivDetail.setInvoiceNo(payItemInfoExt.getInvoiceNo());
                ivDetail.setInvoiceCode(payItemInfoExt.getInvoiceCode());
                ivDetail.setInvoiceDate(payItemInfoExt.getInvoiceDate());
                ivDetail.setSkuId(payItemInfoExt.getSkuId());
                if (StringUtils.isEmpty((Object)ivDetail.getInvoiceNo()) || StringUtils.isEmpty((Object)ivDetail.getInvoiceCode())) {
                    BigDecimal rate = payItemInfoExt.getTaxRate();
                    ivDetail.setTaxRate(rate);
                    ivDetail.setAmount(payItemInfoExt.getAmount());
                    if (rate != null) {
                        rate = rate.add(new BigDecimal("1"));
                        BigDecimal untaxAmt = payItemInfoExt.getAmount().divide(rate, 2, 4);
                        ivDetail.setUntaxAmt(untaxAmt);
                        ivDetail.setTaxAmt(payItemInfoExt.getAmount().subtract(untaxAmt));
                        untaxAmt = untaxAmt.divide(payItemInfoExt.getQuantity(), 8, 4);
                        ivDetail.setPriceUntax(untaxAmt);
                    }
                } else {
                    ivDetail.setQuantity(payItemInfoExt.getRealQuantity());
                    ivDetail.setAmount(payItemInfoExt.getRealAmount());
                    ivDetail.setTaxRate(payItemInfoExt.getRealTaxrate());
                    ivDetail.setUntaxAmt(payItemInfoExt.getUntaxAmt());
                    ivDetail.setTaxAmt(payItemInfoExt.getTaxAmt());
                    ivDetail.setPriceUntax(payItemInfoExt.getPriceUntax());
                }
                StringBuilder specModelFigureNo = new StringBuilder();
                if (StringUtils.hasText((String)payItemInfoExt.getSpec())) {
                    specModelFigureNo.append(payItemInfoExt.getSpec()).append("\\");
                }
                if (StringUtils.hasText((String)payItemInfoExt.getModel())) {
                    specModelFigureNo.append(payItemInfoExt.getModel()).append("\\");
                }
                if (StringUtils.hasText((String)payItemInfoExt.getFigureNo())) {
                    specModelFigureNo.append(payItemInfoExt.getFigureNo()).append("\\");
                }
                if (specModelFigureNo.length() < 1) continue;
                ivDetail.setSpecModelFigureNo(specModelFigureNo.toString().substring(0, specModelFigureNo.length() - 1));
            }
        } else if (processType == 2) {
            List invoiceVoLs = data.getInvoices();
            if (invoiceVoLs == null || invoiceVoLs.size() == 0) {
                // empty if block
            }
            logger.debug("---\u5bfc\u5165\u53d1\u7968\u6570\u636e,\u9700\u5bfc\u5165\u7684\u53d1\u7968\u6570\u91cf:" + invoiceVoLs.size());
            BusiPayInvoiceInfoReqBO busiPayInvoiceInfoReqBO = new BusiPayInvoiceInfoReqBO();
            busiPayInvoiceInfoReqBO.setNotificationNo(notificationNo);
            List oldInvoices = new ArrayList();
            BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = this.queryPayInvoiceService.selectByNotifyNo(busiPayInvoiceInfoReqBO);
            if (null != busiPayInvoiceInfoRspBO) {
                oldInvoices = busiPayInvoiceInfoRspBO.getPayInvoiceInfoBOs();
            }
            for (PayInvoiceInfoBO oldInvoice : oldInvoices) {
                QueryPayInvoiceDetailReqBO queryPayInvoiceDetailReqBO = new QueryPayInvoiceDetailReqBO();
                queryPayInvoiceDetailReqBO.setPayInvoiceInfoBO(oldInvoice);
                this.queryPayInvoiceDetailService.deleteByInvoiceNo(queryPayInvoiceDetailReqBO);
                BusiPayInvoiceInfoReqBO payInvoiceInfoReqBO = new BusiPayInvoiceInfoReqBO();
                payInvoiceInfoReqBO.setPayInvoiceInfoBO(oldInvoice);
                this.queryPayInvoiceService.deleteByPrimaryKey(payInvoiceInfoReqBO);
            }
            BusiPayItemReqBO busiPayItemReqBO = new BusiPayItemReqBO();
            busiPayItemReqBO.setNotificationNo(notificationNo);
            BusiPayItemRspBO busiPayItemRspBO = this.busiPayItemService.selectByNotifNo(busiPayItemReqBO);
            List sampItems = new ArrayList();
            if (null != busiPayItemRspBO) {
                sampItems = busiPayItemRspBO.getPayItemInfoBOs();
            }
            if (sampItems.size() == 0) {
                resp.setRespCode("RSP_CODE_PARAM_ERROR");
                resp.setRespDesc("\u672a\u53d1\u73b0\u901a\u77e5\u5355\u76f8\u5173\u7684\u5546\u54c1\u660e\u7ec6");
                return resp;
            }
            ArrayList<Object> newInvoices = new ArrayList<Object>();
            ArrayList<PayInvoiceDetailBO> newIvDetails = new ArrayList<PayInvoiceDetailBO>();
            ArrayList<PayItemInfoBO> sampsForUpdate = new ArrayList<PayItemInfoBO>();
            HashSet<Long> payItemSeqSet = new HashSet<Long>();
            HashSet<String> invoiceNoSet = new HashSet<String>();
            BigDecimal amtTotal = BigDecimal.ZERO;
            for (OperatorInvoiceInfoVO ivVo : invoiceVoLs) {
                logger.debug("\u5f00\u7968\u660e\u7ec6" + bill.getAddr() + bill.getBankName() + bill.getPhone() + bill.getTaxNo());
                PayInvoiceInfoBO iv = new PayInvoiceInfoBO();
                BeanUtils.copyProperties((Object)ivVo, (Object)iv);
                iv.setInvoiceType(bill.getInvoceType());
                iv.setAddress(bill.getAddr());
                iv.setBankName(bill.getBankName());
                iv.setPhone(bill.getPhone());
                iv.setTaxNo(bill.getTaxNo());
                iv.setBankAcNo(bill.getBankAccNo());
                iv.setAddress(ivVo.getAddress());
                iv.setBankAcNo(ivVo.getBankAcNo());
                iv.setAmt(ivVo.getAmt());
                iv.setNotTaxAmt(ivVo.getNotTaxAmt());
                iv.setInvoiceStatus("01");
                iv.setMailStatus("01");
                List detailVoLs = ivVo.getInvoiceDetails();
                if (detailVoLs == null || detailVoLs.size() == 0) {
                    resp.setRespCode("RSP_CODE_PARAM_ERROR");
                    resp.setRespDesc("\u672a\u53d1\u73b0\u53d1\u7968\"+iv.getInvoiceNo()+\"\u7684\u660e\u7ec6\u6570\u636e");
                    return resp;
                }
                logger.debug("---\u5bfc\u5165\u53d1\u7968\u6570\u636e,\u53d1\u7968" + iv.getInvoiceNo() + "\u7684\u660e\u7ec6\u6570\u91cf=" + detailVoLs.size() + ",\u603b\u91d1\u989d=" + iv.getAmt());
                BigDecimal amt = BigDecimal.ZERO;
                BigDecimal untaxAmt = BigDecimal.ZERO;
                BigDecimal taxAmt = BigDecimal.ZERO;
                for (OperatorInvoiceDetailVO detailVo : detailVoLs) {
                    PayInvoiceDetailBO ivDetail = new PayInvoiceDetailBO();
                    BeanUtils.copyProperties((Object)detailVo, (Object)ivDetail);
                    newIvDetails.add(ivDetail);
                    if (ivDetail.getAmount() == null || BigDecimal.ZERO.compareTo(ivDetail.getAmount()) >= 0) {
                        resp.setRespCode("RSP_CODE_PARAM_ERROR");
                        resp.setRespDesc(ivDetail.getItemName() + "\u7684\u91d1\u989d\u4e0d\u6b63\u786e(\u5fc5\u987b\u5927\u4e8e0)");
                        return resp;
                    }
                    if (ivDetail.getUntaxAmt() == null || BigDecimal.ZERO.compareTo(ivDetail.getUntaxAmt()) >= 0) {
                        resp.setRespCode("RSP_CODE_PARAM_ERROR");
                        resp.setRespDesc(ivDetail.getItemName() + "\u7684\u4e0d\u542b\u7a0e\u91d1\u989d\u4e0d\u6b63\u786e(\u5fc5\u987b\u5927\u4e8e0)");
                        return resp;
                    }
                    if (ivDetail.getTaxAmt() == null || BigDecimal.ZERO.compareTo(ivDetail.getTaxAmt()) >= 0) {
                        resp.setRespCode("RSP_CODE_PARAM_ERROR");
                        resp.setRespDesc(ivDetail.getItemName() + "\u7684\u7a0e\u989d\u4e0d\u6b63\u786e(\u5fc5\u987b\u5927\u4e8e0)");
                        return resp;
                    }
                    if (ivDetail.getPriceUntax() == null || BigDecimal.ZERO.compareTo(ivDetail.getPriceUntax()) >= 0) {
                        resp.setRespCode("RSP_CODE_PARAM_ERROR");
                        resp.setRespDesc(ivDetail.getItemName() + "\u7684\u4e0d\u542b\u7a0e\u5355\u4ef7\u91d1\u989d\u4e0d\u6b63\u786e(\u5fc5\u987b\u5927\u4e8e0)");
                        return resp;
                    }
                    if (ivDetail.getTaxRate() == null || BigDecimal.ZERO.compareTo(ivDetail.getTaxRate()) >= 0) {
                        resp.setRespCode("RSP_CODE_PARAM_ERROR");
                        resp.setRespDesc(ivDetail.getItemName() + "\u7684\u7a0e\u7387\u4e0d\u6b63\u786e(\u5fc5\u987b\u5927\u4e8e0)");
                        return resp;
                    }
                    if (ivDetail.getAmount().compareTo(ivDetail.getUntaxAmt().add(ivDetail.getTaxAmt())) != 0) {
                        logger.error("\u53d1\u7968\u660e\u7ec6\u91d1\u989d(\u4e0d\u542b\u7a0e)\u3001\u7a0e\u989d\u4e4b\u548c\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u76f8\u7b49,\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
                        resp.setRespCode("RSP_CODE_PARAM_ERROR");
                        resp.setRespDesc("\u53d1\u7968\u660e\u7ec6\u91d1\u989d(\u4e0d\u542b\u7a0e)\u3001\u7a0e\u989d\u4e4b\u548c\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u76f8\u7b49");
                        return resp;
                    }
                    amt = amt.add(ivDetail.getAmount());
                    untaxAmt = untaxAmt.add(ivDetail.getUntaxAmt());
                    taxAmt = taxAmt.add(ivDetail.getTaxAmt());
                    String ordId = detailVo.getOrderId();
                    String identify = detailVo.getIdentify();
                    PayItemInfoBO matchSamp = null;
                    Iterator it = sampItems.iterator();
                    while (it.hasNext()) {
                        PayItemInfoBO samp = (PayItemInfoBO)it.next();
                        String sampIdentify = samp.getItemNo() + "-" + samp.getSeq();
                        if (!sampIdentify.equals(identify)) continue;
                        matchSamp = samp;
                        payItemSeqSet.add(matchSamp.getSeq());
                        it.remove();
                        break;
                    }
                    if (matchSamp == null) {
                        logger.error("--\u5bfc\u5165\u53d1\u7968\u6570\u636e\u5931\u8d25,\u65e0\u6cd5\u627e\u5230\u53d1\u7968\u660e\u7ec6\u5bf9\u5e94\u7684\u5546\u54c1\u660e\u7ec6,\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo() + " \u5546\u54c1=" + detailVo.getItemName() + ",\u8ba2\u5355\u53f7=" + ordId + ",\u8bc6\u522b=" + identify);
                        resp.setRespCode("RSP_CODE_PARAM_ERROR");
                        resp.setRespDesc("\u65e0\u6cd5\u627e\u5230\u539f\u59cb\u5546\u54c1\u660e\u7ec6,\u5355\u53f7\u53ca\u884c\u53f7\u4e0d\u5339\u914d,\u5546\u54c1=" + detailVo.getItemName() + ",\u8ba2\u5355\u53f7=" + ordId + ",\u884c\u53f7=" + identify);
                        return resp;
                    }
                    ivDetail.setSkuId(matchSamp.getSkuId());
                    ivDetail.setItemNo(matchSamp.getItemNo());
                    ivDetail.setOrderCode(matchSamp.getPurchaseOrderCode());
                    ivDetail.setOrderId(matchSamp.getOrderId());
                    ivDetail.setInspectionId(matchSamp.getInspectionId());
                    invoiceNoSet.add(ivDetail.getInvoiceNo());
                }
                if (amt.compareTo(untaxAmt.add(taxAmt)) != 0) {
                    logger.error("\u91d1\u989d(\u4e0d\u542b\u7a0e)\u3001\u7a0e\u989d\u4e4b\u548c\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u76f8\u7b49,\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
                    resp.setRespCode("RSP_CODE_PARAM_ERROR");
                    resp.setRespDesc("\u91d1\u989d(\u4e0d\u542b\u7a0e)\u3001\u7a0e\u989d\u4e4b\u548c\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u76f8\u7b49");
                    return resp;
                }
                iv.setAmt(amt);
                iv.setNotTaxAmt(untaxAmt);
                iv.setTaxAmt(taxAmt);
                newInvoices.add(iv);
                amtTotal = amtTotal.add(amt);
                if (amt.compareTo(iv.getAmt()) != 0) {
                    resp.setRespCode("RSP_CODE_PARAM_ERROR");
                    resp.setRespDesc("\u53d1\u7968[" + iv.getInvoiceNo() + "]\u603b\u91d1\u989d" + iv.getAmt() + "\u4e0e\u660e\u7ec6\u5408\u8ba1\u91d1\u989d" + amt + "\u4e0d\u5339\u914d,\u91d1\u989d\u8bf7\u586b\u5199\u4fdd\u75592\u4f4d\u5c0f\u6570\u540e\u7684\u503c");
                    return resp;
                }
                if (untaxAmt.compareTo(iv.getNotTaxAmt()) != 0) {
                    resp.setRespCode("RSP_CODE_PARAM_ERROR");
                    resp.setRespDesc("\u53d1\u7968[" + iv.getInvoiceNo() + "]\u4e0d\u542b\u7a0e\u603b\u91d1\u989d" + iv.getNotTaxAmt() + "\u4e0e\u660e\u7ec6\u5408\u8ba1\u91d1\u989d" + untaxAmt + "\u4e0d\u5339\u914d,\u91d1\u989d\u8bf7\u586b\u5199\u4fdd\u75592\u4f4d\u5c0f\u6570\u540e\u7684\u503c");
                    return resp;
                }
                if (taxAmt.compareTo(iv.getTaxAmt()) == 0) continue;
                resp.setRespCode("RSP_CODE_PARAM_ERROR");
                resp.setRespDesc("\u53d1\u7968[" + iv.getInvoiceNo() + "]\u603b\u7a0e\u989d" + iv.getTaxAmt() + "\u4e0e\u660e\u7ec6\u5408\u8ba1\u91d1\u989d" + taxAmt + "\u4e0d\u5339\u914d,\u91d1\u989d\u8bf7\u586b\u5199\u4fdd\u75592\u4f4d\u5c0f\u6570\u540e\u7684\u503c");
                return resp;
            }
            if (sampItems.size() > 0) {
                logger.error("--\u5bfc\u5165\u53d1\u7968\u6570\u636e\u5931\u8d25,\u53d1\u7968\u660e\u7ec6\u4e0e\u539f\u59cb\u5546\u54c1\u4e0d\u4e00\u81f4,\u53d1\u7968\u660e\u7ec6\u5c11" + sampItems.size() + "\u7b14,\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
                resp.setRespCode("RSP_CODE_PARAM_ERROR");
                resp.setRespDesc("\u901a\u77e5\u5355\u6d89\u53ca\u7684\u5f00\u7968\u5546\u54c1\u660e\u7ec6\u8d44\u6599\u4e0d\u5339\u914d,\u7f3a\u5c11" + sampItems.size() + "\u7b14\u660e\u7ec6");
                return resp;
            }
            this.clearOldInvoice(bill.getNotificationNo());
            QueryPayInvoiceDetailReqBO addreqBO = new QueryPayInvoiceDetailReqBO();
            addreqBO.setNewIvDetails(newIvDetails);
            this.queryPayInvoiceDetailService.insertByBatch(addreqBO);
            BusiPayInvoiceInfoReqBO newInvoicesBO = new BusiPayInvoiceInfoReqBO();
            newInvoicesBO.setNewIvDetails(newInvoices);
            this.queryPayInvoiceService.batchInsert(newInvoicesBO);
            for (PayItemInfoBO payItemInfo : sampItems) {
                if (!payItemSeqSet.contains(payItemInfo.getSeq())) continue;
                Long itemNo = payItemInfo.getItemNo();
                Long inspectionId = payItemInfo.getInspectionId();
                BigDecimal payItemAmount = payItemInfo.getAmount();
                if (!payItemSeqSet.contains(payItemInfo.getSeq())) {
                    logger.error("--\u5bfc\u5165\u53d1\u7968\u6570\u636e\u5931\u8d25,\u53d1\u7968\u660e\u7ec6\u4e0e\u539f\u59cb\u5546\u54c1\u4e0d\u4e00\u81f4,\u53d1\u7968\u660e\u7ec6\u7f3a\u5931\u5546\u54c1\u884c\u4e3a" + payItemInfo.getSeq() + "-" + payItemInfo.getItemNo() + "\u7684\u660e\u7ec6,\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
                }
                payItemInfo.setInvoiceNoSet(invoiceNoSet);
                QueryPayInvoiceDetailReqBO payItemInfoBO = new QueryPayInvoiceDetailReqBO();
                payItemInfoBO.setPayItemInfo(payItemInfo);
                QueryPayInvoiceDetailRspBO payDetailsInfo = this.queryPayInvoiceDetailService.selectBySomeConditions(payItemInfoBO);
                logger.debug("\u53d1\u7968\u660e\u7ec6\u91d1\u989d\u4e3a:" + payDetailsInfo.getPayInvoiceDetailBO().getAmount() + ",\u5546\u54c1\u91d1\u989d\u4e3a:" + payItemAmount + ", \u5546\u54c1\u660e\u7ec6\u4e3b\u952e\u4e3a\uff1a" + payItemInfo.getSeq());
                if (payItemAmount.compareTo(payDetailsInfo.getPayInvoiceDetailBO().getAmount()) != 0) {
                    String payItemInfoIdentify = payItemInfo.getItemNo() + "-" + payItemInfo.getSeq();
                    logger.error("--\u5546\u54c1\u7684\u5f00\u7968\u660e\u7ec6\u91d1\u989d\u4e0e\u5546\u54c1\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u5546\u54c1\u884c\u53f7-\u5546\u54c1ID\uff1a" + payItemInfoIdentify + ",\u901a\u77e5\u5355\u53f7=" + bill.getNotificationNo());
                }
                PayItemInfoBO updatePayItemInfo = new PayItemInfoBO();
                updatePayItemInfo.setInvoiceCode(payDetailsInfo.getPayInvoiceDetailBO().getInvoiceCode());
                updatePayItemInfo.setInvoiceNo(payDetailsInfo.getPayInvoiceDetailBO().getInvoiceNo());
                updatePayItemInfo.setItemStatus("02");
                updatePayItemInfo.setSeq(payItemInfo.getSeq());
                sampsForUpdate.add(updatePayItemInfo);
            }
            if (amtTotal.compareTo(bill.getAmt()) >= 0) {
                BillNotificationInfoVO forUpdate = new BillNotificationInfoVO();
                forUpdate.setNotificationNo(bill.getNotificationNo());
                forUpdate.setInvoiceStatus("02");
                this.busiBillNotificationService.updateByPrimaryKeySelective(forUpdate);
            }
            this.updateSampsInvoiceNo(notificationNo, sampsForUpdate);
            logger.info("--\u5bfc\u5165\u901a\u77e5\u5355[" + bill.getNotificationNo() + "]\u53d1\u7968\u5b8c\u6210,\u53d1\u7968\u6570\u91cf=" + newInvoices.size());
        } else {
            resp.setCode("RSP_CODE_PARAM_ERROR");
            resp.setMessage("\u65e0\u6cd5\u8bc6\u522b\u7684\u5904\u7406\u7c7b\u578b(processType)");
            return resp;
        }
        resp.setRespCode("0000");
        return resp;
    }

    private void clearOldInvoice(String notificationNo) {
        BusiPayInvoiceInfoReqBO reqBO = new BusiPayInvoiceInfoReqBO();
        reqBO.setNotificationNo(notificationNo);
        List ls = new ArrayList();
        BusiPayInvoiceInfoRspBO busiPayInvoiceInfoRspBO = this.queryPayInvoiceService.selectByNotifyNo(reqBO);
        if (null != busiPayInvoiceInfoRspBO) {
            ls = busiPayInvoiceInfoRspBO.getPayInvoiceInfoBOs();
        }
        logger.info("--\u901a\u77e5\u5355[" + notificationNo + "]\u6d89\u53ca\u7684\u9700\u6e05\u9664\u65e7\u53d1\u7968\u6570\u91cf=" + ls.size());
        for (PayInvoiceInfoBO iv : ls) {
            QueryPayInvoiceDetailReqBO ivs = new QueryPayInvoiceDetailReqBO();
            ivs.setPayInvoiceInfoBO(iv);
            this.queryPayInvoiceDetailService.deleteByInvoiceNo(ivs);
            BusiPayInvoiceInfoReqBO BusiPayInvoiceInfoReqBO2 = new BusiPayInvoiceInfoReqBO();
            BusiPayInvoiceInfoReqBO2.setPayInvoiceInfoBO(iv);
            this.queryPayInvoiceService.deleteByPrimaryKey(BusiPayInvoiceInfoReqBO2);
        }
    }

    private void updateSampsInvoiceNo(String notificationNo, List<PayItemInfoBO> sampsForUpdate) {
        if (sampsForUpdate.size() == 0) {
            return;
        }
        for (PayItemInfoBO item : sampsForUpdate) {
            BusiPayInvoiceInfoReqBO itemBO = new BusiPayInvoiceInfoReqBO();
            itemBO.setPayItemInfoBO(item);
            BusiPayInvoiceInfoRspBO cnt = this.queryPayInvoiceService.updateByPrimaryKeySelective(itemBO);
            logger.info("\u5bfc\u5165\u53d1\u7968,\u66f4\u65b0\u5546\u54c1\u660e\u7ec6,\u901a\u77e5\u5355\u53f7=" + notificationNo + ",\u5546\u54c1seq=" + item.getSeq() + ",\u53d1\u7968\u53f7=" + item.getInvoiceNo() + ",\u66f4\u65b0\u6570=" + cnt);
        }
    }

    private OperatorBusiProcessInvoiceInOutRspBO zeroCheck(OperatorBusiProcessInvoiceInOutRspBO resp, BigDecimal amt, String errMsg) {
        if (amt == null || BigDecimal.ZERO.compareTo(amt) >= 0) {
            logger.error(errMsg);
            resp.setRespCode("RSP_CODE_PARAM_ERROR");
            resp.setRespDesc(errMsg);
        }
        return resp;
    }
}

