/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.estore.operator.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.tydic.pesapp.estore.operator.ability.OpeFscApplyMailImportInvoiceService;
import com.tydic.pesapp.estore.operator.ability.bo.OpeFscBaseRspBo;
import com.tydic.pesapp.estore.operator.ability.bo.OpeFscFileAppBO;
import com.tydic.pesapp.estore.operator.ability.util.OperatorFscExcelUtils;
import com.tydic.pfscext.api.busi.BusiApplyMailImportInvoiceService;
import com.tydic.pfscext.api.busi.bo.BusiApplyMailImportInvoiceReqBO;
import com.tydic.pfscext.api.busi.bo.BusiApplyMailImportInvoiceRowReqBO;
import com.tydic.pfscext.base.PfscExtRspBaseBO;
import com.tydic.pfscext.common.ExcelFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OpeFscApplyMailImportInvoiceServiceImpl
implements OpeFscApplyMailImportInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(OpeFscApplyMailImportInvoiceServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private BusiApplyMailImportInvoiceService busiApplyMailImportInvoiceService;
    private String[][] columns = new String[][]{{"invoiceNo", "A", "S"}};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpeFscBaseRspBo importInvoice(OpeFscFileAppBO opeFscFileAppBO) {
        OpeFscBaseRspBo rspBO = new OpeFscBaseRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String fileName = opeFscFileAppBO.getFileName();
        boolean isE2007 = false;
        String e07Suffix = "xlsx";
        if (fileName.endsWith(e07Suffix)) {
            isE2007 = true;
        }
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(opeFscFileAppBO.getFile());
            ExcelFile excel = new ExcelFile((InputStream)inputStream, isE2007);
            if (!excel.isReady()) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u65e0\u6cd5\u89e3\u6790Excel\u6587\u4ef6");
                OpeFscBaseRspBo opeFscBaseRspBo = rspBO;
                return opeFscBaseRspBo;
            }
            BusiApplyMailImportInvoiceReqBO reqBO = new BusiApplyMailImportInvoiceReqBO();
            reqBO.setUserId(opeFscFileAppBO.getUserId());
            ArrayList<BusiApplyMailImportInvoiceRowReqBO> rows = new ArrayList<BusiApplyMailImportInvoiceRowReqBO>();
            reqBO.setRows(rows);
            String readData = this.readData(excel, fileName, rows);
            if (StringUtils.hasText((String)readData)) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc(readData);
                OpeFscBaseRspBo opeFscBaseRspBo = rspBO;
                return opeFscBaseRspBo;
            }
            excel.close();
            if (rows.size() == 0) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u672a\u8bfb\u53d6\u5230\u53d1\u7968\u6570\u636e");
                OpeFscBaseRspBo opeFscBaseRspBo = rspBO;
                return opeFscBaseRspBo;
            }
            PfscExtRspBaseBO resp = this.busiApplyMailImportInvoiceService.process(reqBO);
            if (resp == null || !"0000".equals(resp.getRespCode())) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc(resp == null ? "\u5931\u8d25" : resp.getRespDesc());
                OpeFscBaseRspBo opeFscBaseRspBo = rspBO;
                return opeFscBaseRspBo;
            }
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\u3002\u6587\u4ef6\u540d\uff1a" + fileName, (Throwable)e);
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25");
            OpeFscBaseRspBo opeFscBaseRspBo = rspBO;
            return opeFscBaseRspBo;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\u3002\u6587\u4ef6\u540d\uff1a" + fileName, (Throwable)e);
                    rspBO.setRespCode("18000");
                    rspBO.setRespDesc("\u5931\u8d25");
                }
            }
        }
        return rspBO;
    }

    private String readData(ExcelFile excel, String filename, List<BusiApplyMailImportInvoiceRowReqBO> rows) {
        List dataRows = excel.readRows(0, 0, -1);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        for (int i = 0; i < dataRows.size(); ++i) {
            BusiApplyMailImportInvoiceRowReqBO row = new BusiApplyMailImportInvoiceRowReqBO();
            String[] fields = (String[])dataRows.get(i);
            map.clear();
            OperatorFscExcelUtils.arrayToMap(fields, this.columns, map);
            try {
                BeanUtils.populate((Object)row, map);
            }
            catch (Exception e) {
                logger.error("populate error\u3002\u6587\u4ef6\u540d\uff1a" + filename, (Throwable)e);
            }
            if (i == 0) {
                if (StringUtils.hasText((String)row.getInvoiceNo()) && !Pattern.matches("[0-9]*", row.getInvoiceNo())) continue;
                return "\u8bf7\u52ff\u5220\u9664\u7b2c\u4e00\u884c\u8868\u5934";
            }
            if (!StringUtils.hasText((String)row.getInvoiceNo())) continue;
            if (row.getInvoiceNo().contains(".")) {
                row.setInvoiceNo(row.getInvoiceNo().replace(".0", ""));
            }
            rows.add(row);
        }
        return null;
    }
}

