/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.extension.ability.aop;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.IPUtils;
import com.tydic.order.pec.ability.UocPebOrderFlowAbilityService;
import com.tydic.order.pec.ability.bo.UocOrderFlowReqBO;
import com.tydic.order.uoc.bo.common.annotation.OrderFlowLog;
import com.tydic.order.uoc.constant.UocConstant;
import com.tydic.pesapp.base.api.PesappBusinessException;
import com.tydic.pesapp.extension.ability.bo.PesappExtensionEstoreSubmitAfterSaleApplyInfoBO;
import com.tydic.pesapp.extension.ability.bo.PesappExtensionZoneSubmitAfterSaleApplyInfoBO;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@Order(value=200)
public class OrderFlowAspect {
    private static final Logger log = LoggerFactory.getLogger(OrderFlowAspect.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UOC_GROUP_DEV")
    private UocPebOrderFlowAbilityService uocPebOrderFlowAbilityService;

    @Pointcut(value="@annotation(com.tydic.order.uoc.bo.common.annotation.OrderFlowLog)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object result = null;
        try {
            result = point.proceed();
            this.saveOrderFlowLog(point, result);
        }
        catch (ZTBusinessException e) {
            log.error("\u8ba2\u5355\u6d41\u8f6c\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            String msg = e.resolverException();
            throw new PesappBusinessException(msg);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        catch (Throwable e) {
            log.error("\u8ba2\u5355\u6d41\u8f6c\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new Throwable(e);
        }
        return result;
    }

    private void saveOrderFlowLog(ProceedingJoinPoint joinPoint, Object result) {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        String ip = IPUtils.getIp((HttpServletRequest)request);
        log.info("\u672c\u6b21\u64cd\u4f5c\u7684ip\u5730\u5740\u662f\uff1a{}", (Object)ip);
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        OrderFlowLog orderFlowLog = method.getAnnotation(OrderFlowLog.class);
        String description = orderFlowLog.description();
        log.info("\u672c\u6b21\u64cd\u4f5c\u63cf\u8ff0\uff1a{}", (Object)description);
        String operationLink = orderFlowLog.operationLink();
        log.info("\u672c\u6b21\u64cd\u4f5c\u8282\u70b9\uff1a{}", (Object)operationLink);
        UocOrderFlowReqBO recordReqBO = new UocOrderFlowReqBO();
        Object[] args = joinPoint.getArgs();
        JSONObject params = JSON.parseObject((String)JSON.toJSONString((Object)args[0]));
        log.info("\u5165\u53c2\u7684\u53c2\u6570\uff1a{}", (Object)params);
        String userId = params.getString("userId");
        String userName = params.getString("username");
        String orgName = params.getString("orgName");
        recordReqBO.setDealCompName(params.getString("companyName"));
        recordReqBO.setDealDeptName(orgName);
        recordReqBO.setDealPostName(params.getString("name"));
        recordReqBO.setDealOperId(userId);
        recordReqBO.setDealOperName(userName);
        JSONObject response = JSON.parseObject((String)JSON.toJSONString((Object)result));
        log.info("\u672c\u6b21\u6267\u884c\u7684\u8fd4\u56de\u7ed3\u679c\u662f\uff1a{}", (Object)response);
        recordReqBO.setDealTypeName(operationLink);
        recordReqBO.setDealDesc(description + (response.getString("respDesc") == null ? "" : response.getString("respDesc")));
        recordReqBO.setIpAddress(ip);
        recordReqBO.setDealTime(new Date());
        if ("\u9a8c\u6536".equals(description)) {
            recordReqBO.setDealReason(params.getString("operatorReason"));
            this.buildBaseOrderFlowInfo(operationLink, recordReqBO, params);
        } else {
            this.dealAfterSaleApply(operationLink, recordReqBO, params);
        }
    }

    private void buildBaseOrderFlowInfo(String operationLink, UocOrderFlowReqBO recordReqBO, JSONObject params) {
        recordReqBO.setDealName(operationLink);
        recordReqBO.setOrderId(params.getLong("orderId"));
        recordReqBO.setSaleVoucherId(params.getLong("saleVoucherId"));
        this.buildOrderLog(recordReqBO);
    }

    private void dealAfterSaleApply(String operationLink, UocOrderFlowReqBO recordReqBO, JSONObject params) {
        if ("1".equals(params.getString("pageType"))) {
            String orderInfo = params.getString("estoreSubmitAfterSaleApplyInfo");
            if (StringUtils.isNotBlank((CharSequence)orderInfo)) {
                PesappExtensionEstoreSubmitAfterSaleApplyInfoBO afterSaleApplyInfo = (PesappExtensionEstoreSubmitAfterSaleApplyInfoBO)JSON.parseObject((String)orderInfo, PesappExtensionEstoreSubmitAfterSaleApplyInfoBO.class);
                operationLink = this.getServiceType(operationLink, afterSaleApplyInfo.getServiceType());
                recordReqBO.setDealName(operationLink);
                recordReqBO.setDealReason(afterSaleApplyInfo.getQuestionDesc());
                recordReqBO.setOrderId(afterSaleApplyInfo.getOrderId());
            }
        } else {
            String orderInfo = params.getString("zoneSubmitAfterSaleApplyInfo");
            if (StringUtils.isNotBlank((CharSequence)orderInfo)) {
                PesappExtensionZoneSubmitAfterSaleApplyInfoBO afterSaleApplyInfo = (PesappExtensionZoneSubmitAfterSaleApplyInfoBO)JSON.parseObject((String)orderInfo, PesappExtensionZoneSubmitAfterSaleApplyInfoBO.class);
                operationLink = this.getServiceType(operationLink, afterSaleApplyInfo.getServiceType());
                recordReqBO.setDealName(operationLink);
                recordReqBO.setDealReason(afterSaleApplyInfo.getQuestionDesc());
                recordReqBO.setOrderId(afterSaleApplyInfo.getOrderId());
                recordReqBO.setSaleVoucherId(afterSaleApplyInfo.getSaleVoucherId());
            }
        }
        this.buildOrderLog(recordReqBO);
    }

    private String getServiceType(String operationLink, String type) {
        switch (type) {
            case "10": {
                operationLink = operationLink + "(\u9000\u8d27)";
                break;
            }
            case "20": {
                operationLink = operationLink + "(\u6362\u8d27)";
                break;
            }
            default: {
                operationLink = operationLink + "(\u7ef4\u4fee)";
            }
        }
        return operationLink;
    }

    private void buildOrderLog(UocOrderFlowReqBO recordReqBO) {
        recordReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        recordReqBO.setRecordType(UocConstant.BUSI_OPER_RECORD_TYPE.ORDER_OPER_RECORD);
        recordReqBO.setCreateTime(new Date());
        this.uocPebOrderFlowAbilityService.dealAfterSaleRequest(recordReqBO);
        log.info("\u8bb0\u5f55\u8ba2\u5355\u6d41\u6c34\u4fe1\u606f\u6210\u529f...{}", (Object)recordReqBO);
    }
}

