/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.mall.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.commodity.bo.ability.SkuInfoImageBo;
import com.tydic.commodity.bo.busi.CommodityImageBo;
import com.tydic.commodity.bo.busi.QryCommodityDetailListReqBO;
import com.tydic.commodity.bo.busi.QrySkusDetailListReqBO;
import com.tydic.order.extend.ability.saleorder.PebExtSelfCreateOrderAbilityService;
import com.tydic.order.extend.bo.saleorder.PebExtSelfCreateOrderReqBO;
import com.tydic.order.extend.bo.saleorder.PebExtSelfCreateOrderRspBO;
import com.tydic.order.extend.bo.saleorder.PebExtThirdSupplierSkuInfo;
import com.tydic.order.pec.atom.es.order.bo.SkuInfoRspBO;
import com.tydic.order.pec.constant.PecConstant;
import com.tydic.order.third.intf.bo.pay.BusiAddPayConfigExceptRspBO;
import com.tydic.pesapp.mall.ability.DingdangMallGenerateOrderService;
import com.tydic.pesapp.mall.ability.bo.DingdangMallGenerateOrderReqBO;
import com.tydic.pesapp.mall.ability.bo.DingdangMallGenerateOrderRspBO;
import com.tydic.pesapp.mall.ability.bo.PesappMallGenerateOrderSkuInfoBO;
import com.tydic.pfscext.api.busi.BusiPayConfigDetailQryDetailService;
import com.tydic.pfscext.api.busi.bo.PayConfigDetailFscQryListReqBo;
import com.tydic.pfscext.api.busi.bo.PayConfigDetailFscQryListRspBo;
import com.tydic.uccext.bo.UccCnncCommodityListsAbilityReqBO;
import com.tydic.uccext.bo.UccCnncCommodityListsAbilityRspBO;
import com.tydic.uccext.bo.UccCommodityAndSkusDetailRspBO;
import com.tydic.uccext.bo.UccSkuDetailListInfoBO;
import com.tydic.uccext.service.UccCnncCommodityListsAbilityService;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umc.ability.org.UmcEnterpriseOrgQueryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DingdangMallGenerateOrderServiceImpl
implements DingdangMallGenerateOrderService {
    private static final Logger log = LoggerFactory.getLogger(DingdangMallGenerateOrderServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UOC_GROUP_TEST")
    private PebExtSelfCreateOrderAbilityService pebExtSelfCreateOrderAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcEnterpriseOrgQueryAbilityService umcEnterpriseOrgQueryAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private BusiPayConfigDetailQryDetailService busiPayConfigDetailQryDetailService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UCC_TEST")
    private UccCnncCommodityListsAbilityService uccCommodityListsAbilityService;

    public DingdangMallGenerateOrderRspBO createSelfOrder(DingdangMallGenerateOrderReqBO reqBO) {
        this.validReq(reqBO);
        PebExtSelfCreateOrderReqBO pebExtSelfCreateOrderReqBO = (PebExtSelfCreateOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebExtSelfCreateOrderReqBO.class);
        UmcEnterpriseOrgDetailAbilityRspBO orgInfo = this.getOrgInfo(reqBO.getOrgId());
        pebExtSelfCreateOrderReqBO.setProPhone(orgInfo.getUmcEnterpriseOrgAbilityBO().getPhone());
        pebExtSelfCreateOrderReqBO.setProName(orgInfo.getUmcEnterpriseOrgAbilityBO().getOrgName());
        pebExtSelfCreateOrderReqBO.setProPath(orgInfo.getUmcEnterpriseOrgAbilityBO().getLinkMan());
        BusiAddPayConfigExceptRspBO payConfInfo = this.getPayConfInfo(reqBO.getCompanyId());
        pebExtSelfCreateOrderReqBO.setPayConfig(payConfInfo);
        List<PebExtThirdSupplierSkuInfo> skuInfoList = this.queryAndHandGoodsInfo(reqBO.getSaleOrderItemList());
        pebExtSelfCreateOrderReqBO.setSaleOrderItemList(skuInfoList);
        pebExtSelfCreateOrderReqBO.setOrderWay("1");
        PebExtSelfCreateOrderRspBO rspBO = this.pebExtSelfCreateOrderAbilityService.createSelfOrder(pebExtSelfCreateOrderReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException(rspBO.getRespDesc());
        }
        return (DingdangMallGenerateOrderRspBO)JSON.parseObject((String)JSON.toJSONString((Object)rspBO), DingdangMallGenerateOrderRspBO.class);
    }

    private BusiAddPayConfigExceptRspBO getPayConfInfo(Long companyId) {
        PayConfigDetailFscQryListReqBo payConfigDetailFscQryListReqBo = new PayConfigDetailFscQryListReqBo();
        payConfigDetailFscQryListReqBo.setExceptId(companyId);
        PayConfigDetailFscQryListRspBo payConfigDetailFscQryListRspBo = this.busiPayConfigDetailQryDetailService.qryPayConfigDetailOrPayConfig(payConfigDetailFscQryListReqBo);
        if ("0".equals(payConfigDetailFscQryListRspBo.getCode())) {
            return (BusiAddPayConfigExceptRspBO)JSON.parseObject((String)JSON.toJSONString((Object)payConfigDetailFscQryListRspBo), BusiAddPayConfigExceptRspBO.class);
        }
        BusiAddPayConfigExceptRspBO rspBO = new BusiAddPayConfigExceptRspBO();
        rspBO.setBalance(new BigDecimal("999883578.480000"));
        rspBO.setCheckPaymentRatio(new BigDecimal("0.00"));
        rspBO.setDays(Integer.valueOf(1));
        rspBO.setDwnPaymentRatio(new BigDecimal("0.00"));
        rspBO.setIsExcept(Integer.valueOf(0));
        rspBO.setExceptId(Long.valueOf(400000010000056574L));
        rspBO.setExceptName("\u4e2d\u56fd\u540c\u8f90\u80a1\u4efd\u6709\u9650\u516c\u53f8");
        rspBO.setIsExceptStr("");
        rspBO.setOverdraftQuota(new BigDecimal("1000000000.000000"));
        rspBO.setPayBusiType("1");
        rspBO.setPayConfigDetailId(Long.valueOf(517394446939226112L));
        rspBO.setPaySubClass("0");
        rspBO.setPaySubType("1");
        rspBO.setPayType("2");
        rspBO.setPayTypeStr("");
        rspBO.setRemark("");
        rspBO.setUpdateUserId(Long.valueOf(495317256162811904L));
        rspBO.setUpdateUserName("cnsc_fy");
        rspBO.setUsedQuota(new BigDecimal("116421.520000"));
        log.debug("\u672a\u67e5\u5230\u652f\u4ed8\u914d\u7f6e\u6570\u636e\uff0c\u4f7f\u7528\u66ff\u4ee3\u503c");
        return rspBO;
    }

    private UmcEnterpriseOrgDetailAbilityRspBO getOrgInfo(Long orgId) {
        UmcEnterpriseOrgQueryAbilityReqBO umcEnterpriseOrgQueryAbilityReqBO = new UmcEnterpriseOrgQueryAbilityReqBO();
        umcEnterpriseOrgQueryAbilityReqBO.setOrgIdWeb(orgId);
        UmcEnterpriseOrgDetailAbilityRspBO umcEnterpriseOrgDetailAbilityRspBO = this.umcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(umcEnterpriseOrgQueryAbilityReqBO);
        if ("0000".equals(umcEnterpriseOrgDetailAbilityRspBO.getRespCode())) {
            return umcEnterpriseOrgDetailAbilityRspBO;
        }
        throw new ZTBusinessException(umcEnterpriseOrgDetailAbilityRspBO.getRespDesc());
    }

    public List<PebExtThirdSupplierSkuInfo> queryAndHandGoodsInfo(List<PesappMallGenerateOrderSkuInfoBO> saleOrderItemList) {
        Map<String, List<PesappMallGenerateOrderSkuInfoBO>> collect = saleOrderItemList.parallelStream().collect(Collectors.groupingBy(PesappMallGenerateOrderSkuInfoBO::getSupplierShopId));
        ArrayList<QrySkusDetailListReqBO> skuList = new ArrayList<QrySkusDetailListReqBO>(collect.size());
        ArrayList<QryCommodityDetailListReqBO> spuList = new ArrayList<QryCommodityDetailListReqBO>(collect.size());
        this.checkAndBuildQueryParams(collect, skuList, spuList);
        UccCnncCommodityListsAbilityReqBO uccReqBO = new UccCnncCommodityListsAbilityReqBO();
        uccReqBO.setSkusDetailListReqBOS(skuList);
        uccReqBO.setCommodityDetailListReqBOS(spuList);
        log.debug("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)uccReqBO));
        UccCnncCommodityListsAbilityRspBO rspBO = this.uccCommodityListsAbilityService.queryCommodityListsInfo(uccReqBO);
        log.debug("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBO));
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException(rspBO.getRespDesc());
        }
        ArrayList<PebExtThirdSupplierSkuInfo> handedSaleOrderItemList = new ArrayList<PebExtThirdSupplierSkuInfo>();
        Map skuInfoMap = saleOrderItemList.parallelStream().collect(Collectors.toMap(o -> o.getSkuId(), Function.identity()));
        for (UccCommodityAndSkusDetailRspBO uccCommodityAndSkusDetailRspBO : rspBO.getUccCommodityAndSkusDetailRspBOS()) {
            if (CollectionUtils.isEmpty((Collection)uccCommodityAndSkusDetailRspBO.getUccSkusDetailBO().getUccSkuDetailListInfoBOList())) continue;
            for (UccSkuDetailListInfoBO detail : uccCommodityAndSkusDetailRspBO.getUccSkusDetailBO().getUccSkuDetailListInfoBOList()) {
                log.debug("\u5546\u54c1\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)detail));
                PebExtThirdSupplierSkuInfo pebExtThirdSupplierSkuInfo = (PebExtThirdSupplierSkuInfo)JSON.parseObject((String)JSON.toJSONString((Object)detail), PebExtThirdSupplierSkuInfo.class);
                PesappMallGenerateOrderSkuInfoBO orderSkuInfo = (PesappMallGenerateOrderSkuInfoBO)skuInfoMap.get(String.valueOf(detail.getSkuId()));
                if (orderSkuInfo == null) continue;
                BeanUtils.copyProperties((Object)orderSkuInfo, (Object)pebExtThirdSupplierSkuInfo);
                try {
                    pebExtThirdSupplierSkuInfo.setSkuAgreementPrice(MoneyUtils.Long2BigDecimal((Long)detail.getSkuInfoPrice().getAgreementPrice()));
                    pebExtThirdSupplierSkuInfo.setSkuMarketPrice(MoneyUtils.Long2BigDecimal((Long)detail.getSkuInfoPrice().getMarketPrice()));
                    pebExtThirdSupplierSkuInfo.setSkuMemberPrice(MoneyUtils.Long2BigDecimal((Long)detail.getSkuInfoPrice().getMemberPrice1()));
                    pebExtThirdSupplierSkuInfo.setSkuSalePrice(MoneyUtils.Long2BigDecimal((Long)detail.getSkuInfoPrice().getSalePrice()));
                    pebExtThirdSupplierSkuInfo.setSkuCurrencyType(String.valueOf(detail.getSkuInfoPrice().getCurrencyType()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ZTBusinessException("\u5546\u54c1\u4ef7\u683c\u67e5\u8be2\u9519\u8bef");
                }
                pebExtThirdSupplierSkuInfo.setVendorId(uccCommodityAndSkusDetailRspBO.getVendorId());
                pebExtThirdSupplierSkuInfo.setSelfSkuSupplierName(uccCommodityAndSkusDetailRspBO.getVendorName());
                this.setSkuMainPicUrl((SkuInfoRspBO)pebExtThirdSupplierSkuInfo, detail, uccCommodityAndSkusDetailRspBO);
                handedSaleOrderItemList.add(pebExtThirdSupplierSkuInfo);
            }
        }
        return handedSaleOrderItemList;
    }

    private void setSkuMainPicUrl(SkuInfoRspBO out, UccSkuDetailListInfoBO skuInfomationBo, UccCommodityAndSkusDetailRspBO uccCommodityAndSkusDetailRspBO) {
        List list = skuInfomationBo.getSkuImags();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            for (SkuInfoImageBo imageBO : list) {
                if (imageBO.getCommodityPicType() == null || !imageBO.getCommodityPicType().equals(PecConstant.COMMODITYPIC_TYPE.MAIN)) continue;
                out.setSkuMainPicUrl(imageBO.getSkuPicUrl());
                break;
            }
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)out.getSkuMainPicUrl())) {
            List commdImageInfo = uccCommodityAndSkusDetailRspBO.getCommdImageInfo();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)commdImageInfo)) {
                return;
            }
            for (CommodityImageBo imageBo : commdImageInfo) {
                if (imageBo.getCommodityPicType() == null || !imageBo.getCommodityPicType().equals(PecConstant.COMMODITYPIC_TYPE.MAIN)) continue;
                out.setSkuMainPicUrl(imageBo.getCommodityPicUrl());
                break;
            }
        }
    }

    private void checkAndBuildQueryParams(Map<String, List<PesappMallGenerateOrderSkuInfoBO>> collect, List<QrySkusDetailListReqBO> skuList, List<QryCommodityDetailListReqBO> spuList) {
        for (Map.Entry<String, List<PesappMallGenerateOrderSkuInfoBO>> entry : collect.entrySet()) {
            String supplierShopId = entry.getKey();
            if (StringUtils.isEmpty((String)supplierShopId)) {
                throw new ZTBusinessException("\u4e0b\u5355\u5931\u8d25\uff0c\u5546\u54c1\u4f9b\u5e94\u5546\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            List<PesappMallGenerateOrderSkuInfoBO> skuInfoList = entry.getValue();
            QrySkusDetailListReqBO qrySkusDetailListReqBO = new QrySkusDetailListReqBO();
            qrySkusDetailListReqBO.setSupplierShopId(Long.valueOf(Long.parseLong(supplierShopId)));
            qrySkusDetailListReqBO.setSkuId((Long[])skuInfoList.parallelStream().map(o -> Long.parseLong(o.getSkuId())).toArray(Long[]::new));
            qrySkusDetailListReqBO.setSkuInfo(skuInfoList.parallelStream().collect(Collectors.toMap(o -> Long.parseLong(o.getSkuId()), o -> {
                if (o.getPurchaseCount() == null || o.getPurchaseCount().compareTo(BigDecimal.ZERO) < 0) {
                    throw new ZTBusinessException("\u4e0b\u5355\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u6709\u6548\u5546\u54c1\u4e0b\u5355\u6570\u91cf");
                }
                return o.getPurchaseCount();
            })));
            skuList.add(qrySkusDetailListReqBO);
            QryCommodityDetailListReqBO listReqBO = new QryCommodityDetailListReqBO();
            listReqBO.setSupplierShopId(Long.valueOf(Long.parseLong(supplierShopId)));
            listReqBO.setCommodityId((Long[])skuInfoList.parallelStream().map(o -> o.getSpuId()).toArray(Long[]::new));
            spuList.add(listReqBO);
        }
    }

    private void validReq(DingdangMallGenerateOrderReqBO reqBO) {
        if (!"1".equals(reqBO.getIsProfessionalOrgExt())) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u9646\u8eab\u4efd\u4e0d\u63d0\u4f9b\u4e0b\u5355\u670d\u52a1,\u8bf7\u5207\u6362\u7ec4\u7ec7\u673a\u6784\u4e3a\u91c7\u8d2d\u540e\u8fdb\u884c\u4e0b\u5355");
        }
        if (reqBO.getAddressInfo() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u6536\u8d27\u5730\u5740\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSaleOrderItemList())) {
            throw new ZTBusinessException("\u4e0b\u5355\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
        }
    }
}

