/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.user.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.common.user.api.DycCommonEnterpriseUserRegisterService;
import com.tydic.dyc.common.user.bo.DycCommonEnterpriseUserRegisterReqBO;
import com.tydic.dyc.common.user.bo.DycCommonEnterpriseUserRegisterRspBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseUserRegisteredAbilityService;
import com.tydic.umc.general.ability.bo.UmcEnterpriseUserRegisteredAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseUserRegisteredAbilityRspBO;
import java.util.Collection;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycCommonEnterpriseUserRegisterServiceImpl
implements DycCommonEnterpriseUserRegisterService {
    @Autowired
    private UmcEnterpriseUserRegisteredAbilityService umcEnterpriseUserRegisteredAbilityService;

    public DycCommonEnterpriseUserRegisterRspBO enterpriseUserRegister(DycCommonEnterpriseUserRegisterReqBO reqBO) {
        this.validateReqArgs(reqBO);
        DycCommonEnterpriseUserRegisterRspBO rspBO = new DycCommonEnterpriseUserRegisterRspBO();
        UmcEnterpriseUserRegisteredAbilityReqBO umcReqBO = new UmcEnterpriseUserRegisteredAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)umcReqBO);
        umcReqBO.setOrgCodeWeb(this.getRandom());
        int length = reqBO.getCompanyNameWeb().length() > 10 ? 10 : reqBO.getCompanyNameWeb().length();
        umcReqBO.setAliasWeb(reqBO.getCompanyNameWeb().substring(0, length));
        umcReqBO.setOrgCertificateCode(RandomStringUtils.randomNumeric((int)18));
        umcReqBO.setRegEmail("abc@mail.com");
        umcReqBO.setPhoneNumber(reqBO.getRegMobile());
        umcReqBO.setEmailCheck("0000");
        umcReqBO.setSmsCheck("0000");
        UmcEnterpriseUserRegisteredAbilityRspBO umcRspBO = this.umcEnterpriseUserRegisteredAbilityService.dealEnterpriseUserRegistered(umcReqBO);
        if (umcRspBO.getRespCode().equals("0000")) {
            BeanUtils.copyProperties((Object)umcRspBO, (Object)rspBO);
            return rspBO;
        }
        throw new ZTBusinessException(umcRspBO.getRespDesc());
    }

    private void validateReqArgs(DycCommonEnterpriseUserRegisterReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getRegAccount())) {
            throw new ZTBusinessException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPasswd())) {
            throw new ZTBusinessException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getConfirmPasswd())) {
            throw new ZTBusinessException("\u786e\u540d\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getTradeCapacity())) {
            throw new ZTBusinessException("\u6350\u8d60\u8eab\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCompanyNameWeb())) {
            throw new ZTBusinessException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getMemName2())) {
            throw new ZTBusinessException("\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getRegMobile())) {
            throw new ZTBusinessException("\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCertNo())) {
            throw new ZTBusinessException("\u8bc1\u660e\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String getRandom() {
        StringBuffer randomStr = new StringBuffer();
        for (int i = 1; i < 10; ++i) {
            long num = Math.round(Math.random() * 25.0 + 65.0);
            randomStr.append((char)num);
        }
        return randomStr.toString();
    }
}

