/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.communal.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.ListUtils;
import com.tydic.commodity.common.ability.api.UccDicDictionaryAbilityService;
import com.tydic.commodity.common.ability.bo.UccDictionaryAddReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryAddRspBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryDeleteReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryDeleteRspBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryRspBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryUpdateReqBO;
import com.tydic.commodity.common.ability.bo.UccDictionaryUpdateRspBO;
import com.tydic.dyc.common.communal.api.ComPesDictionaryOperateService;
import com.tydic.dyc.common.communal.bo.ComPesDicDataOperateReqBO;
import com.tydic.dyc.common.communal.bo.ComPesDicDataOperateRspBO;
import com.tydic.dyc.common.communal.bo.ComPesDicDataQueryReqBO;
import com.tydic.dyc.common.communal.bo.ComPesDicDataQueryRspBO;
import com.tydic.dyc.common.communal.bo.ComPesDictionaryCodeBO;
import com.tydic.dyc.common.communal.bo.ComRefreshCodeListRspBO;
import com.tydic.fsc.base.FscRspPageBaseBO;
import com.tydic.fsc.bo.FscDicDictionaryReqBO;
import com.tydic.fsc.common.ability.api.FscDictionaryAbilityService;
import com.tydic.fsc.common.ability.bo.FscDictionaryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscQueryDictionaryAbilityReqBO;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.general.ability.api.DictionaryAbilityService;
import com.tydic.umc.general.ability.api.UmcPesDicQryListByConfigKeysAbilityService;
import com.tydic.umc.general.ability.bo.DictionaryAbilityRspBO;
import com.tydic.umc.general.ability.bo.QueryDictionaryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDicDictionaryReqBO;
import com.tydic.umc.general.ability.bo.UmcPesDicConfigBO;
import com.tydic.umc.general.ability.bo.UmcPesDicQryListByConfigKeysAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcPesDicQryListByConfigKeysAbilityRspBO;
import com.tydic.uoc.common.ability.api.UocPebDictionaryAbilityService;
import com.tydic.uoc.common.ability.bo.UocCoreDictionaryCreateReqBO;
import com.tydic.uoc.common.ability.bo.UocCoreDictionaryCreateRspBO;
import com.tydic.uoc.common.ability.bo.UocCoreDictionaryDeleteReqBO;
import com.tydic.uoc.common.ability.bo.UocCoreDictionaryDeleteRspBO;
import com.tydic.uoc.common.ability.bo.UocCoreDictionaryReqBO;
import com.tydic.uoc.common.ability.bo.UocCoreDictionaryRspBO;
import com.tydic.uoc.common.ability.bo.UocCoreDictionaryUpdateReqBO;
import com.tydic.uoc.common.ability.bo.UocCoreDictionaryUpdateRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ComPesDictionaryOperateServiceImpl
implements ComPesDictionaryOperateService {
    private static final Logger log = LoggerFactory.getLogger(ComPesDictionaryOperateServiceImpl.class);
    public static final int DICTIONARY_KEY_EXPIRE = 3600;
    public static final String DICTIONARY_KEY_PREFIX = "PES_DIC_";
    public static final String RSP_CODE_SUCCESS = "0000";
    public static final String RSP_CODE_FAILURE = "9999";
    public static final String PEB_CODE = "PEB";
    public static final String UMC_CODE = "UMC";
    public static final String UCC_CODE = "UCC";
    public static final String FSC_CODE = "FSC";
    public static final String AGR_CODE = "AGR";
    public static final Integer QUERY = 0;
    public static final Integer INSERT = 1;
    public static final Integer UPDATE = 2;
    public static final Integer DELETE = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComPesDictionaryOperateServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UmcPesDicQryListByConfigKeysAbilityService umcPesDicQryListByConfigKeysAbilityService;
    @Autowired
    private UocPebDictionaryAbilityService uocPebDictionaryAbilityService;
    @Autowired
    private DictionaryAbilityService umcDictionaryAbilityService;
    @Autowired
    private UccDicDictionaryAbilityService uccDicDictionaryAbilityService;
    @Autowired
    private FscDictionaryAbilityService fscDictionaryAbilityService;
    private static Map<String, BiFunction<Integer, ComPesDictionaryCodeBO, List<ComPesDictionaryCodeBO>>> dicActionMap = Maps.newHashMapWithExpectedSize((int)4);

    public ComPesDictionaryOperateServiceImpl() {
        dicActionMap.put(PEB_CODE, this::callPebDicService);
        dicActionMap.put(UMC_CODE, this::callUmcDicService);
        dicActionMap.put(UCC_CODE, this::callUccDicService);
        dicActionMap.put(FSC_CODE, this::callFscDicService);
        dicActionMap.put(AGR_CODE, this::callAgrDicService);
    }

    public ComPesDicDataQueryRspBO queryCodeList(ComPesDicDataQueryReqBO reqBO) {
        ComPesDicDataQueryRspBO rspBO = new ComPesDicDataQueryRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getConfigKeys())) {
            rspBO.setRespCode(RSP_CODE_FAILURE);
            rspBO.setRespDesc("\u4f20\u5165[configKeys]\u4e3a\u7a7a");
            return rspBO;
        }
        HashMap rspData = Maps.newHashMapWithExpectedSize((int)reqBO.getConfigKeys().size());
        List<String> callConfigKeys = this.cacheDataProcess(reqBO.getConfigKeys(), rspData);
        if (!CollectionUtils.isEmpty(callConfigKeys)) {
            UmcPesDicQryListByConfigKeysAbilityReqBO umcPesDicQryListByConfigKeysAbilityReqBO = new UmcPesDicQryListByConfigKeysAbilityReqBO();
            umcPesDicQryListByConfigKeysAbilityReqBO.setCallConfigKeys(callConfigKeys);
            log.info("umcPesDicQryListByConfigKeysAbilityReqBO ===================================" + umcPesDicQryListByConfigKeysAbilityReqBO.toString());
            UmcPesDicQryListByConfigKeysAbilityRspBO umcPesDicQryListByConfigKeysAbilityRspBO = this.umcPesDicQryListByConfigKeysAbilityService.qryPesDicListByConfigKeys(umcPesDicQryListByConfigKeysAbilityReqBO);
            log.info("umcPesDicQryListByConfigKeysAbilityRspBO ===================================" + umcPesDicQryListByConfigKeysAbilityRspBO.toString());
            List configList = umcPesDicQryListByConfigKeysAbilityRspBO.getConfigList();
            if (CollectionUtils.isEmpty((Collection)configList)) {
                rspBO.setRespCode(RSP_CODE_FAILURE);
                rspBO.setRespDesc("\u83b7\u53d6\u5b57\u5178\u914d\u7f6e\u4e3a\u7a7a\uff0ccallConfigKeys=" + callConfigKeys.toString());
                return rspBO;
            }
            Map<String, UmcPesDicConfigBO> dicMap = configList.stream().collect(Collectors.toMap(UmcPesDicConfigBO::getConfigKey, Function.identity()));
            HashMap<String, UmcPesDicConfigBO> pCodeMap = new HashMap<String, UmcPesDicConfigBO>();
            for (UmcPesDicConfigBO comPesDicConfigPO : configList) {
                pCodeMap.put(comPesDicConfigPO.getPCode(), comPesDicConfigPO);
            }
            pCodeMap.keySet().forEach(pCodeKey -> this.cacheClient.delete(pCodeKey));
            log.info("dicMap =======================================" + dicMap.toString());
            log.info("callConfigKeys ======================================" + callConfigKeys.toString());
            log.info("rspData ======================================" + ((Object)rspData).toString());
            this.dicDataProcess(callConfigKeys, dicMap, rspData);
        }
        rspBO.setData((Map)rspData);
        rspBO.setRespCode(RSP_CODE_SUCCESS);
        rspBO.setRespDesc("\u83b7\u53d6\u6570\u636e\u6210\u529f");
        return rspBO;
    }

    public ComPesDicDataOperateRspBO dealCodeOperate(ComPesDicDataOperateReqBO reqBO) {
        if (reqBO.getOperateType() == null) {
            throw new ZTBusinessException("\u4f20\u5165[operateType]\u4e3a\u7a7a");
        }
        if (!(INSERT.equals(reqBO.getOperateType()) || UPDATE.equals(reqBO.getOperateType()) || DELETE.equals(reqBO.getOperateType()))) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b[operateType]");
        }
        if (StringUtils.isEmpty((Object)reqBO.getCenter())) {
            throw new ZTBusinessException("\u4f20\u5165[center]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getConfigKey())) {
            throw new ZTBusinessException("\u4f20\u5165[configKey]\u4e3a\u7a7a");
        }
        if (dicActionMap.get(reqBO.getCenter()) == null) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u4e2d\u5fc3\u5b57\u5178\u670d\u52a1\uff0ccenter=" + reqBO.getCenter());
        }
        ComPesDictionaryCodeBO dictionaryCode = reqBO.getDictionaryCode();
        if (StringUtils.isEmpty((Object)dictionaryCode.getCode()) || dictionaryCode.getCode().trim().length() < 1) {
            throw new ZTBusinessException("\u4f20\u5165\u7f16\u7801\u4e3a\u7a7a" + reqBO.getCenter());
        }
        if (StringUtils.isEmpty((Object)dictionaryCode.getTitle()) || dictionaryCode.getTitle().trim().length() < 1) {
            throw new ZTBusinessException("\u4f20\u5165\u5b57\u5178\u4e3a\u7a7a" + reqBO.getCenter());
        }
        List<ComPesDictionaryCodeBO> rspInfo = dicActionMap.get(reqBO.getCenter()).apply(reqBO.getOperateType(), dictionaryCode);
        ComPesDicDataOperateRspBO rspBO = new ComPesDicDataOperateRspBO();
        rspBO.setRespCode(rspInfo.get(0).getRespCode());
        rspBO.setRespDesc(rspInfo.get(0).getRespDesc());
        if (RSP_CODE_SUCCESS.equals(rspBO.getRespCode())) {
            ComPesDicDataQueryReqBO refreshReqBO = new ComPesDicDataQueryReqBO();
            refreshReqBO.setConfigKeys(Collections.singletonList(reqBO.getConfigKey()));
            this.refreshCodeList(refreshReqBO);
        }
        return rspBO;
    }

    public ComRefreshCodeListRspBO refreshCodeList(ComPesDicDataQueryReqBO reqBO) {
        ComRefreshCodeListRspBO rspBO = new ComRefreshCodeListRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getConfigKeys())) {
            LOGGER.error("\u4f20\u5165[configKeys]\u4e3a\u7a7a");
            rspBO.setRespCode(RSP_CODE_SUCCESS);
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        reqBO.getConfigKeys().forEach(config -> this.cacheClient.delete(DICTIONARY_KEY_PREFIX + config));
        this.queryCodeList(reqBO);
        rspBO.setRespCode(RSP_CODE_SUCCESS);
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<String> cacheDataProcess(List<String> configKeys, Map<String, List<ComPesDictionaryCodeBO>> rspData) {
        ArrayList notExistsKeys = Lists.newArrayListWithExpectedSize((int)configKeys.size());
        for (String configKey : configKeys) {
            List dicList = (List)this.cacheClient.get(DICTIONARY_KEY_PREFIX + configKey);
            if (CollectionUtils.isEmpty((Collection)dicList)) {
                notExistsKeys.add(configKey);
                continue;
            }
            rspData.put(configKey, dicList);
        }
        return notExistsKeys;
    }

    private void dicDataProcess(List<String> configKeys, Map<String, UmcPesDicConfigBO> dicMap, Map<String, List<ComPesDictionaryCodeBO>> rspData) {
        for (String configKey : configKeys) {
            if (dicMap.get(configKey) == null) {
                rspData.put(configKey, Lists.newArrayList());
                LOGGER.error("\u672a\u83b7\u53d6\u5230\u5b57\u5178\u914d\u7f6e\uff0cconfigKey=" + configKey);
                continue;
            }
            UmcPesDicConfigBO dicInfo = dicMap.get(configKey);
            if (dicActionMap.get(dicInfo.getCenter()) == null) {
                rspData.put(configKey, Lists.newArrayList());
                LOGGER.error("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u4e2d\u5fc3\u5b57\u5178\u670d\u52a1\uff0ccenter=" + dicInfo.getCenter());
                continue;
            }
            ComPesDictionaryCodeBO param = new ComPesDictionaryCodeBO();
            param.setPCode(dicInfo.getPCode());
            List<ComPesDictionaryCodeBO> dicList = dicActionMap.get(dicInfo.getCenter()).apply(QUERY, param);
            rspData.put(configKey, dicList);
            if (CollectionUtils.isEmpty(dicList)) {
                LOGGER.info("{}\u5b57\u5178\u670d\u52a1\u672a\u8fd4\u56de\u5b57\u5178\u6570\u636e\uff0cpCode={}", (Object)dicInfo.getCenter(), (Object)dicInfo.getPCode());
                continue;
            }
            this.cacheClient.set(DICTIONARY_KEY_PREFIX + configKey, dicList, ComPesDictionaryOperateServiceImpl.getExpireSeconds(3600, 10));
        }
    }

    public static int getExpireSeconds(int radix, int range) {
        return radix * (new Random().nextInt(range) + 1);
    }

    private List<ComPesDictionaryCodeBO> callAgrDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        log.info("dictionaryCode ================================" + dictionaryCode.toString());
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callPebDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            UocCoreDictionaryReqBO reqBO = new UocCoreDictionaryReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            UocCoreDictionaryRspBO qryRspBO = this.uocPebDictionaryAbilityService.qryDic(reqBO);
            List rspList = qryRspBO.getRows();
            return CollectionUtils.isEmpty((Collection)rspList) ? Lists.newArrayList() : ListUtils.copyListProperties((List)rspList, ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            UocCoreDictionaryCreateReqBO reqBO = new UocCoreDictionaryCreateReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            reqBO.setPCode(dictionaryCode.getPCode());
            UocCoreDictionaryCreateRspBO addRspBO = this.uocPebDictionaryAbilityService.createDic(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            UocCoreDictionaryUpdateReqBO reqBO = new UocCoreDictionaryUpdateReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            reqBO.setPCode(dictionaryCode.getPCode());
            UocCoreDictionaryUpdateRspBO updateRspBO = this.uocPebDictionaryAbilityService.updateDic(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            UocCoreDictionaryDeleteReqBO reqBO = new UocCoreDictionaryDeleteReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            UocCoreDictionaryDeleteRspBO delRspBO = this.uocPebDictionaryAbilityService.deleteDic(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callUmcDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            QueryDictionaryAbilityReqBO reqBO = new QueryDictionaryAbilityReqBO();
            reqBO.setPcode(dictionaryCode.getPCode());
            UmcRspListBO qryRspBO = this.umcDictionaryAbilityService.queryBypCodeBackPo(reqBO);
            return CollectionUtils.isEmpty((Collection)qryRspBO.getRows()) ? Lists.newArrayList() : ListUtils.copyListProperties((List)qryRspBO.getRows(), ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            UmcDicDictionaryReqBO reqBO = new UmcDicDictionaryReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            DictionaryAbilityRspBO addRspBO = this.umcDictionaryAbilityService.addDicDictionary(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            UmcDicDictionaryReqBO reqBO = new UmcDicDictionaryReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            DictionaryAbilityRspBO updateRspBO = this.umcDictionaryAbilityService.updateDicDictionary(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            UmcDicDictionaryReqBO reqBO = new UmcDicDictionaryReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            DictionaryAbilityRspBO delRspBO = this.umcDictionaryAbilityService.deleteDicDictionary(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callUccDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            UccDictionaryReqBO reqBO = new UccDictionaryReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            UccDictionaryRspBO qryRspBO = this.uccDicDictionaryAbilityService.queryDictionary(reqBO);
            return CollectionUtils.isEmpty((Collection)qryRspBO.getRows()) ? Lists.newArrayList() : ListUtils.copyListProperties((List)qryRspBO.getRows(), ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            UccDictionaryAddReqBO reqBO = new UccDictionaryAddReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            UccDictionaryAddRspBO addRspBO = this.uccDicDictionaryAbilityService.insertDictionary(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            UccDictionaryUpdateReqBO reqBO = new UccDictionaryUpdateReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            UccDictionaryUpdateRspBO updateRspBO = this.uccDicDictionaryAbilityService.updateDictionary(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            UccDictionaryDeleteReqBO reqBO = new UccDictionaryDeleteReqBO();
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            UccDictionaryDeleteRspBO delRspBO = this.uccDicDictionaryAbilityService.deleteDictionary(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callFscDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            FscQueryDictionaryAbilityReqBO reqBO = new FscQueryDictionaryAbilityReqBO();
            reqBO.setPcode(dictionaryCode.getPCode());
            FscRspPageBaseBO qryRspBO = this.fscDictionaryAbilityService.queryBypCodeBackPo(reqBO);
            return CollectionUtils.isEmpty((Collection)qryRspBO.getRows()) ? Lists.newArrayList() : ListUtils.copyListProperties((List)qryRspBO.getRows(), ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            FscDicDictionaryReqBO reqBO = new FscDicDictionaryReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            FscDictionaryAbilityRspBO addRspBO = this.fscDictionaryAbilityService.addDicDictionary(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            FscDicDictionaryReqBO reqBO = new FscDicDictionaryReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            FscDictionaryAbilityRspBO updateRspBO = this.fscDictionaryAbilityService.updateDicDictionary(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            FscDicDictionaryReqBO reqBO = new FscDicDictionaryReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            FscDictionaryAbilityRspBO delRspBO = this.fscDictionaryAbilityService.deleteDicDictionary(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }
}

