/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillSupplierCheckBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSupplierCheckBusiOrderItemBO;
import com.tydic.fsc.bill.busi.bo.FscBillSupplierCheckBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSupplierCheckBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.RelOrderItemBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderFailLogUpdateAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderSyncCheckStatusReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderSyncCheckStatusRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderSyncCheckStatusAbilityService;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultItemMapper;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultItemPO;
import com.tydic.fsc.po.FscCheckResultPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBillSupplierCheckBusiServiceImpl
implements FscBillSupplierCheckBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSupplierCheckBusiServiceImpl.class);
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscCheckResultItemMapper fscCheckResultItemMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscUocOrderSyncCheckStatusAbilityService fscUocOrderSyncCheckStatusAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscOrderFailLogUpdateAtomService fscOrderFailLogUpdateAtomService;
    public static final String BUSI_NAME = "\u4e3b\u5355\u53d1\u7968\u5bf9\u8d26";
    public static final String BUSI_CODE = "1004";

    @Override
    public FscBillSupplierCheckBusiRspBO dealSupplierCheck(FscBillSupplierCheckBusiReqBO reqBO, String type) {
        List acceptOrderIds;
        List fscCheckResultPos;
        List<FscBillSupplierCheckBusiOrderItemBO> relOrderList = reqBO.getRelOrderList();
        if ("1".equals(type)) {
            FscAcceptOrderListQueryAtomReqBO queryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            List acceptCodeList = relOrderList.stream().map(FscBillSupplierCheckBusiOrderItemBO::getAcceptOrderCode).collect(Collectors.toList());
            queryAtomReqBO.setInspectionVoucherCodeList(acceptCodeList);
            FscAcceptOrderListQueryAtomRspBO atomRspBO = this.fscAcceptOrderListQueryAtomService.query(queryAtomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new FscBusinessException("193013", atomRspBO.getRespDesc());
            }
            Map fscOrderInfoBoMap = atomRspBO.getFscOrderInfoBoMap();
            if (!CollectionUtils.isEmpty((Map)fscOrderInfoBoMap) && fscOrderInfoBoMap.size() == acceptCodeList.size()) {
                Map<String, FscOrderInfoBO> fscOrderInfoMap = fscOrderInfoBoMap.values().stream().collect(Collectors.toMap(FscOrderInfoBO::getAcceptOrderNo, fscOrderInfo -> fscOrderInfo));
                for (FscBillSupplierCheckBusiOrderItemBO orderItemBO : relOrderList) {
                    orderItemBO.setOrderId(fscOrderInfoMap.get(orderItemBO.getAcceptOrderCode()).getOrderId());
                    orderItemBO.setAcceptOrderId(fscOrderInfoMap.get(orderItemBO.getAcceptOrderCode()).getAcceptOrderId());
                }
            } else {
                throw new FscBusinessException("193013", "\u8bf7\u52ff\u4fee\u6539\u9a8c\u6536\u5355\u53f7");
            }
        }
        if ((fscCheckResultPos = this.fscCheckResultMapper.selectByAcceptOrderIds(acceptOrderIds = relOrderList.stream().map(FscBillSupplierCheckBusiOrderItemBO::getAcceptOrderId).collect(Collectors.toList()))).size() != 0) {
            List acceptOrderIdList = fscCheckResultPos.stream().map(FscCheckResultPO::getAcceptOrderId).collect(Collectors.toList());
            List deleteList = relOrderList.stream().filter(fscBillSupplierCheckBO -> acceptOrderIdList.contains(fscBillSupplierCheckBO.getAcceptOrderId())).collect(Collectors.toList());
            List deleteAcceptOrderIdList = deleteList.stream().map(FscBillSupplierCheckBusiOrderItemBO::getAcceptOrderId).collect(Collectors.toList());
            int delete = this.fscCheckResultMapper.deleteByAcceptIdList(deleteAcceptOrderIdList);
            if (deleteAcceptOrderIdList.size() != delete) {
                throw new FscBusinessException("193013", "\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            }
            int itemDelete = this.fscCheckResultItemMapper.deleteByAcceptOrderId(deleteAcceptOrderIdList);
            if (itemDelete < 1) {
                throw new FscBusinessException("193013", "\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            }
        }
        this.insert(relOrderList, reqBO);
        FscBillSupplierCheckBusiRspBO rspBO = new FscBillSupplierCheckBusiRspBO();
        if ("2".equals(type)) {
            FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            flowAtomReqBO.setOrderId(reqBO.getOrderId());
            flowAtomReqBO.setCurStatus(FscBillStatus.TO_BE_RECONCILED.getCode());
            flowAtomReqBO.setBusiName(BUSI_NAME);
            flowAtomReqBO.setBusiCode(BUSI_CODE);
            FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
            if (!"0000".equals(flowAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193013", flowAtomRspBO.getRespDesc());
            }
            for (FscBillSupplierCheckBusiOrderItemBO fscBillSupplierCheckBusiOrderItemBO : relOrderList) {
                FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO = new FscUocOrderSyncCheckStatusReqBO();
                uocOrderSyncCheckStatusReqBO.setInspectionVoucherId(fscBillSupplierCheckBusiOrderItemBO.getAcceptOrderId());
                uocOrderSyncCheckStatusReqBO.setOrderId(fscBillSupplierCheckBusiOrderItemBO.getOrderId());
                BigDecimal amount = fscBillSupplierCheckBusiOrderItemBO.getAmount();
                BigDecimal relAmount = fscBillSupplierCheckBusiOrderItemBO.getRelAmount();
                uocOrderSyncCheckStatusReqBO.setCheckState(amount.compareTo(relAmount) == 0 ? FscConstants.BillCheck.EQUALS : FscConstants.BillCheck.NOT_EQUALS);
                FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO = this.fscUocOrderSyncCheckStatusAbilityService.dealSyncCheckStatus(uocOrderSyncCheckStatusReqBO);
                if ("0000".equals(uocOrderSyncCheckStatusRspBO.getRespCode())) continue;
                this.writeFailLog(uocOrderSyncCheckStatusRspBO, uocOrderSyncCheckStatusReqBO, reqBO);
            }
        }
        return rspBO;
    }

    private void insert(List<FscBillSupplierCheckBusiOrderItemBO> relOrderList, FscBillSupplierCheckBusiReqBO reqBO) {
        Date checkTime = new Date();
        for (FscBillSupplierCheckBusiOrderItemBO fscBillSupplierCheckBusiOrderItemBO : relOrderList) {
            FscCheckResultPO fscCheckResultPo = new FscCheckResultPO();
            fscCheckResultPo.setAcceptOrderId(fscBillSupplierCheckBusiOrderItemBO.getAcceptOrderId());
            fscCheckResultPo.setOrderId(fscBillSupplierCheckBusiOrderItemBO.getOrderId());
            fscCheckResultPo.setOtherNo(String.valueOf(reqBO.getOrgId()));
            BigDecimal amount = fscBillSupplierCheckBusiOrderItemBO.getAmount();
            BigDecimal relAmount = fscBillSupplierCheckBusiOrderItemBO.getRelAmount();
            fscCheckResultPo.setAmount(amount);
            fscCheckResultPo.setOtherAmount(relAmount);
            fscCheckResultPo.setSupplierId(reqBO.getSupplierId());
            fscCheckResultPo.setStatus(amount.compareTo(relAmount) == 0 ? FscConstants.BillCheck.EQUALS : FscConstants.BillCheck.NOT_EQUALS);
            fscCheckResultPo.setCheckTime(checkTime);
            fscCheckResultPo.setOperId(reqBO.getUserId());
            fscCheckResultPo.setOperName(reqBO.getName());
            int insert = this.fscCheckResultMapper.insert(fscCheckResultPo);
            if (1 != insert) {
                throw new FscBusinessException("193013", "\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            }
            List<RelOrderItemBO> relOrderitemList = fscBillSupplierCheckBusiOrderItemBO.getRelOrderitemList();
            for (RelOrderItemBO relOrderItemBO : relOrderitemList) {
                FscCheckResultItemPO fscCheckResultItemPo = new FscCheckResultItemPO();
                long id = Sequence.getInstance().nextId();
                fscCheckResultItemPo.setId(Long.valueOf(id));
                fscCheckResultItemPo.setAcceptOrderId(fscBillSupplierCheckBusiOrderItemBO.getAcceptOrderId());
                fscCheckResultItemPo.setOrderId(fscBillSupplierCheckBusiOrderItemBO.getOrderId());
                fscCheckResultItemPo.setFscOrderId(reqBO.getOrderId());
                fscCheckResultItemPo.setSkuId(relOrderItemBO.getSkuId());
                fscCheckResultItemPo.setPrice(relOrderItemBO.getPrice());
                fscCheckResultItemPo.setNum(relOrderItemBO.getNum());
                fscCheckResultItemPo.setAmount(relOrderItemBO.getNum().multiply(relOrderItemBO.getPrice()));
                fscCheckResultItemPo.setOtherNum(relOrderItemBO.getOtherNum());
                fscCheckResultItemPo.setRemark(relOrderItemBO.getRemark());
                int insert1 = this.fscCheckResultItemMapper.insert(fscCheckResultItemPo);
                if (1 == insert1) continue;
                throw new FscBusinessException("193013", "\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            }
        }
    }

    private void writeFailLog(FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO, FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO, FscBillSupplierCheckBusiReqBO reqBO) {
        Map<Long, FscBillSupplierCheckBusiOrderItemBO> orderItemBoMap = reqBO.getRelOrderList().stream().collect(Collectors.toMap(FscBillSupplierCheckBusiOrderItemBO::getOrderId, o -> o));
        FscOrderFailLogUpdateAtomReqBO fscOrderFailLogUpdateAtomReqBO = new FscOrderFailLogUpdateAtomReqBO();
        long id = Sequence.getInstance().nextId();
        fscOrderFailLogUpdateAtomReqBO.setId(Long.valueOf(id));
        fscOrderFailLogUpdateAtomReqBO.setObjId(uocOrderSyncCheckStatusReqBO.getOrderId());
        fscOrderFailLogUpdateAtomReqBO.setObjNo(orderItemBoMap.get(uocOrderSyncCheckStatusReqBO.getOrderId()).getOrderCode());
        fscOrderFailLogUpdateAtomReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.ORDER_CHECK_STATUS_SYNC);
        fscOrderFailLogUpdateAtomReqBO.setBusiFailDesc(uocOrderSyncCheckStatusRspBO.getRespDesc());
        FscOrderFailLogUpdateAtomRspBO fscOrderFailLogUpdateAtomRspBO = this.fscOrderFailLogUpdateAtomService.dealInsert(fscOrderFailLogUpdateAtomReqBO);
        if (!"0000".equals(fscOrderFailLogUpdateAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193013", fscOrderFailLogUpdateAtomRspBO.getRespDesc());
        }
    }
}

