/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.fsc.bo.FscMerchantPayeeChannelDataBO;
import com.tydic.fsc.busibase.atom.api.FscMerchantPayeeChannelAtomService;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeChannelAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeChannelAtomRspBO;
import com.tydic.fsc.common.busi.api.FscMerchantSubmitBusiService;
import com.tydic.fsc.common.busi.bo.FscMerchantSubmitBusiServiceReqBO;
import com.tydic.fsc.common.busi.bo.FscMerchantSubmitBusiServiceRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.payment.pay.ability.PayProAddMerchantInfoAbilityService;
import com.tydic.payment.pay.ability.PayProRelPayParaAbilityService;
import com.tydic.payment.pay.ability.bo.PayProMerchantInfoReqBo;
import com.tydic.payment.pay.ability.bo.PayProMerchantInfoRspBo;
import com.tydic.payment.pay.ability.bo.PayProMerchantPayInsDataBo;
import com.tydic.payment.pay.ability.bo.PayProPayInsParaDataBo;
import com.tydic.payment.pay.ability.bo.PayProRelMerchantBusiSysDataBo;
import com.tydic.payment.pay.ability.bo.PayProRelPayParaReqBo;
import com.tydic.payment.pay.ability.bo.PayProRelPayParaRspBo;
import com.tydic.payment.pay.dao.BusiSystemMerchantRelMapper;
import com.tydic.payment.pay.dao.MerChantInfoMapper;
import com.tydic.payment.pay.dao.po.BusiSystemMerchantRelPo;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscMerchantSubmitBusiService")
public class FscMerchantSubmitBusiServiceImpl
implements FscMerchantSubmitBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantSubmitBusiServiceImpl.class);
    @Value(value="${pay.center.busi.code:D500}")
    private String payBusiCode;
    @Value(value="${pay.center.req.way:1}")
    private String reqWay;
    private static final String PAY_CENTER_MERCHANT_STATUS_VALID = "1";
    @Autowired
    private FscMerchantPayeeChannelAtomService fscMerchantPayeeChannelAtomService;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private PayProAddMerchantInfoAbilityService payProAddMerchantInfoAbilityService;
    @Autowired
    private PayProRelPayParaAbilityService payProRelPayParaAbilityService;
    @Autowired
    private MerChantInfoMapper merChantInfoMapper;
    @Autowired
    private BusiSystemMerchantRelMapper busiSystemMerchantRelMapper;

    @Override
    public FscMerchantSubmitBusiServiceRspBO submitMerchant(FscMerchantSubmitBusiServiceReqBO reqBo) {
        FscMerchantSubmitBusiServiceRspBO retBo = new FscMerchantSubmitBusiServiceRspBO();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespCode("193123");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag())) {
            FscMerchantPO exceptionPo = new FscMerchantPO();
            exceptionPo.setMerchantId(reqBo.getMerchantId());
            exceptionPo.setStatus(FscConstants.MerchantStatus.VALID);
            int result = this.fscMerchantMapper.updateById(exceptionPo);
            if (result < 1) {
                throw new FscBusinessException("193123", "\u66f4\u65b0\u4f8b\u5916\u5546\u6237\u72b6\u6001\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            return retBo;
        }
        FscMerchantPayeeChannelAtomReqBO channelAtomReqBo = new FscMerchantPayeeChannelAtomReqBO();
        channelAtomReqBo.setMerchantId(reqBo.getMerchantId());
        FscMerchantPayeeChannelAtomRspBO channelAtomRetBo = this.fscMerchantPayeeChannelAtomService.queryPayChannel(channelAtomReqBo);
        if (!"0000".equals(channelAtomRetBo.getRespCode())) {
            BeanUtils.copyProperties((Object)channelAtomRetBo, (Object)((Object)retBo));
            return retBo;
        }
        List payChannels = channelAtomRetBo.getPayChannels();
        if (CollectionUtils.isEmpty((Collection)payChannels)) {
            log.info("===\u5546\u6237\u914d\u7f6e\u7684\u652f\u4ed8\u6e20\u9053\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u53ef\u63d0\u4ea4");
            retBo.setRespCode("193123");
            retBo.setRespDesc("\u5546\u6237\u914d\u7f6e\u7684\u652f\u4ed8\u6e20\u9053\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u53ef\u63d0\u4ea4");
            return retBo;
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayMerchantId())) {
            this.createPayMerchant(reqBo, payChannels);
        } else {
            this.updatePayMerchant(reqBo, payChannels);
        }
        return retBo;
    }

    private void updatePayMerchant(FscMerchantSubmitBusiServiceReqBO reqBo, List<FscMerchantPayeeChannelDataBO> payChannels) {
        PayProRelPayParaReqBo payParaReqBo = new PayProRelPayParaReqBo();
        payParaReqBo.setMerchantId(reqBo.getPayMerchantId());
        payParaReqBo.setUpdateOperId(reqBo.getUserId().toString());
        payParaReqBo.setRemark(reqBo.getRemark());
        this.editPaymentInsInfo(payParaReqBo, payChannels, false);
    }

    private void createPayMerchant(FscMerchantSubmitBusiServiceReqBO reqBo, List<FscMerchantPayeeChannelDataBO> payChannels) {
        HashSet reqWaySet = new HashSet();
        CollectionUtil.addAll(reqWaySet, (Object[])this.reqWay.split(","));
        PayProMerchantInfoReqBo payMerchantReqBo = new PayProMerchantInfoReqBo();
        payMerchantReqBo.setBusiCode(this.payBusiCode);
        payMerchantReqBo.setMerchantName(reqBo.getOrgName());
        payMerchantReqBo.setContactTel(reqBo.getContactPhone());
        payMerchantReqBo.setCreateOperId(reqBo.getUserId().toString());
        payMerchantReqBo.setRemark(reqBo.getRemark());
        payMerchantReqBo.setStatus(PAY_CENTER_MERCHANT_STATUS_VALID);
        ArrayList<PayProRelMerchantBusiSysDataBo> relBusiSysList = new ArrayList<PayProRelMerchantBusiSysDataBo>();
        for (String reqWayItem : reqWaySet) {
            PayProRelMerchantBusiSysDataBo relBusiSysInfo = new PayProRelMerchantBusiSysDataBo();
            relBusiSysInfo.setReqWay(reqWayItem);
            relBusiSysInfo.setRemark(reqBo.getRemark());
            relBusiSysList.add(relBusiSysInfo);
        }
        payMerchantReqBo.setRelBusiSysList(relBusiSysList);
        PayProMerchantInfoRspBo payMerchantRetBo = this.payProAddMerchantInfoAbilityService.addMerchant(payMerchantReqBo);
        if (!"0000".equals(payMerchantRetBo.getRespCode()) && !"0000".equals(payMerchantRetBo.getRespCode())) {
            log.info("===\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u521b\u5efa\u63a5\u53e3\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)payMerchantRetBo));
            throw new FscBusinessException("193123", "\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u521b\u5efa\u63a5\u53e3\u5931\u8d25\uff1a" + payMerchantRetBo.getRespDesc());
        }
        PayProRelPayParaReqBo payParaReqBo = new PayProRelPayParaReqBo();
        payParaReqBo.setMerchantId(payMerchantRetBo.getMerchantId().toString());
        payParaReqBo.setCreateOperId(reqBo.getUserId().toString());
        payParaReqBo.setRemark(reqBo.getRemark());
        try {
            this.editPaymentInsInfo(payParaReqBo, payChannels, true);
        }
        catch (Exception e) {
            log.error("\u5546\u6237\u63d0\u4ea4\u652f\u4ed8\u914d\u7f6e\u53c2\u6570\u5931\u8d25\uff0c\u624b\u52a8\u5220\u9664\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u4fe1\u606f");
            MerChantInfoPo merchantPo = new MerChantInfoPo();
            merchantPo.setMerchantId(payMerchantRetBo.getMerchantId());
            this.merChantInfoMapper.deleteMerChantInfo(merchantPo);
            BusiSystemMerchantRelPo relPo = new BusiSystemMerchantRelPo();
            relPo.setMerchantId(payMerchantRetBo.getMerchantId());
            relPo.setReqWay(this.reqWay);
            this.busiSystemMerchantRelMapper.deleteBusiSystemMerchantRelByBusiReqWayMerchant(relPo);
            throw new FscBusinessException("193123", e.getMessage());
        }
        FscMerchantPO updateMerchantPo = new FscMerchantPO();
        updateMerchantPo.setMerchantId(reqBo.getMerchantId());
        updateMerchantPo.setPayMerchantId(payMerchantRetBo.getMerchantId().toString());
        updateMerchantPo.setStatus(FscConstants.MerchantStatus.VALID);
        int result = this.fscMerchantMapper.updateById(updateMerchantPo);
        if (result < 1) {
            throw new FscBusinessException("193123", "\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237ID\u5199\u5165\u8d26\u6237\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void editPaymentInsInfo(PayProRelPayParaReqBo payParaReqBo, List<FscMerchantPayeeChannelDataBO> payChannels, Boolean isCreate) {
        for (FscMerchantPayeeChannelDataBO channelDataBO : payChannels) {
            PayProRelPayParaRspBo payParaRetBo;
            PayProMerchantPayInsDataBo payInsDataBo = new PayProMerchantPayInsDataBo();
            payInsDataBo.setPaymentInsId(Long.valueOf(channelDataBO.getPayChannel()));
            List<String> payMethodStrList = Arrays.asList(channelDataBO.getPayMethod().split(","));
            List payMethodList = payMethodStrList.stream().map(value -> Long.valueOf(value.trim())).collect(Collectors.toList());
            payInsDataBo.setPayMethodList(payMethodList);
            List payParaList = JSONArray.parseArray((String)channelDataBO.getPayJson(), PayProPayInsParaDataBo.class);
            payInsDataBo.setPayParaList(payParaList);
            payParaReqBo.setPaymentIns(payInsDataBo);
            if (log.isDebugEnabled()) {
                log.debug("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u914d\u7f6e\u53c2\u6570\u66f4\u65b0\u670d\u52a1\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)payParaReqBo));
            }
            if ("0000".equals((payParaRetBo = isCreate != false ? this.payProRelPayParaAbilityService.addRelPayPara(payParaReqBo) : this.payProRelPayParaAbilityService.updateRelPayPara(payParaReqBo)).getRespCode())) continue;
            log.error("\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u53c2\u6570\u914d\u7f6e\u63a5\u53e3\u670d\u52a1\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)payParaRetBo));
            throw new FscBusinessException("193123", "\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u53c2\u6570\u914d\u7f6e\u63a5\u53e3\u670d\u52a1\u5931\u8d25\uff1a" + payParaRetBo.getRespDesc());
        }
    }

    private String validateArgs(FscMerchantSubmitBusiServiceReqBO reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u5546\u6237ID[merchantId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (StringUtils.isEmpty((Object)reqBo.getOrgId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u673a\u6784ID[orgId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBo.getExceptionFlag()) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u662f\u5426\u4f8b\u5916\u914d\u7f6e[exceptionFlag]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

