/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.pay.ability.impl;

import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscDycUmcQuerySupplierListReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscDycUmcQuerySupplierListRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPebExtOrdStatisticReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPebExtOrdStatisticRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcContractYearBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcSignContractBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcSupplierBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcSupplierInfoQryListReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUmcSupplierInfoQryListRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocInspectionDetailsListBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProTransactionServiceListQueryReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProTransactionServiceListQueryRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.busibase.external.api.umc.FscDycUmcQuerySupplierListAbilityService;
import com.tydic.fsc.busibase.external.api.umc.FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService;
import com.tydic.fsc.busibase.external.api.umc.FscUmcSupplierInfoQryListAbilityService;
import com.tydic.fsc.busibase.external.api.uoc.FscPebExtOrdStatisticAbilityService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProTransactionServiceListQueryAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.api.FscPayServiceBillCreateAbilityService;
import com.tydic.fsc.pay.ability.api.FscPayServiceBillCreateTaskAbilityService;
import com.tydic.fsc.pay.ability.bo.FscPayServiceBillCreateAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayServiceBillCreateAbilityRspBO;
import com.tydic.fsc.pay.ability.bo.FscPayServiceBillCreateTaskAbilityReqBO;
import com.tydic.fsc.pay.ability.bo.FscPayServiceBillCreateTaskAbilityRspBO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.pay.ability.api.FscPayServiceBillCreateTaskAbilityService"})
public class FscPayServiceBillCreateTaskAbilityServiceImpl
implements FscPayServiceBillCreateTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayServiceBillCreateTaskAbilityServiceImpl.class);
    @Autowired
    private FscUmcSupplierInfoQryListAbilityService fscUmcSupplierInfoQryListAbilityService;
    @Autowired
    private FscPayServiceBillCreateAbilityService fscPayServiceBillCreateAbilityService;
    @Autowired
    private FscUocProTransactionServiceListQueryAbilityService fscUocProTransactionServiceListQueryAbilityService;
    @Autowired
    private FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscPebExtOrdStatisticAbilityService fscPebExtOrdStatisticAbilityService;
    @Autowired
    private FscDycUmcQuerySupplierListAbilityService FscDycUmcQuerySupplierListAbilityService;
    private static final Integer ONE = 1;
    private static final Integer TWO = 2;
    private static final Integer TWELVE = 12;
    private static final String YEAR_FIRST_TIME = "00:00:00";
    private static final String YEAR_LAST_TIME = "23:59:59";

    @PostMapping(value={"dealPayServiceBillTask"})
    public FscPayServiceBillCreateTaskAbilityRspBO dealPayServiceBillTask(@RequestBody FscPayServiceBillCreateTaskAbilityReqBO reqBO) {
        List<FscUmcSupplierBO> fscUmcSupplierBOS = this.qrySupList(reqBO.getSupplierId());
        if (CollectionUtils.isEmpty(fscUmcSupplierBOS)) {
            return new FscPayServiceBillCreateTaskAbilityRspBO();
        }
        String lastDayStr = reqBO.getLastDay();
        String firstDayStr = reqBO.getFirstDay();
        if (StringUtils.isBlank((CharSequence)lastDayStr) || StringUtils.isBlank((CharSequence)reqBO.getFirstDay())) {
            LocalDate localDate = LocalDate.now();
            LocalDate firstDay = ONE.equals(localDate.getMonthValue()) ? LocalDate.of(localDate.getYear() - ONE, TWELVE, (int)ONE) : LocalDate.of(localDate.getYear(), localDate.getMonthValue() - ONE, (int)ONE);
            lastDayStr = firstDay.with(TemporalAdjusters.lastDayOfMonth()).toString();
            firstDayStr = firstDay.toString();
        }
        Map<Long, FscUmcSignContractBO> fscUmcSignContractBOMap = null;
        if (!FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            fscUmcSignContractBOMap = this.qryContractSign(fscUmcSupplierBOS.stream().map(FscUmcSupplierBO::getSupplierId).collect(Collectors.toList()));
        }
        String y = String.valueOf(LocalDate.now().getYear());
        firstDayStr = firstDayStr + " " + YEAR_FIRST_TIME;
        lastDayStr = lastDayStr + " " + YEAR_LAST_TIME;
        for (FscUmcSupplierBO fscUmcSupplierBO : fscUmcSupplierBOS) {
            FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.qryConfig(fscUmcSupplierBO.getSupplierId(), reqBO, "transaction_service_fee_rules");
            if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) continue;
            if (!FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
                String[] cycles;
                if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getServiceYearFeeBillAutoGenerate())) continue;
                boolean ct = false;
                String serviceYearFeeGenerateTime = fscCfcUniteParamQryListDetailExternalRspBO.getServiceYearFeeGenerateTime();
                if (!serviceYearFeeGenerateTime.contains(",") || serviceYearFeeGenerateTime.split(",").length != 4) {
                    log.error("\u5e74\u5ea6\u670d\u52a1\u8d39\u914d\u7f6e\u8ba1\u8d39\u5468\u65e5\u683c\u5f0f\u9519\u8bef:{}", (Object)serviceYearFeeGenerateTime);
                    ct = true;
                }
                for (String cycle : cycles = serviceYearFeeGenerateTime.split(",")) {
                    if (!StringUtils.isBlank((CharSequence)cycle)) continue;
                    log.error("\u5e74\u5ea6\u670d\u52a1\u8d39\u914d\u7f6e\u8ba1\u8d39\u5468\u671f\u5b58\u5728\u7a7a\u503c:{}", (Object)serviceYearFeeGenerateTime);
                    ct = true;
                    break;
                }
                String firstCycleMonth = cycles[0].length() < 2 ? "0" + cycles[0] : cycles[0];
                String firstCycleDay = cycles[1].length() < 2 ? "0" + cycles[1] : cycles[1];
                String lastCycleMonth = cycles[2].length() < 2 ? "0" + cycles[2] : cycles[2];
                String lastCycleDay = cycles[3].length() < 2 ? "0" + cycles[3] : cycles[3];
                firstDayStr = y + "-" + firstCycleMonth + "-" + firstCycleDay + " " + YEAR_FIRST_TIME;
                lastDayStr = y + "-" + lastCycleMonth + "-" + lastCycleDay + " " + YEAR_LAST_TIME;
                if (ct) continue;
            }
            if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow()) && !Long.valueOf(LocalDate.now().getDayOfMonth()).equals(Long.valueOf(fscCfcUniteParamQryListDetailExternalRspBO.getServiceMonthFeeGenerateTime())) || FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow()) && !"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getServiceMonthFeeBillAutoGenerate())) continue;
            List<Object> relOrderBOS = this.qryOrderList(fscUmcSupplierBO.getSupplierId(), firstDayStr, lastDayStr, reqBO, fscUmcSignContractBOMap);
            if (CollectionUtils.isEmpty(relOrderBOS = relOrderBOS.stream().filter(relOrderBO -> null != relOrderBO.getSerPriceMoney() && relOrderBO.getSerPriceMoney().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList()))) continue;
            this.createPayServiceBill(relOrderBOS, reqBO.getOrderFlow(), fscCfcUniteParamQryListDetailExternalRspBO, fscUmcSupplierBO);
        }
        return new FscPayServiceBillCreateTaskAbilityRspBO();
    }

    private FscCfcUniteParamQryListDetailExternalRspBO qryConfig(Long supplierId, FscPayServiceBillCreateTaskAbilityReqBO reqBO, String paramCode) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(supplierId.toString());
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode(paramCode);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191204", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if ((FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(reqBO.getOrderFlow())) && (StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getServiceYearFeeBillAutoGenerate()) || StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getServiceYearFeeGenerateTime()))) {
            fscCfcUniteParamQryListDetailExternalRspBO.setRespCode("191204");
            fscCfcUniteParamQryListDetailExternalRspBO.setRespDesc("\u5e74\u5ea6\u670d\u52a1\u8d39\u914d\u7f6e\u53c2\u6570\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow()) && (StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getServiceMonthFeeBillAutoGenerate()) || StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getServiceMonthFeeGenerateTime()))) {
            fscCfcUniteParamQryListDetailExternalRspBO.setRespCode("191204");
            fscCfcUniteParamQryListDetailExternalRspBO.setRespDesc("\u6708\u5ea6\u670d\u52a1\u8d39\u914d\u7f6e\u53c2\u6570\u8fd4\u56de\u4e3a\u7a7a");
        }
        return fscCfcUniteParamQryListDetailExternalRspBO;
    }

    private List<FscUmcSupplierBO> qrySupList(Long supplierId) {
        FscUmcSupplierInfoQryListRspBO fscUmcSupplierInfoQryListRspBO;
        FscUmcSupplierInfoQryListReqBO fscUmcSupplierInfoQryListReqBO = new FscUmcSupplierInfoQryListReqBO();
        fscUmcSupplierInfoQryListReqBO.setPageNo(Integer.valueOf(-1));
        fscUmcSupplierInfoQryListReqBO.setPageSize(Integer.valueOf(-1));
        if (null != supplierId) {
            fscUmcSupplierInfoQryListReqBO.setSupplierId(supplierId);
        }
        if (!"0000".equals((fscUmcSupplierInfoQryListRspBO = this.fscUmcSupplierInfoQryListAbilityService.qrySupplierList(fscUmcSupplierInfoQryListReqBO)).getRespCode())) {
            throw new FscBusinessException("191204", fscUmcSupplierInfoQryListRspBO.getRespDesc());
        }
        return fscUmcSupplierInfoQryListRspBO.getRows();
    }

    private List<RelOrderBO> qryOrderList(Long supId, String firstDay, String lastDay, FscPayServiceBillCreateTaskAbilityReqBO reqBO, Map<Long, FscUmcSignContractBO> fscUmcSignContractBOMap) {
        FscUocProTransactionServiceListQueryReqBO fscUocProTransactionServiceListQueryReqBO = new FscUocProTransactionServiceListQueryReqBO();
        fscUocProTransactionServiceListQueryReqBO.setSupId(supId);
        fscUocProTransactionServiceListQueryReqBO.setObjTimeEff(firstDay);
        fscUocProTransactionServiceListQueryReqBO.setObjTimeExp(lastDay);
        fscUocProTransactionServiceListQueryReqBO.setPageSize(ONE);
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            fscUocProTransactionServiceListQueryReqBO.setPageSize(reqBO.getMaxPageSize());
        }
        fscUocProTransactionServiceListQueryReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        fscUocProTransactionServiceListQueryReqBO.setRelType(FscConstants.FscRelType.SERVICE_INVOICE);
        FscUocProTransactionServiceListQueryRspBO fscUocProTransactionServiceListQueryRspBO = this.fscUocProTransactionServiceListQueryAbilityService.queryTransactionServiceList(fscUocProTransactionServiceListQueryReqBO);
        if (!"0000".equals(fscUocProTransactionServiceListQueryRspBO.getRespCode())) {
            return new ArrayList<RelOrderBO>();
        }
        if (CollectionUtils.isEmpty((Collection)fscUocProTransactionServiceListQueryRspBO.getRows())) {
            return new ArrayList<RelOrderBO>();
        }
        if (!FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
            ArrayList<RelOrderBO> relOrderBOList = new ArrayList<RelOrderBO>();
            FscUmcSignContractBO fscUmcSignContractBO = fscUmcSignContractBOMap.get(supId);
            FscPebExtOrdStatisticRspBO fscPebExtOrdStatisticRspBO = this.qryYearOrdInfo(supId, Integer.parseInt(fscUmcSignContractBO.getYearReceiveNode()), firstDay, lastDay);
            if (BigDecimal.ZERO.compareTo(fscPebExtOrdStatisticRspBO.getTotalFee()) == 0) {
                return relOrderBOList;
            }
            RelOrderBO relOrderBO = new RelOrderBO();
            relOrderBO.setSerPriceMoney(this.calServiceFee(fscPebExtOrdStatisticRspBO.getTotalFee(), fscUmcSignContractBO));
            relOrderBO.setSerPriceRate(this.calServiceFeeRate(fscPebExtOrdStatisticRspBO.getTotalFee(), fscUmcSignContractBO));
            relOrderBO.setSupName(((FscUocInspectionDetailsListBO)fscUocProTransactionServiceListQueryRspBO.getRows().get(0)).getSupName());
            relOrderBO.setProName(((FscUocInspectionDetailsListBO)fscUocProTransactionServiceListQueryRspBO.getRows().get(0)).getProName());
            if (!StringUtils.isBlank((CharSequence)((FscUocInspectionDetailsListBO)fscUocProTransactionServiceListQueryRspBO.getRows().get(0)).getSupNo())) {
                relOrderBO.setSupId(Long.valueOf(((FscUocInspectionDetailsListBO)fscUocProTransactionServiceListQueryRspBO.getRows().get(0)).getSupNo()));
            }
            if (!StringUtils.isBlank((CharSequence)((FscUocInspectionDetailsListBO)fscUocProTransactionServiceListQueryRspBO.getRows().get(0)).getProNo())) {
                relOrderBO.setProId(Long.valueOf(((FscUocInspectionDetailsListBO)fscUocProTransactionServiceListQueryRspBO.getRows().get(0)).getProNo()));
            }
            relOrderBOList.add(relOrderBO);
            return relOrderBOList;
        }
        return fscUocProTransactionServiceListQueryRspBO.getRows().stream().map(fscUocInspectionDetailsListBO -> {
            RelOrderBO relOrderBO = new RelOrderBO();
            if (!StringUtils.isBlank((CharSequence)fscUocInspectionDetailsListBO.getInspectionVoucherId())) {
                relOrderBO.setAcceptOrderId(Long.valueOf(fscUocInspectionDetailsListBO.getInspectionVoucherId()));
            }
            relOrderBO.setOrderId(Long.valueOf(fscUocInspectionDetailsListBO.getOrderId()));
            if (!StringUtils.isBlank((CharSequence)fscUocInspectionDetailsListBO.getSupNo())) {
                relOrderBO.setSupId(Long.valueOf(fscUocInspectionDetailsListBO.getSupNo()));
            }
            relOrderBO.setSupName(fscUocInspectionDetailsListBO.getSupName());
            if (!StringUtils.isBlank((CharSequence)fscUocInspectionDetailsListBO.getProNo())) {
                relOrderBO.setProId(Long.valueOf(fscUocInspectionDetailsListBO.getProNo()));
            }
            relOrderBO.setProName(fscUocInspectionDetailsListBO.getProName());
            relOrderBO.setSerPriceMoney(fscUocInspectionDetailsListBO.getSerPriceMoney());
            return relOrderBO;
        }).collect(Collectors.toList());
    }

    private void createPayServiceBill(List<RelOrderBO> relOrderBOS, Integer orderFlow, FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO, FscUmcSupplierBO fscUmcSupplierBO) {
        RelOrderBO relOrderBO = relOrderBOS.get(0);
        FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO = new FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO();
        fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO.setOrgId(relOrderBO.getSupId());
        FscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO = this.fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdAbilityService.qryMain(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdReqBO);
        if ("0000".equals(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getRespCode()) && null != fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO() && null != fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO()) {
            FscPayServiceBillCreateAbilityRspBO fscPayServiceBillCreateAbilityRspBO;
            FscPayServiceBillCreateAbilityReqBO fscPayServiceBillCreateAbilityReqBO = new FscPayServiceBillCreateAbilityReqBO();
            fscPayServiceBillCreateAbilityReqBO.setTaskFlag(Boolean.valueOf(true));
            fscPayServiceBillCreateAbilityReqBO.setMakeType(FscConstants.FscOrderMakeType.OPERTION);
            fscPayServiceBillCreateAbilityReqBO.setReceiveType(FscConstants.FscOrderReceiveType.SUPPLIER);
            fscPayServiceBillCreateAbilityReqBO.setOrderFlow(orderFlow);
            fscPayServiceBillCreateAbilityReqBO.setProOrgId(relOrderBO.getProId());
            fscPayServiceBillCreateAbilityReqBO.setProOrgName(relOrderBO.getProName());
            fscPayServiceBillCreateAbilityReqBO.setSupplierId(fscUmcSupplierBO.getSupplierId());
            if (null != relOrderBO.getSupId()) {
                fscPayServiceBillCreateAbilityReqBO.setSupplierId(relOrderBO.getSupId());
            }
            fscPayServiceBillCreateAbilityReqBO.setSupplierName(relOrderBO.getSupName());
            fscPayServiceBillCreateAbilityReqBO.setTotalCharge(relOrderBO.getSerPriceMoney());
            fscPayServiceBillCreateAbilityReqBO.setRelOrderBOList(relOrderBOS);
            fscPayServiceBillCreateAbilityReqBO.setBuyName(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getInvoiceTitle());
            fscPayServiceBillCreateAbilityReqBO.setInvoiceType(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getInvoiceType());
            fscPayServiceBillCreateAbilityReqBO.setInvoiceCategory(Integer.valueOf(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getInvoiceClass()));
            fscPayServiceBillCreateAbilityReqBO.setTaxNo(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getTaxpayerId());
            fscPayServiceBillCreateAbilityReqBO.setBank(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getBank());
            fscPayServiceBillCreateAbilityReqBO.setAccount(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getAccount());
            fscPayServiceBillCreateAbilityReqBO.setAddress(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getAddress());
            fscPayServiceBillCreateAbilityReqBO.setPhone(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getAccountInvoiceBO().getPhone());
            fscPayServiceBillCreateAbilityReqBO.setReceiveName(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getContactNameWeb());
            fscPayServiceBillCreateAbilityReqBO.setReceiveAddr(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getAddrDesc());
            fscPayServiceBillCreateAbilityReqBO.setReceivePhone(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getTel());
            fscPayServiceBillCreateAbilityReqBO.setReceiveEmail(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getElcInvoiceEmail());
            fscPayServiceBillCreateAbilityReqBO.setTownCode(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getTownId());
            fscPayServiceBillCreateAbilityReqBO.setTown(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getTownName());
            fscPayServiceBillCreateAbilityReqBO.setAreaCode(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getCountyId());
            fscPayServiceBillCreateAbilityReqBO.setArea(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getCountyName());
            fscPayServiceBillCreateAbilityReqBO.setCityCode(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getCityId());
            fscPayServiceBillCreateAbilityReqBO.setCity(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getCityName());
            fscPayServiceBillCreateAbilityReqBO.setProvinceCode(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getProvinceId());
            fscPayServiceBillCreateAbilityReqBO.setProvince(fscUmcQryMainAccountInvocieAndInvoiceAddressByOrgIdRspBO.getUmcInvoiceAddressBO().getProvinceName());
            fscPayServiceBillCreateAbilityReqBO.setServiceFeeCycle(fscCfcUniteParamQryListDetailExternalRspBO.getServiceYearFeeGenerateTime());
            if (null != relOrderBO.getSerPriceRate()) {
                fscPayServiceBillCreateAbilityReqBO.setServiceFeeRate(relOrderBO.getSerPriceRate().toString());
            }
            if (!"0000".equals((fscPayServiceBillCreateAbilityRspBO = this.fscPayServiceBillCreateAbilityService.dealPayServiceOrdCreate(fscPayServiceBillCreateAbilityReqBO)).getRespCode())) {
                FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
                fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(fscPayServiceBillCreateAbilityRspBO.getRespDesc());
                if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(orderFlow)) {
                    fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_MONTH_PAY_SERVICE_TASK_FAIL);
                } else {
                    fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_YEAR_PAY_SERVICE_TASK_FAIL);
                }
                fscOrderFailLogUpdateBusiReqBO.setObjId(relOrderBO.getSupId());
                this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
            }
        } else {
            log.error("\u4f9b\u5e94\u5546\u6536\u7968\u4fe1\u606f\u4e3a\u7a7a");
        }
    }

    private FscPebExtOrdStatisticRspBO qryYearOrdInfo(Long supId, Integer searchType, String effTime, String expTime) {
        FscPebExtOrdStatisticReqBO fscPebExtOrdStatisticReqBO = new FscPebExtOrdStatisticReqBO();
        fscPebExtOrdStatisticReqBO.setSupNo(supId.toString());
        fscPebExtOrdStatisticReqBO.setSearchType(searchType);
        fscPebExtOrdStatisticReqBO.setCreateTimeEff(effTime);
        fscPebExtOrdStatisticReqBO.setCreateTimeExp(expTime);
        FscPebExtOrdStatisticRspBO fscPebExtOrdStatisticRspBO = this.fscPebExtOrdStatisticAbilityService.queryOrdStatisticInfo(fscPebExtOrdStatisticReqBO);
        if (!"0000".equals(fscPebExtOrdStatisticRspBO.getRespCode())) {
            throw new FscBusinessException("191204", fscPebExtOrdStatisticRspBO.getRespDesc());
        }
        return fscPebExtOrdStatisticRspBO;
    }

    private Map<Long, FscUmcSignContractBO> qryContractSign(List<Long> supIds) {
        FscDycUmcQuerySupplierListReqBO FscDycUmcQuerySupplierListReqBO2 = new FscDycUmcQuerySupplierListReqBO();
        FscDycUmcQuerySupplierListReqBO2.setSupplierIds(supIds);
        FscDycUmcQuerySupplierListRspBO FscDycUmcQuerySupplierListRspBO2 = this.FscDycUmcQuerySupplierListAbilityService.querySupplierList(FscDycUmcQuerySupplierListReqBO2);
        if (!"0000".equals(FscDycUmcQuerySupplierListRspBO2.getRespCode()) || CollectionUtils.isEmpty((Collection)FscDycUmcQuerySupplierListRspBO2.getSignContractBOS())) {
            return new HashMap<Long, FscUmcSignContractBO>();
        }
        return FscDycUmcQuerySupplierListRspBO2.getSignContractBOS().stream().collect(Collectors.toMap(FscUmcSignContractBO::getSupplierId, fscUmcSignContractBO -> fscUmcSignContractBO));
    }

    private BigDecimal calServiceFee(BigDecimal orderAmt, FscUmcSignContractBO fscUmcSignContractBO) {
        for (FscUmcContractYearBO contractYearBO : fscUmcSignContractBO.getContractYearBOS()) {
            if (contractYearBO.getSalesQuotaExp().compareTo(orderAmt) > 0 || null != contractYearBO.getSalesQuotaEff() && contractYearBO.getSalesQuotaEff().compareTo(orderAmt) <= 0) continue;
            return orderAmt.multiply(contractYearBO.getAnnualStepRate()).multiply(BigDecimal.valueOf(0.01)).setScale((int)TWO, 4);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal calServiceFeeRate(BigDecimal orderAmt, FscUmcSignContractBO fscUmcSignContractBO) {
        for (FscUmcContractYearBO contractYearBO : fscUmcSignContractBO.getContractYearBOS()) {
            if (contractYearBO.getSalesQuotaExp().compareTo(orderAmt) > 0 || null != contractYearBO.getSalesQuotaEff() && contractYearBO.getSalesQuotaEff().compareTo(orderAmt) <= 0) continue;
            return contractYearBO.getAnnualStepRate();
        }
        return BigDecimal.ZERO;
    }
}

