/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApplyBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.ListUtils;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccUpAndOffApplyBusiServiceImpl
implements UccUpAndOffApplyBusiService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccApproveCreationAtomService uccApproveCreationAtomService;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;

    @Override
    public UccUpAndOffApplyAbilityRspBO dealUpAndOffApply(UccUpAndOffApplyAbilityReqBO reqBO, ExtReqBO extReqBO) {
        UccUpAndOffApplyAbilityRspBO rspBO = new UccUpAndOffApplyAbilityRspBO();
        if (CollectionUtils.isEmpty(reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7533\u8bf7\u5355\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)extReqBO.getProcess())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u6d41\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        ArrayList<Long> skus = new ArrayList();
        for (Long supplierShopId : mapSku.keySet()) {
            UccSkuPutCirReqBO uccSkuPutCirReqBO;
            skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List<UccSkuPo> uccSkuPos = null;
            uccSkuPos = this.uccSkuMapper.batchQrySku(skus, supplierShopId);
            List<Long> failIds = new ArrayList();
            List<Long> failIdAudit = new ArrayList();
            HashSet<Long> editSpu = new HashSet<Long>();
            if (uccSkuPos.size() < skus.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u5355\u54c1\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                return rspBO;
            }
            try {
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uccSkuPos)) {
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (SkuStatusEnum.WARN_DOWN_STATUS.getStatus().equals(uccSkuPo.getSkuStatus())) {
                            rspBO.setRespCode("8888");
                            rspBO.setRespDesc("\u5355\u54c1" + uccSkuPo.getExtSkuId() + "\u4e3a\u9884\u8b66\u4e0b\u67b6\uff0c\u4e0d\u652f\u6301\u6062\u590d\u4e0a\u67b6");
                            return rspBO;
                        }
                        if (extReqBO.getStatusOld().contains(uccSkuPo.getSkuStatus())) continue;
                        failIds.add(uccSkuPo.getSkuId());
                    }
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (uccSkuPo.getApprovalStatus() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_GO || uccSkuPo.getApprovalStatus() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO || uccSkuPo.getApprovalStatus() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO) {
                            failIdAudit.add(uccSkuPo.getSkuId());
                        }
                        if (uccSkuPo.getApprovalStatus() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO && !ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) {
                            failIdAudit.add(uccSkuPo.getSkuId());
                        }
                        if (uccSkuPo.getApprovalStatus() != ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO || !ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) continue;
                        editSpu.add(uccSkuPo.getCommodityId());
                    }
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(failIds = ListUtils.removeNull(failIds))) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5355\u54c1" + failIds.toString() + "\u5f53\u524d\u72b6\u6001\u4e0d\u6b63\u786e");
                    return rspBO;
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(failIdAudit = ListUtils.removeNull(failIdAudit))) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5355\u54c1" + failIdAudit.toString() + "\u6b63\u5728\u5ba1\u6279\u4e2d");
                    return rspBO;
                }
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            ArrayList<Long> editSpuAray = new ArrayList<Long>(editSpu);
            if (!CollectionUtils.isEmpty(editSpuAray)) {
                UacNoTaskAuditCancelReqBO uacNoTaskAuditCancelReqBO = null;
                for (Long cancelEach : editSpuAray) {
                    uacNoTaskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
                    uacNoTaskAuditCancelReqBO.setObjId(cancelEach.toString());
                    uacNoTaskAuditCancelReqBO.setObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT);
                    uacNoTaskAuditCancelReqBO.setOperDept(reqBO.getCompanyName());
                    uacNoTaskAuditCancelReqBO.setOperId(reqBO.getUserId().toString());
                    uacNoTaskAuditCancelReqBO.setCancelOperId(reqBO.getUserId().toString());
                    uacNoTaskAuditCancelReqBO.setCancelReason("\u5355\u54c1\u5f3a\u5236\u4e0b\u67b6");
                    UacNoTaskAuditCancelRspBO uacNoTaskAuditCancelRspBO = this.uacNoTaskAuditCancelAbilityService.auditCancel(uacNoTaskAuditCancelReqBO);
                    if (!"0000".equals(uacNoTaskAuditCancelRspBO.getRespCode())) continue;
                    throw new BusinessException("8888", uacNoTaskAuditCancelRspBO.getRespDesc());
                }
                try {
                    this.uccCommodityMapper.batchUpdateSpuApprovalStatus(editSpuAray, null, supplierShopId);
                    this.uccCommodityMapper.batchUpdateStep(editSpuAray, null, supplierShopId);
                }
                catch (Exception e) {
                    throw new BusinessException("8888", e.getMessage());
                }
            }
            UccApproveCreationAtomReqBO approveCreationAtomReqBO = new UccApproveCreationAtomReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)approveCreationAtomReqBO));
            approveCreationAtomReqBO.setObjId(skus);
            approveCreationAtomReqBO.setMenuId(extReqBO.getProcess());
            approveCreationAtomReqBO.setObjType(extReqBO.getAuditObjType());
            approveCreationAtomReqBO.setOrderId(supplierShopId);
            approveCreationAtomReqBO.setUserId(reqBO.getUserId());
            UccApproveCreationAtomRspBO uccApproveCreationAtomRspBO = null;
            try {
                uccApproveCreationAtomRspBO = this.uccApproveCreationAtomService.createApprove(approveCreationAtomReqBO);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), e.getMessage());
            }
            if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), uccApproveCreationAtomRspBO.getRespDesc());
            }
            if (ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) {
                System.out.println("------------------------------------------------\u8fdb\u5165\u4e0b\u67b6\u6d41\u7a0b\u81ea\u52a8\u5ba1\u6279------------------------------------------------");
                this.updateSkuStatus(extReqBO.getStatusApproval(), ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_NONE.toString(), "", skus, supplierShopId, reqBO);
                try {
                    for (Long skuId : skus) {
                        uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                        uccSkuPutCirReqBO.setSkuId(skuId);
                        uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                        uccSkuPutCirReqBO.setDownType(extReqBO.getOperate());
                        uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr(new Date()));
                        uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                        uccSkuPutCirReqBO.setRemark(extReqBO.getRemark());
                        this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                    }
                }
                catch (Exception e) {
                    throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                }
            }
            if (uccApproveCreationAtomRspBO.getNotFindFlag().booleanValue() || uccApproveCreationAtomRspBO.getFinish().booleanValue() || "\u6062\u590d\u4e0a\u67b6".equals(extReqBO.getRemark())) {
                this.updateSkuStatus(extReqBO.getStatusApproval(), "", "", skus, supplierShopId, reqBO);
                if (!ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF.equals(extReqBO.getAuditObjType())) continue;
                try {
                    for (Long skuId : skus) {
                        uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                        uccSkuPutCirReqBO.setSkuId(skuId);
                        uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                        uccSkuPutCirReqBO.setUptype(extReqBO.getOperate());
                        uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr(new Date()));
                        uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                        uccSkuPutCirReqBO.setRemark(extReqBO.getRemark());
                        this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new BusinessException("8888", "\u66f4\u65b0\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                }
            }
            try {
                this.updateSkuStatus(extReqBO.getStatusApply(), extReqBO.getAuditStatusApply(), uccApproveCreationAtomRspBO.getStepId(), skus, supplierShopId, reqBO);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, UccUpAndOffApplyAbilityReqBO reqBO) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (ModelRuleConstant.SKU_STATUS_ON_SHELF.equals(newStatus)) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        System.out.println("---------------------------------------");
        System.out.println(JSONObject.toJSONString(skuUpdateStatusBOS));
        System.out.println("---------------------------------------");
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }
}

