/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.common.ability.api.UccChannelCatalogRelQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccChannelCatalogRelQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccChannelCatalogRelQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccChannelCatalogRelQryBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.po.UccCatalogDealPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccChannelCatalogRelQryAbilityService"})
public class UccChannelCatalogRelQryAbilityServiceImpl
implements UccChannelCatalogRelQryAbilityService {
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"queryCatalogRelInfo"})
    public UccChannelCatalogRelQryAbilityRspBO queryCatalogRelInfo(@RequestBody UccChannelCatalogRelQryAbilityReqBO reqBO) {
        UccChannelCatalogRelQryAbilityRspBO rspBO = new UccChannelCatalogRelQryAbilityRspBO();
        if (reqBO.getChannelId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9891\u9053id\u4e3a\u7a7a");
            return rspBO;
        }
        Integer recordsTotal = this.uccCatalogDealMapper.queryCountByCondition(reqBO.getChannelId(), reqBO.getCatalogName(), reqBO.getCatalogCode());
        int pageSize = reqBO.getPageSize();
        int pageNo = reqBO.getPageNo();
        Integer total = recordsTotal % pageSize == 0 ? recordsTotal / pageSize : recordsTotal / pageSize + 1;
        Integer start = pageSize * (pageNo - 1);
        List cnncUccCatalogPOS = this.uccCatalogDealMapper.queryListByCondition(reqBO.getChannelId(), reqBO.getCatalogName(), reqBO.getCatalogCode(), reqBO.getCatalogStatus(), start, Integer.valueOf(pageSize));
        List<UccChannelCatalogRelQryBO> rows = this.convertList(cnncUccCatalogPOS, reqBO.getChannelId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(recordsTotal.intValue());
        rspBO.setTotal(total.intValue());
        return rspBO;
    }

    private List<UccChannelCatalogRelQryBO> convertList(List<UccCatalogDealPO> cnncUccCatalogPOS, Long channelId) {
        Map<String, String> catalogStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("GUIDE_CATALOG_STATUS");
        List upperCatalogList = this.uccCatalogDealMapper.queryAllUpperCatalog();
        ArrayList<UccChannelCatalogRelQryBO> rows = new ArrayList<UccChannelCatalogRelQryBO>();
        for (UccCatalogDealPO cnncUccCatalogPO : cnncUccCatalogPOS) {
            List catalogLevel2;
            UccChannelCatalogRelQryBO uccChannelCatalogRelQryBO = new UccChannelCatalogRelQryBO();
            uccChannelCatalogRelQryBO.setCatalogId(cnncUccCatalogPO.getGuideCatalogId());
            uccChannelCatalogRelQryBO.setCatalogCode(cnncUccCatalogPO.getCatalogCode());
            String catalogName = cnncUccCatalogPO.getCatalogName();
            if (!CollectionUtils.isEmpty((Collection)upperCatalogList) && !CollectionUtils.isEmpty(catalogLevel2 = upperCatalogList.stream().filter(s -> s.getGuideCatalogId().equals(cnncUccCatalogPO.getUpperCatalogId())).collect(Collectors.toList()))) {
                Long upperCatalog2Id = ((UccCatalogDealPO)catalogLevel2.get(0)).getUpperCatalogId();
                List catalogLevel1 = upperCatalogList.stream().filter(s -> s.getGuideCatalogId().equals(upperCatalog2Id)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(catalogLevel1)) {
                    catalogName = ((UccCatalogDealPO)catalogLevel1.get(0)).getCatalogName() + "/" + ((UccCatalogDealPO)catalogLevel2.get(0)).getCatalogName() + "/" + catalogName;
                }
            }
            uccChannelCatalogRelQryBO.setCatalogName(catalogName);
            uccChannelCatalogRelQryBO.setCatalogLevel(cnncUccCatalogPO.getCatalogLevel());
            uccChannelCatalogRelQryBO.setUpperCatalogId(cnncUccCatalogPO.getUpperCatalogId());
            uccChannelCatalogRelQryBO.setIsRel(Integer.valueOf(1));
            uccChannelCatalogRelQryBO.setCatalogStatus(cnncUccCatalogPO.getCatalogStatus());
            if (catalogStatusMap != null && uccChannelCatalogRelQryBO.getCatalogStatus() != null && catalogStatusMap.containsKey(uccChannelCatalogRelQryBO.getCatalogStatus().toString())) {
                uccChannelCatalogRelQryBO.setCatalogStatusDesc(catalogStatusMap.get(uccChannelCatalogRelQryBO.getCatalogStatus().toString()));
            }
            rows.add(uccChannelCatalogRelQryBO);
        }
        return rows;
    }
}

