/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.mall.ability.api.UccMallChannelStockQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccChanneStockQryBo;
import com.tydic.commodity.mall.ability.bo.UccMallChannelStockQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallChannelStockQryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallEsCommodityBo;
import com.tydic.commodity.mall.config.MallElasticsearchUtil;
import com.tydic.commodity.mall.config.MallEsConfig;
import com.tydic.commodity.mall.dao.UccMallCommodityExtMapper;
import com.tydic.commodity.mall.po.UccChannelStatisticsAbilityPo;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.mall.ability.api.UccMallChannelStockQryAbilityService"})
public class UccMallChannelStockQryAbilityServiceImpl
implements UccMallChannelStockQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMallChannelStockQryAbilityServiceImpl.class);
    @Autowired
    private MallEsConfig esConfig;
    @Autowired
    private MallElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccMallCommodityExtMapper uccCommodityExtMapper;

    @PostMapping(value={"getMallChannelStockQry"})
    public UccMallChannelStockQryAbilityRspBO getMallChannelStockQry(@RequestBody UccMallChannelStockQryAbilityReqBO reqBO) {
        UccMallChannelStockQryAbilityRspBO rspBo = new UccMallChannelStockQryAbilityRspBO();
        List<UccChannelStatisticsAbilityPo> cnncChannelStatisticsAbilityPos = this.uccCommodityExtMapper.getChannel();
        reqBO.setChannel_id(cnncChannelStatisticsAbilityPos.stream().map(UccChannelStatisticsAbilityPo::getChannelId).collect(Collectors.toList()));
        BoolQueryBuilder extBoolQueryBuilder = this.buildEsSql(reqBO);
        String queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
        String result = this.searchInfo(queryString);
        if (StringUtils.isEmpty((Object)result)) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO, cnncChannelStatisticsAbilityPos);
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccMallChannelStockQryAbilityReqBO reqBo) {
        WildcardQueryBuilder wildcardQuery;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getChannel_id())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"channel_id", (Collection)reqBo.getChannel_id()));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceAssort", (Object)reqBo.getSourceAssort()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (reqBo.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)reqBo.getSkuId()));
        }
        if (reqBo.getCommodityId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_sku_id", (String)reqBo.getExtSkuId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_spu_id", (String)reqBo.getExtSkuId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"other_source_code", (String)reqBo.getOtherSourceCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_code", (String)reqBo.getCommodityCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_code", (String)reqBo.getSkuCode()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", (Collection)reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", (Collection)reqBo.getSkuStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getIgnoreAgreenSku())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"agreement_details_id", (Collection)reqBo.getIgnoreAgreenSku()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (Collection)reqBo.getSkuList()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getIgnoreList())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (Collection)reqBo.getIgnoreList()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)(reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)(reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)(reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)(reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)(reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)(reqBo.getMaterialCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)(reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"model.keyword", (String)(reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)(reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)(reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        RangeQueryBuilder maerketQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceStar())) {
            maerketQb = QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceStar()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceEnd())) {
            maerketQb = QueryBuilders.rangeQuery((String)"sale_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceEnd()));
        }
        if (maerketQb != null) {
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccMallChannelStockQryAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        return queryJson.toString();
    }

    private UccMallChannelStockQryAbilityRspBO dealSearchData(String result, UccMallChannelStockQryAbilityReqBO reqBo, List<UccChannelStatisticsAbilityPo> cnncChannelStatisticsAbilityPos) {
        UccMallChannelStockQryAbilityRspBO rspBo = new UccMallChannelStockQryAbilityRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccMallEsCommodityBo> commodityModels = new ArrayList<UccMallEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccMallEsCommodityBo commodity = new UccMallEsCommodityBo();
                try {
                    commodity = (UccMallEsCommodityBo)JSON.toJavaObject((JSON)data, UccMallEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize(), cnncChannelStatisticsAbilityPos);
        return rspBo;
    }

    private UccMallChannelStockQryAbilityRspBO copyData(List<UccMallEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize, List<UccChannelStatisticsAbilityPo> cnncChannelStatisticsAbilityPos) {
        UccMallChannelStockQryAbilityRspBO rspBo = new UccMallChannelStockQryAbilityRspBO();
        ArrayList<UccChanneStockQryBo> uccMallChannelStockQryBOs = new ArrayList<UccChanneStockQryBo>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total.intValue());
            if (!CollectionUtils.isEmpty(commodityModels)) {
                for (UccChannelStatisticsAbilityPo channel : cnncChannelStatisticsAbilityPos) {
                    UccChanneStockQryBo uccMallChannelStockQryBO = new UccChanneStockQryBo();
                    uccMallChannelStockQryBO.setChannelId(channel.getChannelId());
                    uccMallChannelStockQryBO.setChannelName(channel.getChannelName());
                    List filterList = commodityModels.stream().filter(model -> channel.getChannelId().equals(model.getChannel_id().get(0))).collect(Collectors.toList());
                    uccMallChannelStockQryBO.setTypeNames(filterList.stream().map(UccMallEsCommodityBo::getType_name).collect(Collectors.toList()));
                    uccMallChannelStockQryBO.setTotalNumber(filterList.stream().map(UccMallEsCommodityBo::getComment_number).reduce(Long::sum).orElse(0L));
                    uccMallChannelStockQryBOs.add(uccMallChannelStockQryBO);
                }
            }
            rspBo.setRows(uccMallChannelStockQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

