/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.mall.ability.bo.ReplacePriceInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceReqBo;
import com.tydic.commodity.mall.ability.bo.UccMallReplacementPriceRspBo;
import com.tydic.commodity.mall.atom.api.InterfaceQryFscRuleAbilitySerive;
import com.tydic.commodity.mall.atom.bo.InterfaceMerchantConfBatchQueryReqDataBO;
import com.tydic.commodity.mall.atom.bo.InterfaceQryFscRuleAbilityBo;
import com.tydic.commodity.mall.atom.bo.InterfaceQryFscRuleAbilityReqBO;
import com.tydic.commodity.mall.atom.bo.InterfaceQryFscRuleAbilityRspBO;
import com.tydic.commodity.mall.busi.api.UccMallReplacementPriceBusiService;
import com.tydic.commodity.mall.constants.ModelRuleConstant;
import com.tydic.commodity.mall.dao.UccMallCommodityMapper;
import com.tydic.commodity.mall.dao.UccMallCommodityTypeMapper;
import com.tydic.commodity.mall.dao.UccMallVendorMapper;
import com.tydic.commodity.mall.dao.UccSkuExpandMapper;
import com.tydic.commodity.mall.dao.UccSkuExtMapper;
import com.tydic.commodity.mall.po.UccCommodityPo;
import com.tydic.commodity.mall.po.UccMallSkuVendorPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccMallReplacementPriceBusiServiceImpl
implements UccMallReplacementPriceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallReplacementPriceBusiServiceImpl.class);
    @Autowired
    private UccMallVendorMapper uccMallVendorMapper;
    @Autowired
    private InterfaceQryFscRuleAbilitySerive interfaceQryFscRuleAbilitySerive;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccSkuExtMapper uccSkuExtMapper;
    @Autowired
    private UccMallCommodityMapper uccMallCommodityMapper;
    @Autowired
    private UccMallCommodityTypeMapper uccMallCommodityTypeMapper;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public UccMallReplacementPriceRspBo replacePrice(UccMallReplacementPriceReqBo reqBO) {
        Map<Integer, List<ReplacePriceInfoBO>> groupBySource;
        UccMallReplacementPriceRspBo rspBO = new UccMallReplacementPriceRspBo();
        List replacePriceInfo = reqBO.getReplacePriceInfo();
        if (CollectionUtils.isEmpty((Collection)replacePriceInfo)) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setRespCode("8888");
            return rspBO;
        }
        if (!"1".equals(reqBO.getIsprofess()) || StringUtils.isEmpty((Object)reqBO.getCompanyId())) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRows(reqBO.getReplacePriceInfo());
            return rspBO;
        }
        List<Long> skuIds = replacePriceInfo.stream().map(ReplacePriceInfoBO::getSkuId).collect(Collectors.toList());
        List<UccMallSkuVendorPO> uccMallSkuVendorPOS = null;
        if (!CollectionUtils.isEmpty(skuIds) && !CollectionUtils.isEmpty(uccMallSkuVendorPOS = this.uccMallVendorMapper.batchSelectBySkuIds(skuIds))) {
            for (ReplacePriceInfoBO replacePriceInfoBO : reqBO.getReplacePriceInfo()) {
                for (UccMallSkuVendorPO uccMallSkuVendorPO : uccMallSkuVendorPOS) {
                    if (!replacePriceInfoBO.getSkuId().equals(uccMallSkuVendorPO.getSkuId())) continue;
                    replacePriceInfoBO.setCommodityTypeId(uccMallSkuVendorPO.getCommodityTypeId());
                    replacePriceInfoBO.setVendorId(uccMallSkuVendorPO.getVendorId());
                }
            }
        }
        if ((groupBySource = reqBO.getReplacePriceInfo().stream().collect(Collectors.groupingBy(ReplacePriceInfoBO::getSkuSource))).isEmpty()) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        ArrayList<InterfaceMerchantConfBatchQueryReqDataBO> qryInfo = new ArrayList<InterfaceMerchantConfBatchQueryReqDataBO>();
        InterfaceMerchantConfBatchQueryReqDataBO fscMerchantConfBatchQueryReqDataBO = null;
        for (Map.Entry<Integer, List<ReplacePriceInfoBO>> entry : groupBySource.entrySet()) {
            if (ModelRuleConstant.SKU_SOURCE_PROTOCOL_GENERATION.equals(entry.getKey())) {
                for (ReplacePriceInfoBO bo : entry.getValue()) {
                    fscMerchantConfBatchQueryReqDataBO = new InterfaceMerchantConfBatchQueryReqDataBO();
                    fscMerchantConfBatchQueryReqDataBO.setPurOrgId(reqBO.getCompanyId());
                    fscMerchantConfBatchQueryReqDataBO.setSupOrgId(bo.getVendorId());
                    fscMerchantConfBatchQueryReqDataBO.setCommodityTypeId(bo.getCommodityTypeId().toString());
                    qryInfo.add(fscMerchantConfBatchQueryReqDataBO);
                    qryInfo.add(fscMerchantConfBatchQueryReqDataBO);
                }
            }
            if (ModelRuleConstant.SKU_SOURCE_COMMERCE_IMPORT.equals(entry.getKey())) {
                for (ReplacePriceInfoBO bo : entry.getValue()) {
                    fscMerchantConfBatchQueryReqDataBO = new InterfaceMerchantConfBatchQueryReqDataBO();
                    fscMerchantConfBatchQueryReqDataBO.setPurOrgId(reqBO.getCompanyId());
                    fscMerchantConfBatchQueryReqDataBO.setSupOrgId(bo.getVendorId());
                    fscMerchantConfBatchQueryReqDataBO.setCommodityTypeId(bo.getCommodityTypeId().toString());
                    qryInfo.add(fscMerchantConfBatchQueryReqDataBO);
                }
            }
            if (!ModelRuleConstant.SKU_SOURCE_SELF_SUPPORT.equals(entry.getKey())) continue;
            for (ReplacePriceInfoBO bo : entry.getValue()) {
                fscMerchantConfBatchQueryReqDataBO = new InterfaceMerchantConfBatchQueryReqDataBO();
                fscMerchantConfBatchQueryReqDataBO.setPurOrgId(reqBO.getCompanyId());
                fscMerchantConfBatchQueryReqDataBO.setSupOrgId(bo.getVendorId());
                fscMerchantConfBatchQueryReqDataBO.setCommodityTypeId(bo.getCommodityTypeId().toString());
                UccCommodityPo uccCommodityPo = this.uccMallCommodityMapper.getCommodityById(bo.getCommodityId());
                fscMerchantConfBatchQueryReqDataBO.setModelContractId(uccCommodityPo.getOtherSourceId());
                qryInfo.add(fscMerchantConfBatchQueryReqDataBO);
            }
        }
        if (CollectionUtils.isEmpty(qryInfo)) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        InterfaceQryFscRuleAbilityReqBO CnncQryFscRuleAbilityReqBO = new InterfaceQryFscRuleAbilityReqBO();
        CnncQryFscRuleAbilityReqBO.setQryInfo(qryInfo);
        InterfaceQryFscRuleAbilityRspBO cnncQryFscRuleAbilityRspBO = this.interfaceQryFscRuleAbilitySerive.qryRule(CnncQryFscRuleAbilityReqBO);
        if (!"0000".equals(cnncQryFscRuleAbilityRspBO.getRespCode())) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc(cnncQryFscRuleAbilityRspBO.getRespDesc());
            return rspBO;
        }
        if (CollectionUtils.isEmpty(cnncQryFscRuleAbilityRspBO.getResult())) {
            this.replaceByPsDisount(reqBO);
            rspBO.setRows(reqBO.getReplacePriceInfo());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        Iterator iterator = reqBO.getReplacePriceInfo().iterator();
        block6: while (true) {
            if (!iterator.hasNext()) {
                this.replaceByPsDisount(reqBO);
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                rspBO.setRows(reqBO.getReplacePriceInfo());
                return rspBO;
            }
            ReplacePriceInfoBO eachprice = (ReplacePriceInfoBO)iterator.next();
            Iterator<InterfaceQryFscRuleAbilityBo> iterator2 = cnncQryFscRuleAbilityRspBO.getResult().iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block6;
                InterfaceQryFscRuleAbilityBo fsc = iterator2.next();
                if (!fsc.getVendorId().equals(eachprice.getVendorId()) || !fsc.getCommodityTypeId().equals(eachprice.getCommodityTypeId())) continue;
                if (eachprice.getContractId() != null) {
                    if (!fsc.getContractId().equals(eachprice.getOtherSourceId()) || fsc.getBusiMode() == null || fsc.getBusiMode() != 2) continue;
                    eachprice.setSalePrice(eachprice.getAgreementPrice());
                    eachprice.setLadderPrice(null);
                    eachprice.setReplace(Integer.valueOf(1));
                    continue;
                }
                if (fsc.getBusiMode() == null || fsc.getBusiMode() != 2) continue;
                eachprice.setSalePrice(eachprice.getAgreementPrice());
                eachprice.setLadderPrice(null);
                eachprice.setReplace(Integer.valueOf(1));
            }
            break;
        }
    }

    private void replaceByPsDisount(UccMallReplacementPriceReqBo reqBO) {
        if (reqBO.getPsDiscountRate() != null && reqBO.getPsDiscountRate().compareTo(BigDecimal.ZERO) != 0) {
            for (ReplacePriceInfoBO replacePriceInfoBO : reqBO.getReplacePriceInfo()) {
                if (replacePriceInfoBO.getReplace() == 1) continue;
                replacePriceInfoBO.setLadderPrice(null);
                if (replacePriceInfoBO.getSalePrice().equals(replacePriceInfoBO.getAgreementPrice())) continue;
                Long difValue = replacePriceInfoBO.getSalePrice() - replacePriceInfoBO.getAgreementPrice();
                Long salePirce = new BigDecimal(difValue.toString()).multiply(reqBO.getPsDiscountRate().divide(BigDecimal.valueOf(100L), 4, 0)).longValue() + replacePriceInfoBO.getAgreementPrice();
                replacePriceInfoBO.setSalePrice(salePirce);
            }
        }
    }
}

