/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.mall.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.bo.UccMallQueryParam;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSearchBarEsRspInfo;
import com.tydic.commodity.mall.busi.api.UccMallSearchEsQueryService;
import com.tydic.commodity.mall.busi.api.UccMallSearchProportionEsBusiService;
import com.tydic.commodity.mall.busi.api.UccMallSearchProportionEsService;
import com.tydic.commodity.mall.busi.bo.UccMallCommodityRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsRspBo;
import com.tydic.commodity.mall.busi.bo.UccMallSearchEsSQLRspBO;
import com.tydic.commodity.mall.busi.bo.UccMallSearchProportionReqBO;
import com.tydic.commodity.mall.constants.UccMallConstantsEnums;
import com.tydic.commodity.mall.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccMallSearchProportionEsBusiServiceImpl
implements UccMallSearchProportionEsBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMallSearchProportionEsBusiServiceImpl.class);
    @Autowired
    private UccMallSearchProportionEsService searchProportionEsService;
    @Autowired
    private UccMallSearchEsQueryService searchEsQueryService;
    private static Integer esSeaarchSize = 10000;

    @Override
    public UccMallSearchBarEsRspBO qryBySearchBar(UccMallSearchProportionReqBO reqBO) {
        UccMallSearchBarEsRspBO searchBarEsRspBO = new UccMallSearchBarEsRspBO();
        List params = null;
        ArrayList<UccMallQueryParam> queryParamBOs = new ArrayList<UccMallQueryParam>();
        if (CollectionUtils.isNotEmpty(reqBO.getUccMallQueryParams())) {
            params = JSON.parseArray((String)JSON.toJSONString(reqBO.getUccMallQueryParams()), UccMallQueryParam.class);
            for (UccMallQueryParam queryParam : params) {
                UccMallQueryParam queryParamBO = new UccMallQueryParam();
                BeanUtils.copyProperties((Object)queryParam, (Object)queryParamBO);
                queryParamBOs.add(queryParamBO);
            }
        }
        reqBO.setUccMallQueryParams(queryParamBOs);
        try {
            UccMallSearchEsSQLRspBO searchEsSQLRspBO = this.searchProportionEsService.buildSQL(reqBO);
            searchEsSQLRspBO.setField(false);
            searchEsSQLRspBO.setNeedKeyWorld(reqBO.isNeedKeyWorld());
            UccMallSearchEsRspBo rspBo = this.searchEsQueryService.executeSQL(searchEsSQLRspBO);
            if (rspBo == null) {
                log.info("\u67e5\u8be2ES\u6570\u636e\u670d\u52a1\u5f02\u5e38!!");
                searchBarEsRspBO.setRespCode(UccMallConstantsEnums.QUERY_RESULT_IS_EMPTY.code());
                searchBarEsRspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e!");
                searchBarEsRspBO.setPageNo(1);
                searchBarEsRspBO.setTotal(0);
                searchBarEsRspBO.setRecordsTotal(0);
                return searchBarEsRspBO;
            }
            List<UccMallQueryParam> propParams = rspBo.getPropParams();
            if (CollectionUtils.isNotEmpty(reqBO.getUccMallQueryParams())) {
                HashSet<String> queryFilterIds = new HashSet<String>();
                for (UccMallQueryParam queryParam : params) {
                    queryFilterIds.add(queryParam.getFilterId());
                }
                HashSet<String> filterIdSet = new HashSet<String>();
                HashSet<UccMallQueryParam> h1 = new HashSet<UccMallQueryParam>();
                if (propParams != null && propParams.size() > 0) {
                    for (UccMallQueryParam queryParam : propParams) {
                        String filterId = queryParam.getFilterId();
                        if (!filterIdSet.contains(filterId) && !queryFilterIds.contains(filterId)) {
                            h1.add(queryParam);
                        }
                        filterIdSet.add(filterId);
                    }
                    propParams.clear();
                    propParams.addAll(h1);
                }
            }
            rspBo.setPropParams(propParams);
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)searchBarEsRspBO);
            List<UccMallCommodityRspBo> commodityRspBos = rspBo.getUccMallCommodityRspBos();
            List<UccMallSearchBarEsRspInfo> result = this.convertRspBo(commodityRspBos);
            searchBarEsRspBO.setResult(result);
            int size = reqBO.getPageSize();
            int no = reqBO.getPageNo();
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            if (esSeaarchSize.compareTo(rspBo.getTotal()) > 0) {
                totalPage = rspBo.getTotal() / size;
                add = rspBo.getTotal() % size == 0 ? 0 : 1;
                total = rspBo.getTotal();
            } else {
                totalPage = esSeaarchSize / size;
                total = size * (totalPage + (add = esSeaarchSize % size == 0 ? 0 : 1));
                if (total.compareTo(rspBo.getTotal()) > 0) {
                    total = rspBo.getTotal();
                }
            }
            searchBarEsRspBO.setTotal(totalPage + add);
            searchBarEsRspBO.setPageNo(no);
            if (rspBo.getUccMallQueryParams() != null && rspBo.getPropParams() != null) {
                rspBo.getUccMallQueryParams().addAll(rspBo.getPropParams());
            }
            searchBarEsRspBO.setQueryParams(rspBo.getUccMallQueryParams());
            searchBarEsRspBO.setRecordsTotal(total.intValue());
            searchBarEsRspBO.setRespCode("0000");
            searchBarEsRspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
            return searchBarEsRspBO;
        }
        catch (ZTBusinessException e) {
            searchBarEsRspBO.setRespCode("8888");
            searchBarEsRspBO.setRespDesc(e.getMessage());
            return searchBarEsRspBO;
        }
        catch (Exception e1) {
            log.error("\u641c\u7d22\u5f02\u5e38 \uff1a" + e1.getMessage());
            searchBarEsRspBO.setRespCode("8888");
            searchBarEsRspBO.setRespDesc(e1.getMessage());
            return searchBarEsRspBO;
        }
    }

    private List<UccMallSearchBarEsRspInfo> convertRspBo(List<UccMallCommodityRspBo> commodityRspBos) {
        ArrayList<UccMallSearchBarEsRspInfo> searchBarEsRspInfos = new ArrayList<UccMallSearchBarEsRspInfo>();
        if (commodityRspBos != null && commodityRspBos.size() > 0) {
            for (UccMallCommodityRspBo commodityRspBo : commodityRspBos) {
                UccMallSearchBarEsRspInfo searchBarEsRspInfo = new UccMallSearchBarEsRspInfo();
                searchBarEsRspInfo.setCommodityId(Long.valueOf(commodityRspBo.getCommodity_id()));
                searchBarEsRspInfo.setSkuId(Long.valueOf(commodityRspBo.getSku_id()));
                searchBarEsRspInfo.setExtSkuId(commodityRspBo.getExt_sku_id());
                searchBarEsRspInfo.setPriPicUrl(commodityRspBo.getPicture_url());
                searchBarEsRspInfo.setAgreementPrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getAgreement_price())));
                searchBarEsRspInfo.setMarketPrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMarket_price())));
                searchBarEsRspInfo.setSalePrice(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getSale_price())));
                searchBarEsRspInfo.setMemberPrice1(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price1())));
                searchBarEsRspInfo.setMemberPrice2(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price2())));
                searchBarEsRspInfo.setMemberPrice3(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price3())));
                searchBarEsRspInfo.setMemberPrice4(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price4())));
                searchBarEsRspInfo.setMemberPrice5(MoneyUtils.haoToYuan(new BigDecimal(commodityRspBo.getMember_price5())));
                searchBarEsRspInfo.setCommentNumber(commodityRspBo.getComment_number());
                searchBarEsRspInfo.setSkuName(commodityRspBo.getSku_name());
                searchBarEsRspInfo.setSupplierShopId(commodityRspBo.getSupplier_shop_id());
                searchBarEsRspInfo.setSupplierShopName(commodityRspBo.getShop_name());
                searchBarEsRspInfo.setSupplierId(String.valueOf(commodityRspBo.getSupplier_id()));
                searchBarEsRspInfo.setSupplierName(commodityRspBo.getSupplier_name());
                searchBarEsRspInfo.setSkuSource(Integer.valueOf(commodityRspBo.getSku_source()));
                searchBarEsRspInfo.setCommodityName(commodityRspBo.getCommodity_name());
                searchBarEsRspInfo.setCommdPicUrl(commodityRspBo.getCommd_pic_url());
                if (commodityRspBo.getEcommerce_sale() != null) {
                    searchBarEsRspInfo.setEcommerceSale(Long.valueOf(commodityRspBo.getEcommerce_sale().longValue()));
                }
                searchBarEsRspInfo.setExtendProperties(commodityRspBo.getExtendProperties());
                searchBarEsRspInfo.setVendorName(commodityRspBo.getVendor_name());
                searchBarEsRspInfo.setAgreementId(Long.valueOf(commodityRspBo.getAgreement_id()));
                searchBarEsRspInfo.setTexture(commodityRspBo.getTexture());
                searchBarEsRspInfo.setModel(commodityRspBo.getModel());
                searchBarEsRspInfo.setVendorId(commodityRspBo.getVendor_id());
                searchBarEsRspInfo.setSpec(commodityRspBo.getSpec());
                searchBarEsRspInfo.setManufacturer(commodityRspBo.getManufacturer());
                searchBarEsRspInfo.setFigure(commodityRspBo.getFigure());
                searchBarEsRspInfo.setBrandName(commodityRspBo.getBrand_name());
                searchBarEsRspInfo.setMeasureName(commodityRspBo.getMeasure_name());
                searchBarEsRspInfos.add(searchBarEsRspInfo);
            }
        }
        commodityRspBos = null;
        return searchBarEsRspInfos;
    }
}

