/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.UocPebAccessoryBO;
import com.tydic.uoc.common.atom.api.PebOperationPermissionsCheckingAtomService;
import com.tydic.uoc.common.atom.api.UocCoreCreateAccessoryAtomService;
import com.tydic.uoc.common.atom.api.UocCoreStateCheckAtomService;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.api.UocZoneSpecificLinkBusiToDealAtomService;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomReqBO;
import com.tydic.uoc.common.atom.bo.PebOperationPermissionsCheckingAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreCreateAccessoryRspBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreStateCheckAtomRspBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.atom.bo.UocZoneSpecificLinkBusiToDealAtomReqBO;
import com.tydic.uoc.common.atom.bo.UocZoneSpecificLinkBusiToDealAtomRspBO;
import com.tydic.uoc.common.busi.api.UocGeneralCirculationBusiService;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationReqBO;
import com.tydic.uoc.common.busi.bo.UocGeneralCirculationRspBO;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocGeneralCirculationBusiServiceImpl
implements UocGeneralCirculationBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocGeneralCirculationBusiServiceImpl.class);
    @Autowired
    private PebOperationPermissionsCheckingAtomService pebOperationPermissionsCheckingAtomService;
    @Autowired
    private UocCoreStateCheckAtomService uocCoreStateCheckAtomService;
    @Autowired
    private UocZoneSpecificLinkBusiToDealAtomService uocZoneSpecificLinkBusiToDealAtomService;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private UocCoreCreateAccessoryAtomService uocCoreCreateAccessoryAtomService;

    @Override
    public UocGeneralCirculationRspBO dealGeneralCirculation(UocGeneralCirculationReqBO reqBO) {
        UocGeneralCirculationRspBO rspBO = new UocGeneralCirculationRspBO();
        if (reqBO.getAuthCtrl() == null) {
            reqBO.setAuthCtrl(PecConstant.AuthCtrl.NO_CTRL);
        }
        log.info("-----------------\u5f00\u59cb\u6743\u9650\u6821\u9a8c:{}--------------------", (Object)reqBO);
        this.doCheckAuthority(reqBO);
        log.info("-----------------\u5f00\u59cb\u72b6\u6001\u6821\u9a8c--------------------");
        this.doStateCheck(reqBO);
        this.saveFile(reqBO);
        Map<String, Object> variables = this.doSpecificLinks(reqBO);
        log.info("-----------------\u8c03\u7528\u72b6\u6001\u673a--------------------");
        this.doRunProcess(reqBO, variables, rspBO);
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void saveFile(UocGeneralCirculationReqBO reqBO) {
        List<UocPebAccessoryBO> pebAccessoryReqBOList = reqBO.getAccessoryList();
        if (!CollectionUtils.isEmpty(pebAccessoryReqBOList)) {
            for (UocPebAccessoryBO pebAccessoryReqBO : pebAccessoryReqBOList) {
                UocCoreCreateAccessoryReqBO uocCoreCreateAccessoryReqBO = new UocCoreCreateAccessoryReqBO();
                uocCoreCreateAccessoryReqBO.setAccessoryId(pebAccessoryReqBO.getAccessoryId());
                uocCoreCreateAccessoryReqBO.setAccessoryName(pebAccessoryReqBO.getAccessoryName());
                uocCoreCreateAccessoryReqBO.setAccessoryUrl(pebAccessoryReqBO.getAccessoryUrl());
                uocCoreCreateAccessoryReqBO.setAttachmentType(pebAccessoryReqBO.getAttachmentType());
                uocCoreCreateAccessoryReqBO.setOrderId(reqBO.getOrderId());
                uocCoreCreateAccessoryReqBO.setObjectType(reqBO.getObjType());
                uocCoreCreateAccessoryReqBO.setObjectId(reqBO.getObjId());
                uocCoreCreateAccessoryReqBO.setRemark(reqBO.getActionCode());
                UocCoreCreateAccessoryRspBO accessory = this.uocCoreCreateAccessoryAtomService.createAccessory(uocCoreCreateAccessoryReqBO);
                if ("0000".equals(accessory.getRespCode())) continue;
                throw new UocProBusinessException("100001", "\u751f\u6210\u9644\u4ef6\u4fe1\u606f,\u5931\u8d25\u63cf\u8ff0:" + accessory.getRespDesc());
            }
        }
    }

    private void doCheckAuthority(UocGeneralCirculationReqBO reqBO) {
        if (!PecConstant.AuthCtrl.NO_CTRL.equals(reqBO.getAuthCtrl())) {
            PebOperationPermissionsCheckingAtomReqBO permissionsCheckingAtomReqBO = new PebOperationPermissionsCheckingAtomReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)permissionsCheckingAtomReqBO));
            PebOperationPermissionsCheckingAtomRspBO permissionsCheckingAtomRspBO = this.pebOperationPermissionsCheckingAtomService.dealPebOperationPermissionsChecking(permissionsCheckingAtomReqBO);
            if (!"0000".equals(permissionsCheckingAtomRspBO.getRespCode())) {
                throw new UocProBusinessException("100001", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u6743\u9650\u6821\u9a8c\u5931\u8d25\uff0c\u5931\u8d25\u63cf\u8ff0\uff1a" + permissionsCheckingAtomRspBO.getRespDesc());
            }
        }
    }

    private void doStateCheck(UocGeneralCirculationReqBO reqBO) {
        UocCoreStateCheckAtomReqBO uocCoreStateCheckAtomReqBO = new UocCoreStateCheckAtomReqBO();
        uocCoreStateCheckAtomReqBO.setOrderId(reqBO.getOrderId());
        uocCoreStateCheckAtomReqBO.setObjId(reqBO.getObjId());
        uocCoreStateCheckAtomReqBO.setObjType(reqBO.getObjType());
        uocCoreStateCheckAtomReqBO.setActionCode(reqBO.getActionCode());
        UocCoreStateCheckAtomRspBO uocCoreStateCheck = this.uocCoreStateCheckAtomService.getUocCoreStateCheck(uocCoreStateCheckAtomReqBO);
        if (!"0000".equals(uocCoreStateCheck.getRespCode())) {
            throw new UocProBusinessException("100001", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u8ba2\u5355\u72b6\u6001\u6821\u9a8c\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + uocCoreStateCheck.getRespDesc());
        }
    }

    private Map<String, Object> doSpecificLinks(UocGeneralCirculationReqBO reqBO) {
        UocZoneSpecificLinkBusiToDealAtomReqBO specificLinkReq = new UocZoneSpecificLinkBusiToDealAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)specificLinkReq));
        log.info("uocZoneSpecificLinkBusiToDealAtomService\u5165\u53c2\uff1a{}", (Object)specificLinkReq);
        UocZoneSpecificLinkBusiToDealAtomRspBO specificLinkRsp = this.uocZoneSpecificLinkBusiToDealAtomService.dealSpecificLinkBusi(specificLinkReq);
        if (!"0000".equals(specificLinkRsp.getRespCode())) {
            throw new UocProBusinessException("100001", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u7279\u5b9a\u73af\u8282\u4e1a\u52a1\u5904\u7406\u539f\u5b50\u670d\u52a1\u5931\u8d25,\u5931\u8d25\u63cf\u8ff0:" + specificLinkRsp.getRespDesc());
        }
        return specificLinkRsp.getVariables();
    }

    private void doRunProcess(UocGeneralCirculationReqBO reqBO, Map<String, Object> map, UocGeneralCirculationRspBO rspBO) {
        rspBO.setAuto(this.run(reqBO.getOrderId(), reqBO.getObjId(), reqBO.getUserId() + "", map, reqBO.getObjType()));
    }

    private boolean run(Long orderId, Long objId, String userId, Map<String, Object> map, Integer objType) {
        UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
        processRunReqBO.setVariables(map);
        processRunReqBO.setOperId(userId);
        processRunReqBO.setSysCode("eb_el_sale_order_master_order_status");
        processRunReqBO.setObjId(objId);
        processRunReqBO.setObjType(objType);
        processRunReqBO.setOrderId(orderId);
        log.info("---------------- \u8c03\u7528\u72b6\u6001\u673a\u5165\u53c2\uff1a{}", (Object)processRunReqBO);
        UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
        log.info("---------------- \u8c03\u7528\u72b6\u6001\u673a\u51fa\u53c2\uff1a{}", (Object)uocProcessRunRspBO);
        if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
            throw new UocProBusinessException("102034", "\u901a\u7528\u6d41\u8f6c\u4e1a\u52a1\u670d\u52a1\u8c03\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
        }
        return uocProcessRunRspBO.getAuto();
    }
}

