/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.common.ability.bo.UocExpansionConditionsMapBO;
import com.tydic.uoc.common.busi.bo.UocEsCountStateNumReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryAbnormalListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryAbnormalTabNumberReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryAfsListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryAfsTabNumberReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryInspectionListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryOrderListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryOrderTabNumberReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryPurchaseListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryShipListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryStatisticsReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryTransactionServiceListReqBo;
import com.tydic.uoc.common.busi.bo.UocSearchEsSQLRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UocBuildEsQrySqlConditionUtil {
    private static Integer maxPageSize;

    @Value(value="${es.max.page.size:10000}")
    public void setMaxPageSize(Integer maxPageSize) {
        UocBuildEsQrySqlConditionUtil.maxPageSize = maxPageSize;
    }

    public String buildQryOrderEsSql(UocEsQryOrderListReqBO reqBO) {
        FieldSortBuilder sortQueryFirst;
        JSONObject queryJson;
        Long createTimeExp;
        Object createTimeEff;
        RangeQueryBuilder rangeQueryBuilder;
        Long createTimeEff2;
        Object shouldQueryBuilder;
        BoolQueryBuilder shouldQueryBuilder2;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolean cxPur = false;
        if (CollectionUtils.isNotEmpty(reqBO.getOrgListThrough()) || CollectionUtils.isNotEmpty(reqBO.getOrgList())) {
            cxPur = true;
        }
        boolean cxPro = false;
        if (CollectionUtils.isNotEmpty(reqBO.getOrgListThroughPro()) || CollectionUtils.isNotEmpty(reqBO.getOrgListPro())) {
            cxPro = true;
        }
        if (MapUtils.isNotEmpty(reqBO.getExpansionConditionsMap())) {
            for (Map.Entry<String, UocExpansionConditionsMapBO> entry : reqBO.getExpansionConditionsMap().entrySet()) {
                String mapKey = entry.getKey();
                UocExpansionConditionsMapBO mapValue = entry.getValue();
                if (StringUtils.isNotBlank((CharSequence)mapValue.getShouldConditionName())) {
                    BoolQueryBuilder shouldQueryBuilder3 = QueryBuilders.boolQuery();
                    shouldQueryBuilder3.should((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
                    shouldQueryBuilder3.should((QueryBuilder)QueryBuilders.termsQuery((String)mapValue.getShouldConditionName(), (Collection)mapValue.getShouldConditions()));
                    boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder3);
                    continue;
                }
                if (mapValue.getIsExpansionConditions().booleanValue()) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSearchKey())) {
            reqBO.setSaleVoucherNo(null);
            reqBO.setSkuName(null);
            reqBO.setCouponName(null);
            reqBO.setSupName(null);
            BoolQueryBuilder shouldQueryBuilder4 = QueryBuilders.boolQuery();
            shouldQueryBuilder4.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSearchKey() + "*")));
            shouldQueryBuilder4.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSearchKey() + "*")));
            shouldQueryBuilder4.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"couponName.keyword", (String)("*" + reqBO.getSearchKey() + "*")));
            shouldQueryBuilder4.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"supName.keyword", (String)("*" + reqBO.getSearchKey() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder4);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getModel())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBO.getModel() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSpec())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBO.getSpec() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShipVoucherCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"shipVoucherCode.keyword", (String)("*" + reqBO.getShipVoucherCode() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInspectionVoucherCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"inspectionVoucherCode.keyword", (String)("*" + reqBO.getInspectionVoucherCode() + "*")));
        }
        if (null != reqBO.getPayType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payType", (Object)reqBO.getPayType()));
        }
        if (null != reqBO.getUpperOrderId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"upperOrderId", (Object)reqBO.getUpperOrderId()));
        }
        if (null != reqBO.getIsShowShip()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isShowShip", (Object)reqBO.getIsShowShip()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAuditResult())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"auditResult", (String)reqBO.getAuditResult()));
        }
        if (null != reqBO.getDistributionFlag()) {
            BoolQueryBuilder queryBuilder;
            BoolQueryBuilder mustQueryBuilder;
            BoolQueryBuilder org;
            boolean isAll = false;
            if (CollectionUtils.isNotEmpty(reqBO.getOrgListThrough()) || CollectionUtils.isNotEmpty(reqBO.getOrgList())) {
                org = this.like(reqBO.getOrgList(), reqBO.getOrgListThrough(), "orgPath");
                if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList()) && CollectionUtils.isNotEmpty(reqBO.getOnceProDeliveryIdList())) {
                    isAll = true;
                    shouldQueryBuilder2 = QueryBuilders.boolQuery();
                    mustQueryBuilder = QueryBuilders.boolQuery();
                    mustQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
                    mustQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"onceProDeliveryId", reqBO.getOnceProDeliveryIdList()));
                    shouldQueryBuilder2.should((QueryBuilder)mustQueryBuilder);
                    queryBuilder = QueryBuilders.boolQuery();
                    queryBuilder.must((QueryBuilder)org);
                    queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"saleState", (String)"2109"));
                    shouldQueryBuilder2.should((QueryBuilder)queryBuilder);
                    boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder2);
                } else {
                    boolQueryBuilder.must((QueryBuilder)org);
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"saleState", (String)"2109"));
                }
            } else if (CollectionUtils.isNotEmpty(reqBO.getOrgListThroughPro()) || CollectionUtils.isNotEmpty(reqBO.getOrgListPro())) {
                org = this.like(reqBO.getOrgListPro(), reqBO.getOrgListThroughPro(), "orgPathPro");
                if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList()) && CollectionUtils.isNotEmpty(reqBO.getOnceProDeliveryIdList())) {
                    isAll = true;
                    shouldQueryBuilder2 = QueryBuilders.boolQuery();
                    mustQueryBuilder = QueryBuilders.boolQuery();
                    mustQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
                    mustQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"onceProDeliveryId", reqBO.getOnceProDeliveryIdList()));
                    shouldQueryBuilder2.should((QueryBuilder)mustQueryBuilder);
                    queryBuilder = QueryBuilders.boolQuery();
                    queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"saleState", (String)"2109"));
                    queryBuilder.must((QueryBuilder)org);
                    shouldQueryBuilder2.should((QueryBuilder)queryBuilder);
                    boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder2);
                } else {
                    boolQueryBuilder.must((QueryBuilder)org);
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"saleState", (String)"2109"));
                }
            }
            if (!isAll && CollectionUtils.isNotEmpty(reqBO.getSaleStateList()) && CollectionUtils.isNotEmpty(reqBO.getOnceProDeliveryIdList())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"onceProDeliveryId", reqBO.getOnceProDeliveryIdList()));
            }
        }
        if (null != reqBO.getAdjustmentFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"adjustmentFlag", (Object)reqBO.getAdjustmentFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccountName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purAccountName", (String)reqBO.getPurAccountName()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"supName", (Object)reqBO.getSupName()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList()) && CollectionUtils.isEmpty(reqBO.getOnceProDeliveryIdList()) && null == reqBO.getDistributionFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSaleStateQuery())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateQuery()));
        }
        if (reqBO.getServStateList() != null && !reqBO.getServStateList().isEmpty()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
        } else if (reqBO.getServState() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)reqBO.getServState()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderId", reqBO.getOrderIdList()));
        }
        if (reqBO.getOrderId() != null && reqBO.getOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)reqBO.getOrderId()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderTypeList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderType", reqBO.getOrderTypeList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderType", (String)reqBO.getOrderType()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getGoodsType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"goodsType", (String)reqBO.getGoodsType()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCouponId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"couponId", (String)reqBO.getCouponId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTypeName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"typeName", (Object)reqBO.getTypeName()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getUserType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"userType", (String)reqBO.getUserType()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderSource", (String)reqBO.getOrderSource()));
        }
        if (reqBO.getServType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId()) && cxPur) {
            BoolQueryBuilder org = this.like(reqBO.getOrgList(), reqBO.getOrgListThrough(), "orgPath");
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)org);
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isEmpty(reqBO.getProDeliveryIdList()) && CollectionUtils.isEmpty(reqBO.getOnceProDeliveryIdList()) && null == reqBO.getDistributionFlag() && cxPur) {
            BoolQueryBuilder org = this.like(reqBO.getOrgList(), reqBO.getOrgListThrough(), "orgPath");
            boolQueryBuilder.must((QueryBuilder)org);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderDesc())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderDesc.keyword", (String)("*" + reqBO.getOrderDesc() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSaleVoucherIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"objId", reqBO.getSaleVoucherIdList()));
        } else if (null != reqBO.getSaleVoucherId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"objId.keyword", (String)("*" + reqBO.getSaleVoucherId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            BoolQueryBuilder shouldQueryBuilder5 = QueryBuilders.boolQuery();
            shouldQueryBuilder5.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder5.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder5);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAggregationCondition())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"aggregationCondition.keyword", (String)("*" + reqBO.getAggregationCondition() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuId.keyword", (String)("*" + reqBO.getSkuId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"outSkuId.keyword", (String)("*" + reqBO.getOutSkuId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCouponName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"couponName.keyword", (String)("*" + reqBO.getCouponName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getReceiver())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"receiver", (Object)reqBO.getReceiver()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTbOrderId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"tbOrderId", (Object)reqBO.getTbOrderId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getConsignee())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"consignee.keyword", (String)("*" + reqBO.getConsignee() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getConsigneePhone())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"consigneePhone.keyword", (String)("*" + reqBO.getConsigneePhone() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutOrderNo())) {
            BoolQueryBuilder shouldQueryBuilder6 = QueryBuilders.boolQuery();
            shouldQueryBuilder6.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"outOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            shouldQueryBuilder6.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"poutOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder6);
        } else if (CollectionUtils.isNotEmpty(reqBO.getOutOrderNoList())) {
            BoolQueryBuilder shouldQueryBuilder7 = QueryBuilders.boolQuery();
            for (String outOrderNo : reqBO.getOutOrderNoList()) {
                shouldQueryBuilder7.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"outOrderNo", (Object)outOrderNo));
                shouldQueryBuilder7.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"poutOrderNo", (Object)outOrderNo));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder7);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayVourcherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"payVourcherNo", (Object)reqBO.getPayVourcherNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + reqBO.getCreateOperName() + "*")));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateUserName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + reqBO.getCreateUserName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperPhone())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperPhone.keyword", (String)("*" + reqBO.getCreateOperPhone() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purAccount", reqBO.getPurAccountList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccount())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purAccount", (String)reqBO.getPurAccount()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (null != reqBO.getRefundFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"refundFlag", (Object)reqBO.getRefundFlag()));
        } else if (null != reqBO.getReturnFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"refundFlag", (Object)reqBO.getReturnFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getEvaluationState())) {
            if ("0".equals(reqBO.getEvaluationState())) {
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"evaluateState", (String)"1"));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"evaluateState", (String)reqBO.getEvaluationState()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlaAgreementCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"plaAgreementCode", (Object)reqBO.getPlaAgreementCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderName.keyword", (String)("*" + reqBO.getOrderName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProtocolName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"protocolName", (Object)reqBO.getProtocolName()));
        }
        if (null != reqBO.getVendorDepartmentId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendorDepartmentId", (Object)reqBO.getVendorDepartmentId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDistributionDept())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"distributionDept", (Object)reqBO.getDistributionDept()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupAgreementCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supAgreementCode", (String)reqBO.getSupAgreementCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupAgreementName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"supAgreementName", (Object)reqBO.getSupAgreementName()));
        }
        if (null != reqBO.getPurchaseVoucherId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purchaseVoucherId", (Object)reqBO.getPurchaseVoucherId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaseVoucherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaseVoucherNo.keyword", (String)("*" + reqBO.getPurchaseVoucherNo() + "*")));
        }
        if (null != reqBO.getPurchaseState()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purchaseState", (Object)reqBO.getPurchaseState()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProtocolId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"protocolId", (String)reqBO.getProtocolId()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSalePostIdList())) {
            BoolQueryBuilder shouldQueryBuilder8 = QueryBuilders.boolQuery();
            for (String salePostIdList : reqBO.getSalePostIdList()) {
                shouldQueryBuilder8.should((QueryBuilder)QueryBuilders.termQuery((String)"salePostIdList", (String)salePostIdList));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
                shouldQueryBuilder8.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
                shouldQueryBuilder8.should((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder8);
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proAccount", reqBO.getProAccountList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSupNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNo", reqBO.getSupNoList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getTaskOperIdList())) {
            BoolQueryBuilder shouldQueryBuilder9 = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getTaskOperIdList()) {
                shouldQueryBuilder9.should((QueryBuilder)QueryBuilders.termQuery((String)"taskOperIdList", (String)taskOperId));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getExcessApproverList())) {
                for (String excessApprover : reqBO.getExcessApproverList()) {
                    shouldQueryBuilder9.should((QueryBuilder)QueryBuilders.termsQuery((String)"excessApproverList", (String[])new String[]{excessApprover}));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
                shouldQueryBuilder9.should((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder9);
        } else if (CollectionUtils.isNotEmpty(reqBO.getExcessApproverList())) {
            BoolQueryBuilder shouldQueryBuilder10 = QueryBuilders.boolQuery();
            for (String excessApprover : reqBO.getExcessApproverList()) {
                shouldQueryBuilder10.should((QueryBuilder)QueryBuilders.termsQuery((String)"excessApproverList", (String[])new String[]{excessApprover}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder10);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList()) && cxPro) {
            BoolQueryBuilder org = this.like(reqBO.getOrgListPro(), reqBO.getOrgListThroughPro(), "orgPathPro");
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            shouldQueryBuilder.should((QueryBuilder)org);
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (null == reqBO.getDistributionFlag() && cxPro) {
            BoolQueryBuilder org = this.like(reqBO.getOrgListPro(), reqBO.getOrgListThroughPro(), "orgPathPro");
            boolQueryBuilder.must((QueryBuilder)org);
        } else if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
            if (CollectionUtils.isNotEmpty(reqBO.getOrgListThrough()) || CollectionUtils.isNotEmpty(reqBO.getOrgList())) {
                BoolQueryBuilder org = this.like(reqBO.getOrgList(), reqBO.getOrgListThrough(), "orgPath");
                shouldQueryBuilder = QueryBuilders.boolQuery();
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
                shouldQueryBuilder.should((QueryBuilder)org);
                boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            }
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPriceTaskOperIdList())) {
            BoolQueryBuilder shouldQueryBuilder11 = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getPriceTaskOperIdList()) {
                shouldQueryBuilder11.should((QueryBuilder)QueryBuilders.termQuery((String)"priceTaskOperIdList", (String)taskOperId));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getPriceApproverList())) {
                for (String priceApprover : reqBO.getPriceApproverList()) {
                    shouldQueryBuilder11.should((QueryBuilder)QueryBuilders.termsQuery((String)"priceApproverList", (String[])new String[]{priceApprover}));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPriceTaskUserId())) {
                shouldQueryBuilder11.should((QueryBuilder)QueryBuilders.termsQuery((String)"priceTaskUserIdList", (String[])new String[]{reqBO.getPriceTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder11);
        } else if (CollectionUtils.isNotEmpty(reqBO.getPriceApproverList())) {
            if (1 == reqBO.getPriceApproverList().size()) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"priceApproverList", (String[])new String[]{reqBO.getPriceApproverList().get(0)}));
            } else {
                for (String priceApprover : reqBO.getPriceApproverList()) {
                    shouldQueryBuilder2 = QueryBuilders.boolQuery();
                    shouldQueryBuilder2.should((QueryBuilder)QueryBuilders.termsQuery((String)"priceApproverList", (String[])new String[]{priceApprover}));
                    boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder2);
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPriceTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"priceTaskUserIdList", (String[])new String[]{reqBO.getPriceTaskUserId()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurRelaName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purRelaName.keyword", (String)("*" + reqBO.getPurRelaName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getVendorOrderType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendorOrderType", (String)reqBO.getVendorOrderType()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                createTimeEff2 = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder2.gte((Object)createTimeEff2);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                Long createTimeExp2 = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder2.lte((Object)createTimeExp2);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        if (null != reqBO.getSaleFeeMoneyEff() || null != reqBO.getSaleFeeMoneyExp()) {
            RangeQueryBuilder rangeQueryBuilder3 = QueryBuilders.rangeQuery((String)"saleFeeMoney");
            if (null != reqBO.getSaleFeeMoneyEff()) {
                rangeQueryBuilder3.gte((Object)reqBO.getSaleFeeMoneyEff().multiply(new BigDecimal(10000)).longValue());
            }
            if (null != reqBO.getSaleFeeMoneyExp()) {
                rangeQueryBuilder3.lte((Object)reqBO.getSaleFeeMoneyExp().multiply(new BigDecimal(10000)).longValue());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder3);
        }
        if (null != reqBO.getIsAfterSales() && reqBO.getIsAfterSales().booleanValue()) {
            RangeQueryBuilder rangeQueryBuilder4 = QueryBuilders.rangeQuery((String)"availableAfterOrderCount");
            rangeQueryBuilder4.gt((Object)0);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder4);
        }
        if (reqBO.getUpdateTime() != null && reqBO.getUpdateTime() != 0L) {
            RangeQueryBuilder rangeQueryBuilder5 = QueryBuilders.rangeQuery((String)"updateTime");
            createTimeEff2 = reqBO.getUpdateTime();
            rangeQueryBuilder5.lte((Object)createTimeEff2);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder5);
        }
        if (reqBO.getToDistributionTime() != null) {
            RangeQueryBuilder rangeQueryBuilder6 = QueryBuilders.rangeQuery((String)"toDistributionTime");
            Long toDistributionTime = reqBO.getToDistributionTime().getTime();
            rangeQueryBuilder6.gte((Object)toDistributionTime);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder6);
        }
        SortOrder order = SortOrder.DESC;
        if (reqBO.getNotShipTime() != null) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"payTime");
            createTimeEff = reqBO.getNotShipTime().getTime();
            rangeQueryBuilder.lte(createTimeEff);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
            order = SortOrder.ASC;
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payStatus", (String)reqBO.getPayStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuMaterialId.keyword", (String)("*" + reqBO.getSkuMaterialId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuMaterialName.keyword", (String)("*" + reqBO.getSkuMaterialName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialTypeId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuMaterialTypeId.keyword", (String)("*" + reqBO.getSkuMaterialTypeId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuMaterialTypeName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuMaterialTypeName.keyword", (String)("*" + reqBO.getSkuMaterialTypeName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCancelOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cancelOperId", (String)reqBO.getCancelOperId()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getCancelTaskOperIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getCancelTaskOperIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"cancelTaskOperIdList", (String)taskOperId));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCancelApproverId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"cancelApproverIdList", (String[])new String[]{reqBO.getCancelApproverId()}));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCancelTaskUserId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"cancelTaskUserIdList", (String[])new String[]{reqBO.getCancelTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCancelApproverId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"cancelApproverIdList", (String[])new String[]{reqBO.getCancelApproverId()}));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCancelTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"cancelTaskUserIdList", (String[])new String[]{reqBO.getCancelTaskUserId()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCancelOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"cancelOperName.keyword", (String)("*" + reqBO.getCancelOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCancelNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"cancelNo.keyword", (String)("*" + reqBO.getCancelNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCancelStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cancelStatus", (String)reqBO.getCancelStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCancelTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCancelTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"cancelTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCancelTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)reqBO.getCancelTimeEff()).getTime();
                rangeQueryBuilder.gte(createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCancelTimeExp())) {
                createTimeExp = DateUtils.strToDateLong((String)reqBO.getCancelTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getApprovalTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getApprovalTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"approvalTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getApprovalTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)reqBO.getApprovalTimeEff()).getTime();
                rangeQueryBuilder.gte(createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getApprovalTimeExp())) {
                createTimeExp = DateUtils.strToDateLong((String)reqBO.getApprovalTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proNo", reqBO.getProNoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderStage())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderStage", (String)reqBO.getOrderStage()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTradeMode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tradeMode", (String)reqBO.getTradeMode()));
        }
        if (reqBO.getAgreementMode() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreementMode", (Object)reqBO.getAgreementMode()));
        }
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            TermsAggregationBuilder agg = null;
            if (StringUtils.isNotBlank((CharSequence)reqBO.getStatisticsField())) {
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field(reqBO.getStatisticsField());
                agg.size(reqBO.getPageNo() * reqBO.getPageSize());
            } else if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList()) || CollectionUtils.isNotEmpty(reqBO.getSaleStateQuery())) {
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("saleState");
                List<Integer> stateList = new ArrayList<Integer>(reqBO.getSaleStateList());
                if (CollectionUtils.isNotEmpty(reqBO.getSaleStateQuery())) {
                    stateList.addAll(reqBO.getSaleStateQuery());
                }
                stateList = stateList.stream().distinct().collect(Collectors.toList());
                agg.size(stateList.size());
            }
            queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != agg) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
            }
            return queryJson.toJSONString();
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSumField())) {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.size(1);
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.from(0);
            queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            List<String> sumField = reqBO.getSumField();
            for (String field : sumField) {
                if (!StringUtils.isNotBlank((CharSequence)field)) continue;
                searchSourceBuilder.aggregation((AggregationBuilder)((SumAggregationBuilder)AggregationBuilders.sum((String)field).field(field)).format("0.00"));
            }
            queryJson.put("aggs", (Object)JSON.parseObject((String)searchSourceBuilder.aggregations().toString()));
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (reqBO.getOrderBy() != null) {
            order = SortOrder.ASC;
            sortQueryFirst = (FieldSortBuilder)SortBuilders.fieldSort((String)reqBO.getOrderBy()).order(order);
        } else {
            sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        }
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        fieldSortBuilders.add(sortQueryFirst);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String countOrderTabNumber(UocEsQryOrderTabNumberReqBO reqBO) {
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getExpansionConditionsMap() != null && !reqBO.getExpansionConditionsMap().isEmpty()) {
            for (Map.Entry<String, UocExpansionConditionsMapBO> entry : reqBO.getExpansionConditionsMap().entrySet()) {
                String mapKey = entry.getKey();
                UocExpansionConditionsMapBO mapValue = entry.getValue();
                if (mapValue.getIsExpansionConditions().booleanValue()) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
            }
        }
        if (reqBO.getOrderId() != null && reqBO.getOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)reqBO.getOrderId()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderSource", (String)reqBO.getOrderSource()));
        }
        if (reqBO.getServType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purNo", reqBO.getPurNoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderDesc())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderDesc.keyword", (String)("*" + reqBO.getOrderDesc() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAggregationCondition())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"aggregationCondition.keyword", (String)("*" + reqBO.getAggregationCondition() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuId.keyword", (String)("*" + reqBO.getSkuId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"outSkuId.keyword", (String)("*" + reqBO.getOutSkuId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getTbOrderId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"tbOrderId", (Object)reqBO.getTbOrderId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getConsignee())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"consignee.keyword", (String)("*" + reqBO.getConsignee() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getConsigneePhone())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"consigneePhone.keyword", (String)("*" + reqBO.getConsigneePhone() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutOrderNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"outOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"poutOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayVourcherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"payVourcherNo", (Object)reqBO.getPayVourcherNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + reqBO.getCreateOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperPhone())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperPhone.keyword", (String)("*" + reqBO.getCreateOperPhone() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purAccount", reqBO.getPurAccountList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccount())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purAccount", (String)reqBO.getPurAccount()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (null != reqBO.getRefundFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"refundFlag", (Object)reqBO.getRefundFlag()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPlaAgreementCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"plaAgreementCode", (String)reqBO.getPlaAgreementCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"orderName", (Object)reqBO.getOrderName()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProtocolName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"protocolName", (Object)reqBO.getProtocolName()));
        }
        if (null != reqBO.getVendorDepartmentId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendorDepartmentId", (Object)reqBO.getVendorDepartmentId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getDistributionDept())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"distributionDept", (Object)reqBO.getDistributionDept()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupAgreementCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supAgreementCode", (String)reqBO.getSupAgreementCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupAgreementName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"supAgreementName", (Object)reqBO.getSupAgreementName()));
        }
        if (null != reqBO.getPurchaseVoucherId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purchaseVoucherId", (Object)reqBO.getPurchaseVoucherId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaseVoucherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaseVoucherNo.keyword", (String)("*" + reqBO.getPurchaseVoucherNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProtocolId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"protocolId", (String)reqBO.getProtocolId()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proAccount", reqBO.getProAccountList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSupNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNo", reqBO.getSupNoList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getTaskOperIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getTaskOperIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"taskOperIdList", (String)taskOperId));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getExcessApproverList())) {
                for (String excessApprover : reqBO.getExcessApproverList()) {
                    shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"excessApproverList", (String[])new String[]{excessApprover}));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getExcessApproverList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String excessApprover : reqBO.getExcessApproverList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"excessApproverList", (String[])new String[]{excessApprover}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList()) && CollectionUtils.isNotEmpty(reqBO.getOnceProDeliveryIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"onceProDeliveryId", reqBO.getOnceProDeliveryIdList()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList()) && CollectionUtils.isNotEmpty(reqBO.getProNoList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proNo", reqBO.getProNoList()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getOnceProDeliveryIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"onceProDeliveryId", reqBO.getOnceProDeliveryIdList()));
        } else if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proNo", reqBO.getProNoList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSalePostIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String salePostIdList : reqBO.getSalePostIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"salePostIdList", (String)salePostIdList));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPriceTaskOperIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getPriceTaskOperIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"priceTaskOperIdList", (String)taskOperId));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getPriceApproverList())) {
                for (String priceApprover : reqBO.getPriceApproverList()) {
                    shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"priceApproverList", (String[])new String[]{priceApprover}));
                }
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getPriceTaskUserId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"priceTaskUserIdList", (String[])new String[]{reqBO.getPriceTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getPriceApproverList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String priceApprover : reqBO.getPriceApproverList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"priceApproverList", (String[])new String[]{priceApprover}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPriceTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"priceTaskUserIdList", (String[])new String[]{reqBO.getPriceTaskUserId()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurRelaName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purRelaName.keyword", (String)("*" + reqBO.getPurRelaName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                Long l = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)l);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                Long l = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)l);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (reqBO.getUpdateTime() != null && reqBO.getUpdateTime() != 0L) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"updateTime");
            Long l = reqBO.getUpdateTime();
            rangeQueryBuilder.lte((Object)l);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (reqBO.getNotShipTime() != null) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"payTime");
            Long l = reqBO.getNotShipTime().getTime();
            rangeQueryBuilder.lte((Object)l);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        TermsAggregationBuilder agg = null;
        if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
            agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("saleState");
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurchaseStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purchaseState", reqBO.getPurchaseStateList()));
            agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("purchaseState");
        }
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("size", (Object)0);
        jSONObject.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        if (null != agg) {
            jSONObject.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
        }
        return jSONObject.toJSONString();
    }

    public String buildQryAfsEsSql(UocEsQryAfsListReqBO reqBO) {
        Long createTimeExp;
        Long createTimeEff;
        RangeQueryBuilder rangeQueryBuilder;
        Integer servState;
        BoolQueryBuilder org;
        BoolQueryBuilder org2;
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getExpansionConditionsMap() != null && !reqBO.getExpansionConditionsMap().isEmpty()) {
            for (Map.Entry<String, UocExpansionConditionsMapBO> entry : reqBO.getExpansionConditionsMap().entrySet()) {
                String mapKey = entry.getKey();
                UocExpansionConditionsMapBO mapValue = entry.getValue();
                if (mapValue.getIsExpansionConditions().booleanValue()) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
            }
        }
        boolean cxPur = false;
        if (CollectionUtils.isNotEmpty(reqBO.getOrgListThrough()) || CollectionUtils.isNotEmpty(reqBO.getOrgList())) {
            cxPur = true;
        }
        boolean cxPro = false;
        if (CollectionUtils.isNotEmpty(reqBO.getOrgListThroughPro()) || CollectionUtils.isNotEmpty(reqBO.getOrgListPro())) {
            cxPro = true;
        }
        if (null != reqBO.getPayAfterState()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payAfterState", (Object)reqBO.getPayAfterState()));
        }
        if (reqBO.getOrderId() != null && reqBO.getOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)reqBO.getOrderId()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderTypeList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderType", reqBO.getOrderTypeList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderType", (String)reqBO.getOrderType()));
        }
        if (reqBO.getObjId() != null && reqBO.getObjId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"objId", (Object)reqBO.getObjId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId()) && cxPur) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            org2 = this.like(reqBO.getOrgList(), reqBO.getOrgListThrough(), "orgPath");
            shouldQueryBuilder.should((QueryBuilder)org2);
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptorId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"acceptorId", (String)reqBO.getAcceptorId()));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptorId()) && StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"acceptorId", (String)reqBO.getAcceptorId()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getOrgList()) || CollectionUtils.isNotEmpty(reqBO.getOrgListThrough())) {
            org = this.like(reqBO.getOrgList(), reqBO.getOrgListThrough(), "orgPath");
            boolQueryBuilder.must((QueryBuilder)org);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAfsServiceId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"afsServiceId.keyword", (String)("*" + reqBO.getAfsServiceId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSearchKey())) {
            reqBO.setSaleVoucherNo(null);
            reqBO.setSkuName(null);
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSearchKey() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSearchKey() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList()) && cxPro) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            org2 = this.like(reqBO.getOrgListPro(), reqBO.getOrgListThroughPro(), "orgPathPro");
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            shouldQueryBuilder.should((QueryBuilder)org2);
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getOrgListPro()) || CollectionUtils.isNotEmpty(reqBO.getOrgListThroughPro())) {
            org = this.like(reqBO.getOrgListPro(), reqBO.getOrgListThroughPro(), "orgPathPro");
            boolQueryBuilder.must((QueryBuilder)org);
        } else if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", (String[])new String[]{reqBO.getOrderSource()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderName.keyword", (String)("*" + reqBO.getOrderName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaserVoucherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaserVoucherNo.keyword", (String)("*" + reqBO.getPurchaserVoucherNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCouponNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"couponNo", (String)reqBO.getCouponNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderCategory())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderCategory", (String)reqBO.getOrderCategory()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSupNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNo", reqBO.getSupNoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (String)reqBO.getSkuId()));
        }
        if (null != reqBO.getServType() && null != reqBO.getDealResult() && CollectionUtils.isNotEmpty(reqBO.getServStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
            servState = Integer.valueOf(String.valueOf(reqBO.getDealResult()).substring(2, 6));
            if (reqBO.getServStateList().contains(servState)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)servState));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
            }
        } else if (null != reqBO.getServType() && null != reqBO.getDealResult()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
            servState = Integer.valueOf(String.valueOf(reqBO.getDealResult()).substring(2, 6));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)servState));
        } else if (null != reqBO.getDealResult() && CollectionUtils.isNotEmpty(reqBO.getServStateList())) {
            servState = Integer.valueOf(String.valueOf(reqBO.getDealResult()).substring(2, 6));
            if (reqBO.getServStateList().contains(servState)) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)servState));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
            }
        } else if (null != reqBO.getServType() && CollectionUtils.isNotEmpty(reqBO.getServStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
        } else if (null != reqBO.getDealResult()) {
            Integer servType = Integer.valueOf(String.valueOf(reqBO.getDealResult()).substring(0, 2));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)servType));
            Integer servState2 = Integer.valueOf(String.valueOf(reqBO.getDealResult()).substring(2, 6));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)servState2));
        } else if (null != reqBO.getServType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
        } else if (CollectionUtils.isNotEmpty(reqBO.getServStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getServStateQuery())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateQuery()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAfterServiceNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"afterServiceNo.keyword", (String)("*" + reqBO.getAfterServiceNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purName.keyword", (String)("*" + reqBO.getPurName() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purAccount", reqBO.getPurAccountList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccountName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purAccountName.keyword", (String)("*" + reqBO.getPurAccountName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getJdShippingInfoStatus()) && StringUtils.isNotBlank((CharSequence)reqBO.getShippingInfoStatus())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"jdShippingInfoStatus", (String)reqBO.getJdShippingInfoStatus()));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"shippingInfoStatus", (String)reqBO.getShippingInfoStatus()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getJdShippingInfoStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"jdShippingInfoStatus", (String)reqBO.getJdShippingInfoStatus()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getShippingInfoStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"shippingInfoStatus", (String)reqBO.getShippingInfoStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInspectionVoucherCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"inspectionVoucherCode.keyword", (String)("*" + reqBO.getInspectionVoucherCode() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payType", (String)reqBO.getPayType()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + reqBO.getCreateOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                createTimeExp = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getOrderTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"orderTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)reqBO.getOrderTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderTimeExp())) {
                createTimeExp = DateUtils.strToDateLong((String)reqBO.getOrderTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getConfirmTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getConfirmTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"confirmTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getConfirmTimeEff())) {
                Long supplierTimeEff = DateUtils.strToDateLong((String)reqBO.getConfirmTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)supplierTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getConfirmTimeExp())) {
                Long supplierTimeExp = DateUtils.strToDateLong((String)reqBO.getConfirmTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)supplierTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            TermsAggregationBuilder agg = null;
            if (CollectionUtils.isNotEmpty(reqBO.getServStateList()) || CollectionUtils.isNotEmpty(reqBO.getServStateQuery())) {
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("servState");
                List<Integer> stateList = new ArrayList<Integer>(reqBO.getServStateList());
                if (CollectionUtils.isNotEmpty(reqBO.getServStateQuery())) {
                    stateList.addAll(reqBO.getServStateQuery());
                }
                stateList = stateList.stream().distinct().collect(Collectors.toList());
                agg.size(stateList.size());
            }
            JSONObject queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != agg) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
            }
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(SortOrder.DESC)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String countAfsTabNumber(UocEsQryAfsTabNumberReqBO reqBO) {
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getOrderId() != null && reqBO.getOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)reqBO.getOrderId()));
        }
        if (reqBO.getObjId() != null && reqBO.getObjId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"objId", (Object)reqBO.getObjId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"supNo", (Object)reqBO.getOrgId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAfsServiceId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"afsServiceId.keyword", (String)("*" + reqBO.getAfsServiceId() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getStatusPostIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String statusPostIdList : reqBO.getStatusPostIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"statusPostIdList", (String)statusPostIdList));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (CollectionUtils.isNotEmpty(reqBO.getProDeliveryIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proDeliveryId", reqBO.getProDeliveryIdList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", (String[])new String[]{reqBO.getOrderSource()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId()) && StringUtils.isNotBlank((CharSequence)reqBO.getAcceptorId())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"acceptorId", (String)reqBO.getAcceptorId()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaserVoucherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaserVoucherNo.keyword", (String)("*" + reqBO.getPurchaserVoucherNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (String)reqBO.getSkuId()));
        }
        if (null != reqBO.getServType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)reqBO.getServType()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAfterServiceNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"afterServiceNo.keyword", (String)("*" + reqBO.getAfterServiceNo() + "*")));
        }
        if (null != reqBO.getDealResult()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"dealResult", (Object)reqBO.getDealResult()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purNo", reqBO.getPurNoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purName.keyword", (String)("*" + reqBO.getPurName() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purAccount", reqBO.getPurAccountList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccountName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purAccountName.keyword", (String)("*" + reqBO.getPurAccountName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getJdShippingInfoStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"jdShippingInfoStatus", (String)reqBO.getJdShippingInfoStatus()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getProNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"proNo", reqBO.getProNoList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        TermsAggregationBuilder agg = null;
        if (CollectionUtils.isNotEmpty(reqBO.getServStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", reqBO.getServStateList()));
            agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("servState");
        }
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)0);
        queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        if (null != agg) {
            queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
        }
        return queryJson.toJSONString();
    }

    private String getQueryString(UocSearchEsSQLRspBO uocSearchEsSQLRspBO) {
        if (uocSearchEsSQLRspBO.getPageNo() <= 0) {
            uocSearchEsSQLRspBO.setPageNo(1);
        }
        JSONObject queryJson = new JSONObject();
        if (10000 < uocSearchEsSQLRspBO.getPageSize()) {
            queryJson.put("size", (Object)10000);
        } else {
            queryJson.put("size", (Object)uocSearchEsSQLRspBO.getPageSize());
        }
        queryJson.put("from", (Object)(uocSearchEsSQLRspBO.getPageSize() * (uocSearchEsSQLRspBO.getPageNo() - 1)));
        queryJson.put("query", (Object)JSON.parseObject((String)uocSearchEsSQLRspBO.getBoolQueryBuilder().toString()));
        queryJson.put("sort", (Object)JSON.parseArray((String)uocSearchEsSQLRspBO.getSortQuery().toString()));
        return queryJson.toJSONString();
    }

    public String countStateNum(UocEsCountStateNumReqBO uocEsCountStateNumReqBO) {
        Long createTimeEff;
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (uocEsCountStateNumReqBO.getOrderId() != null && uocEsCountStateNumReqBO.getOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)uocEsCountStateNumReqBO.getOrderId()));
        }
        if (uocEsCountStateNumReqBO.getServType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servType", (Object)uocEsCountStateNumReqBO.getServType()));
        }
        if (CollectionUtils.isNotEmpty(uocEsCountStateNumReqBO.getOrgIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNo", uocEsCountStateNumReqBO.getOrgIds()));
        } else if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)uocEsCountStateNumReqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getOrderDesc())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderDesc.keyword", (String)("*" + uocEsCountStateNumReqBO.getOrderDesc() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getAggregationCondition())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"aggregationCondition.keyword", (String)("*" + uocEsCountStateNumReqBO.getAggregationCondition() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"skuName", (Object)uocEsCountStateNumReqBO.getSkuName()));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getTbOrderId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"tbOrderId", (Object)uocEsCountStateNumReqBO.getTbOrderId()));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getConsignee())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"consignee.keyword", (String)("*" + uocEsCountStateNumReqBO.getConsignee() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getConsigneePhone())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"consigneePhone.keyword", (String)("*" + uocEsCountStateNumReqBO.getConsigneePhone() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getOutOrderNo())) {
            BoolQueryBuilder shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"outOrderNo.keyword", (String)("*" + uocEsCountStateNumReqBO.getOutOrderNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"poutOrderNo.keyword", (String)("*" + uocEsCountStateNumReqBO.getOutOrderNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getPayVourcherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"payVourcherNo", (Object)uocEsCountStateNumReqBO.getPayVourcherNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + uocEsCountStateNumReqBO.getCreateOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateOperPhone())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperPhone.keyword", (String)("*" + uocEsCountStateNumReqBO.getCreateOperPhone() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getOrderSource())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderSource", (String)uocEsCountStateNumReqBO.getOrderSource()));
        }
        if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)uocEsCountStateNumReqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            if (StringUtils.isNotBlank((CharSequence)uocEsCountStateNumReqBO.getCreateTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)uocEsCountStateNumReqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (uocEsCountStateNumReqBO.getUpdateTime() != null && uocEsCountStateNumReqBO.getUpdateTime() != 0L) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"updateTime");
            createTimeEff = uocEsCountStateNumReqBO.getUpdateTime();
            rangeQueryBuilder.lte((Object)createTimeEff);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (uocEsCountStateNumReqBO.getNotShipTime() != null) {
            Long createTimeEff2 = uocEsCountStateNumReqBO.getNotShipTime().getTime();
            RangeQueryBuilder rangeQueryBuilder2 = QueryBuilders.rangeQuery((String)"payTime");
            rangeQueryBuilder2.lte((Object)createTimeEff2);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder2);
        }
        TermsAggregationBuilder agg = null;
        if (CollectionUtils.isNotEmpty(uocEsCountStateNumReqBO.getServStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"servState", uocEsCountStateNumReqBO.getServStateList()));
            agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("servState");
        }
        if (CollectionUtils.isNotEmpty(uocEsCountStateNumReqBO.getStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", uocEsCountStateNumReqBO.getStateList()));
            agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("saleState");
        }
        if (uocEsCountStateNumReqBO.getServState() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"servState", (Object)uocEsCountStateNumReqBO.getServState()));
        }
        if (uocEsCountStateNumReqBO.getSaleState() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"saleState", (Object)uocEsCountStateNumReqBO.getSaleState()));
        }
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)0);
        queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        if (null != agg) {
            queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
        }
        return queryJson.toJSONString();
    }

    public String buildQryAbnormalEsSql(UocEsQryAbnormalListReqBO reqBO) {
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder shouldQueryBuilder;
        boolean cxPur = false;
        if (CollectionUtils.isNotEmpty(reqBO.getOrgListThrough()) || CollectionUtils.isNotEmpty(reqBO.getOrgList())) {
            cxPur = true;
        }
        boolean cxPro = false;
        if (CollectionUtils.isNotEmpty(reqBO.getOrgListThroughPro()) || CollectionUtils.isNotEmpty(reqBO.getOrgListPro())) {
            cxPro = true;
        }
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty(reqBO.getTaskOperIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getTaskOperIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"taskOperIdList", (String)taskOperId));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOwnOperId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"ownOperIdList", (String)reqBO.getOwnOperId()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOwnOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ownOperIdList", (String)reqBO.getOwnOperId()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId()) && cxPur) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            BoolQueryBuilder org = this.like(reqBO.getOrgList(), reqBO.getOrgListThrough(), "orgPath");
            shouldQueryBuilder.should((QueryBuilder)org);
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else {
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getPurNoList())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purNo", reqBO.getPurNoList()));
            } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPurNo())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purNo", (String)reqBO.getPurNo()));
            }
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        }
        if (null != reqBO.getTradeMode()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tradeMode", (Object)reqBO.getTradeMode()));
        }
        if (null != reqBO.getAgreementMode()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreementMode", (Object)reqBO.getAgreementMode()));
        }
        if (reqBO.getChangeType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"changeType", (Object)reqBO.getChangeType()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAbnormalVoucherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"abnormalVoucherNo.keyword", (String)("*" + reqBO.getAbnormalVoucherNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutOrderNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"outOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"poutOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccount())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purAccount", (String)reqBO.getPurAccount()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInspectionOper())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"inspectionOper.keyword", (String)("*" + reqBO.getInspectionOper() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAbnormalState())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"saleState", (String)reqBO.getAbnormalState()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShipVoucherCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"shipVoucherCode.keyword", (String)("*" + reqBO.getShipVoucherCode() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShipStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"shipStatus", (String)reqBO.getShipStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                rangeQueryBuilder.gte((Object)DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime());
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                rangeQueryBuilder.lte((Object)DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getAcceptTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"acceptTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptTimeEff())) {
                rangeQueryBuilder.gte((Object)DateUtils.strToDateLong((String)reqBO.getAcceptTimeEff()).getTime());
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptTimeExp())) {
                rangeQueryBuilder.lte((Object)DateUtils.strToDateLong((String)reqBO.getAcceptTimeExp()).getTime());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getChangeFeeEff() || null != reqBO.getChangeFeeExp()) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"changeFee");
            if (null != reqBO.getChangeFeeEff()) {
                rangeQueryBuilder.gte((Object)reqBO.getChangeFeeEff().multiply(new BigDecimal(10000)).longValue());
            }
            if (null != reqBO.getChangeFeeExp()) {
                rangeQueryBuilder.lte((Object)reqBO.getChangeFeeExp().multiply(new BigDecimal(10000)).longValue());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            TermsAggregationBuilder agg = null;
            if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList())) {
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("saleState");
                agg.size(reqBO.getSaleStateList().size());
            }
            JSONObject queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != agg) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
            }
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String countAbnormalTabNumber(UocEsQryAbnormalTabNumberReqBO reqBO) {
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty(reqBO.getTaskOperIdList())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            for (String taskOperId : reqBO.getTaskOperIdList()) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"taskOperIdList", (String)taskOperId));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOwnOperId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"ownOperIdList", (String)reqBO.getOwnOperId()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
                shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
            }
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOwnOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ownOperId", (String)reqBO.getOwnOperId()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getTaskUserId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"taskUserIdList", (String[])new String[]{reqBO.getTaskUserId()}));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        }
        if (reqBO.getChangeType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"changeType", (Object)reqBO.getChangeType()));
        }
        if (reqBO.getAbnormalVoucherNo() != null && 0L != reqBO.getAbnormalVoucherNo()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"abnormalVoucherNo", (Object)reqBO.getAbnormalVoucherNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutOrderNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"outOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"poutOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurAccount())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purAccount", (String)reqBO.getPurAccount()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        TermsAggregationBuilder agg = null;
        if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
            agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("saleState");
        }
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)0);
        queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
        if (null != agg) {
            queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
        }
        return queryJson.toJSONString();
    }

    public String buildQryPurchaseEsSql(UocEsQryPurchaseListReqBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (reqBO.getPurchaseVoucherId() != null && reqBO.getPurchaseVoucherId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaseVoucherId.keyword", (String)("*" + reqBO.getPurchaseVoucherId() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurchaseStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purchaseState", reqBO.getPurchaseStateList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderSource", reqBO.getOrderSourceList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProtocolNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"protocolNo.keyword", (String)("*" + reqBO.getProtocolNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                Long createTimeExp = DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String buildQryInspectionEsSql(UocEsQryInspectionListReqBO reqBO) {
        Long createTimeExp;
        Long createTimeEff;
        RangeQueryBuilder rangeQueryBuilder;
        Object shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolean cxPur = false;
        if (CollectionUtils.isNotEmpty(reqBO.getOrgListThrough()) || CollectionUtils.isNotEmpty(reqBO.getOrgList())) {
            cxPur = true;
        }
        boolean cxPro = false;
        if (CollectionUtils.isNotEmpty(reqBO.getOrgListThroughPro()) || CollectionUtils.isNotEmpty(reqBO.getOrgListPro())) {
            cxPro = true;
        }
        if (reqBO.getExpansionConditionsMap() != null && !reqBO.getExpansionConditionsMap().isEmpty()) {
            for (Map.Entry<String, UocExpansionConditionsMapBO> entry : reqBO.getExpansionConditionsMap().entrySet()) {
                String mapKey = entry.getKey();
                UocExpansionConditionsMapBO mapValue = entry.getValue();
                if (mapValue.getIsExpansionConditions().booleanValue()) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
            }
        }
        if (null != reqBO.getInspectionVoucherId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"objId", (Object)reqBO.getInspectionVoucherId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurchaseVoucherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaseVoucherNo.keyword", (String)("*" + reqBO.getPurchaseVoucherNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInspectionVoucherCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"inspectionVoucherCode.keyword", (String)("*" + reqBO.getInspectionVoucherCode() + "*")));
        }
        if (null != reqBO.getOrderId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)reqBO.getOrderId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderName.keyword", (String)("*" + reqBO.getOrderName() + "*")));
        }
        if (null != reqBO.getSaleVoucherId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"saleVoucherId", (Object)reqBO.getSaleVoucherId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId()) && cxPur) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            BoolQueryBuilder org = this.like(reqBO.getOrgList(), reqBO.getOrgListThrough(), "orgPath");
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            shouldQueryBuilder.should((QueryBuilder)org);
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else {
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getOrgList()) || CollectionUtils.isNotEmpty(reqBO.getOrgListThrough())) {
                BoolQueryBuilder org = this.like(reqBO.getOrgList(), reqBO.getOrgListThrough(), "orgPath");
                boolQueryBuilder.must((QueryBuilder)org);
            } else if (StringUtils.isNotBlank((CharSequence)reqBO.getPurNo())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purNo", (String)reqBO.getPurNo()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId()) && StringUtils.isNotBlank((CharSequence)reqBO.getAcceptorId())) {
                shouldQueryBuilder = QueryBuilders.boolQuery();
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"acceptorId", (String)reqBO.getAcceptorId()));
                boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
            } else if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            }
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInspectionOper())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"inspectionOper.keyword", (String)("*" + reqBO.getInspectionOper() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSuoNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSuoNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"supName.keyword", (String)("*" + reqBO.getSupName() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purAccount", reqBO.getPurAccountList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getInspectionStateQuery())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"inspectionState", reqBO.getInspectionStateQuery()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getInspectionStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"inspectionState", reqBO.getInspectionStateList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getPurNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purNo", reqBO.getPurNoList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getInspectionVoucherIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"objId", reqBO.getInspectionVoucherIdList()));
        }
        if (null != reqBO.getRelType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"relType", (Object)reqBO.getRelType()));
        }
        if (null != reqBO.getRelState()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"relState", (Object)reqBO.getRelState()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getRelId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"relId", (String)reqBO.getRelId()));
        }
        if (null != reqBO.getCheckState()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"checkState", (Object)reqBO.getCheckState()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"outOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getProNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"proNo", (String)reqBO.getProNo()));
        }
        if (null != reqBO.getPayType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payType", (Object)reqBO.getPayType()));
        }
        if (null != reqBO.getPayStatus()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payStatus", (Object)reqBO.getPayStatus()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getInspectionVoucherCodeList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"inspectionVoucherCode.keyword", reqBO.getInspectionVoucherCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getUserType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"userType", (String[])new String[]{reqBO.getUserType()}));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPurPlaceOrderName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purPlaceOrderName.keyword", (String)("*" + reqBO.getPurPlaceOrderName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getReceiverName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"receiverName.keyword", (String)("*" + reqBO.getReceiverName() + "*")));
        }
        if (null != reqBO.getTradeMode()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tradeMode", (Object)reqBO.getTradeMode()));
        }
        if (null != reqBO.getOutInvoiceId() && 0L != reqBO.getOutInvoiceId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"outInvoiceId", (Object)reqBO.getOutInvoiceId()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getRelIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"relId", reqBO.getRelIdList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getRelInfo())) {
            for (String relInfo : reqBO.getRelInfo()) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"relInfo", (String)relInfo));
            }
        }
        if (null != reqBO.getPayRule()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payRule", (Object)reqBO.getPayRule()));
        }
        if (null != reqBO.getPayBreakScale()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payBreakScale", (Object)reqBO.getPayBreakScale()));
        }
        if (null != reqBO.getPayAccountDayRule()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payAccountDayRule", (Object)reqBO.getPayAccountDayRule()));
        }
        if (null != reqBO.getPayNodeRule()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payNodeRule", (Object)reqBO.getPayNodeRule()));
        }
        if (null != reqBO.getPayAccountDay()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payAccountDay", (Object)reqBO.getPayAccountDay()));
        }
        if (null != reqBO.getPaymentDays()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"paymentDays", (Object)reqBO.getPaymentDays()));
        }
        if (null != reqBO.getCompanyIdWeb()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"companyIdWeb", (Object)reqBO.getCompanyIdWeb()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSaleState())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleState()));
        }
        if (null != reqBO.getInspSaleFeeBegin() && 0L != reqBO.getInspSaleFeeBegin() || null != reqBO.getInspSaleFeeEnd() && 0L != reqBO.getInspSaleFeeEnd()) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"inspSaleFee");
            if (null != reqBO.getInspSaleFeeBegin() && 0L != reqBO.getInspSaleFeeBegin()) {
                rangeQueryBuilder.gte((Object)reqBO.getInspSaleFeeBegin());
            }
            if (null != reqBO.getInspSaleFeeEnd() && 0L != reqBO.getInspSaleFeeEnd()) {
                rangeQueryBuilder.lte((Object)reqBO.getInspSaleFeeEnd());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getInspPurchaseFeeBegin() && 0L != reqBO.getInspPurchaseFeeBegin() || null != reqBO.getInspPurchaseFeeEnd() && 0L != reqBO.getInspPurchaseFeeEnd()) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"inspPurchaseFee");
            if (null != reqBO.getInspPurchaseFeeBegin() && 0L != reqBO.getInspPurchaseFeeBegin()) {
                rangeQueryBuilder.gte((Object)reqBO.getInspPurchaseFeeBegin());
            }
            if (null != reqBO.getInspPurchaseFeeEnd() && 0L != reqBO.getInspPurchaseFeeEnd()) {
                rangeQueryBuilder.lte((Object)reqBO.getInspPurchaseFeeEnd());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getOrderCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"orderCreateTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderCreateTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)reqBO.getOrderCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderCreateTimeExp())) {
                createTimeExp = DateUtils.strToDateLong((String)reqBO.getOrderCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInspectionCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getInspectionCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"inspectionTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getInspectionCreateTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)reqBO.getInspectionCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getInspectionCreateTimeExp())) {
                createTimeExp = DateUtils.strToDateLong((String)reqBO.getInspectionCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getIsAfterSales() && reqBO.getIsAfterSales().booleanValue()) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"availableOrderAfterCount");
            rangeQueryBuilder.gt((Object)0);
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSumField())) {
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
            searchSourceBuilder.size(1);
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.from(0);
            JSONObject queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            List<String> sumField = reqBO.getSumField();
            for (String field : sumField) {
                if (!StringUtils.isNotBlank((CharSequence)field)) continue;
                searchSourceBuilder.aggregation((AggregationBuilder)((SumAggregationBuilder)AggregationBuilders.sum((String)field).field(field)).format("0.00"));
            }
            queryJson.put("aggs", (Object)JSON.parseObject((String)searchSourceBuilder.aggregations().toString()));
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = StringUtils.isNotEmpty((CharSequence)reqBO.getOrderBy()) ? ((FieldSortBuilder)SortBuilders.fieldSort((String)reqBO.getOrderBy()).order(order)).unmappedType("date") : ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String buildQryShipEsSql(UocEsQryShipListReqBO reqBO) {
        RangeQueryBuilder rangeQueryBuilder;
        BoolQueryBuilder shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolean cxPur = false;
        if (CollectionUtils.isNotEmpty(reqBO.getOrgListThrough()) || CollectionUtils.isNotEmpty(reqBO.getOrgList())) {
            cxPur = true;
        }
        boolean cxPro = false;
        if (CollectionUtils.isNotEmpty(reqBO.getOrgListThroughPro()) || CollectionUtils.isNotEmpty(reqBO.getOrgListPro())) {
            cxPro = true;
        }
        if (reqBO.getExpansionConditionsMap() != null && !reqBO.getExpansionConditionsMap().isEmpty()) {
            for (Map.Entry<String, UocExpansionConditionsMapBO> entry : reqBO.getExpansionConditionsMap().entrySet()) {
                String mapKey = entry.getKey();
                UocExpansionConditionsMapBO mapValue = entry.getValue();
                if (mapValue.getIsExpansionConditions().booleanValue()) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId()) && cxPur) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            BoolQueryBuilder org = this.like(reqBO.getOrgList(), reqBO.getOrgListThrough(), "orgPath");
            shouldQueryBuilder.should((QueryBuilder)org);
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else {
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperId())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBO.getCreateOperId()));
            }
            if (CollectionUtils.isNotEmpty(reqBO.getOrgList()) || CollectionUtils.isNotEmpty(reqBO.getOrgListThrough())) {
                BoolQueryBuilder org = this.like(reqBO.getOrgList(), reqBO.getOrgListThrough(), "orgPath");
                boolQueryBuilder.must((QueryBuilder)org);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"outOrderNo.keyword", (String)("*" + reqBO.getOutOrderNo() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getSaleStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBO.getSaleStateList()));
        }
        if (null != reqBO.getOrderCategory()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderCategory", (String[])new String[]{reqBO.getOrderCategory() + ""}));
        }
        if (null != reqBO.getIsPartInspect()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"isPartInspect", (String[])new String[]{reqBO.getIsPartInspect() + ""}));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderTypeList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderType", reqBO.getOrderTypeList()));
        } else if (StringUtils.isNotBlank((CharSequence)reqBO.getOrderType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderType", (String)reqBO.getOrderType()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSupNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supNo", (String)reqBO.getSupNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuId", (String)reqBO.getSkuId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getOutSkuId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"outSkuId.keyword", (String)("*" + reqBO.getOutSkuId() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSkuName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"skuName.keyword", (String)("*" + reqBO.getSkuName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBO.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (CollectionUtils.isNotEmpty(reqBO.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBO.getOrderSourceList()));
        }
        if (CollectionUtils.isNotEmpty(reqBO.getShipStatusList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"shipStatus", reqBO.getShipStatusList()));
        }
        if (null != reqBO.getAfterDimension()) {
            if (UocCoreConstant.shipAfterDimension.SHIPPING.equals(reqBO.getAfterDimension())) {
                rangeQueryBuilder = QueryBuilders.rangeQuery((String)"shipCount");
                rangeQueryBuilder.gt((Object)0);
                boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
            } else if (UocCoreConstant.shipAfterDimension.ARRIVED.equals(reqBO.getAfterDimension())) {
                rangeQueryBuilder = QueryBuilders.rangeQuery((String)"arrivedCount");
                rangeQueryBuilder.gt((Object)0);
                boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
            } else if (UocCoreConstant.shipAfterDimension.ACCEPTED.equals(reqBO.getAfterDimension())) {
                rangeQueryBuilder = QueryBuilders.rangeQuery((String)"acceptedCount");
                rangeQueryBuilder.gt((Object)0);
                boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
            }
        }
        if (null != reqBO.getIsAbnormal()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isAbnormal", (Object)reqBO.getIsAbnormal()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getShipVoucherCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"shipVoucherCode.keyword", (String)("*" + reqBO.getShipVoucherCode() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateOperName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"createOperName.keyword", (String)("*" + reqBO.getCreateOperName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getInspectionOper())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"inspectionOperName.keyword", (String)("*" + reqBO.getInspectionOper() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeEff())) {
                rangeQueryBuilder.gte((Object)DateUtils.strToDateLong((String)reqBO.getCreateTimeEff()).getTime());
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getCreateTimeExp())) {
                rangeQueryBuilder.lte((Object)DateUtils.strToDateLong((String)reqBO.getCreateTimeExp()).getTime());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBO.getAcceptTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"acceptTime");
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptTimeEff())) {
                rangeQueryBuilder.gte((Object)DateUtils.strToDateLong((String)reqBO.getAcceptTimeEff()).getTime());
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getAcceptTimeExp())) {
                rangeQueryBuilder.lte((Object)DateUtils.strToDateLong((String)reqBO.getAcceptTimeExp()).getTime());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBO.getShipmentAmountEff() || null != reqBO.getShipmentAmountExp()) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"shipmentAmount");
            if (null != reqBO.getShipmentAmountEff()) {
                rangeQueryBuilder.gte((Object)reqBO.getShipmentAmountEff().multiply(new BigDecimal(10000)).longValue());
            }
            if (null != reqBO.getShipmentAmountExp()) {
                rangeQueryBuilder.lte((Object)reqBO.getShipmentAmountExp().multiply(new BigDecimal(10000)).longValue());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(Collections.singletonList(((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(SortOrder.DESC)).unmappedType("date")));
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    public String buildQryStatisticsEsSql(UocEsQryStatisticsReqBO reqBO) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"statisticsQuantity");
        rangeQueryBuilder.gt((Object)0);
        boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)"statisticsAmount");
        rangeQuery.gt((Object)0);
        boolQueryBuilder.must((QueryBuilder)rangeQuery);
        if (null != reqBO.getStatisticsType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"statisticsType", (Object)reqBO.getStatisticsType()));
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"statisticsAmount").order(order)).unmappedType("long");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    private BoolQueryBuilder like(List<String> orgList, List<String> like, String key) {
        BoolQueryBuilder m;
        BoolQueryBuilder st;
        BoolQueryBuilder org = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty(orgList)) {
            st = QueryBuilders.boolQuery();
            for (String str : orgList) {
                m = QueryBuilders.boolQuery();
                m.must((QueryBuilder)QueryBuilders.wildcardQuery((String)(key + ".keyword"), (String)("*" + str)));
                st.should((QueryBuilder)m);
            }
            org.should((QueryBuilder)st);
        }
        if (CollectionUtils.isNotEmpty(like)) {
            st = QueryBuilders.boolQuery();
            for (String str : like) {
                m = QueryBuilders.boolQuery();
                m.must((QueryBuilder)QueryBuilders.wildcardQuery((String)(key + ".keyword"), (String)("*" + str + "*")));
                st.should((QueryBuilder)m);
            }
            org.should((QueryBuilder)st);
        }
        return org;
    }

    public String buildQryTransactionServiceEsSql(UocEsQryTransactionServiceListReqBo reqBo) {
        Long createTimeExp;
        Long createTimeEff;
        RangeQueryBuilder rangeQueryBuilder;
        Object shouldQueryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolean cxPur = false;
        if (CollectionUtils.isNotEmpty(reqBo.getOrgListThrough()) || CollectionUtils.isNotEmpty(reqBo.getOrgList())) {
            cxPur = true;
        }
        if (reqBo.getExpansionConditionsMap() != null && !reqBo.getExpansionConditionsMap().isEmpty()) {
            for (Map.Entry<String, UocExpansionConditionsMapBO> entry : reqBo.getExpansionConditionsMap().entrySet()) {
                String mapKey = entry.getKey();
                UocExpansionConditionsMapBO mapValue = entry.getValue();
                if (mapValue.getIsExpansionConditions().booleanValue()) {
                    boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
                    continue;
                }
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)mapKey, (Collection)mapValue.getExpansionConditions()));
            }
        }
        if (null != reqBo.getInspectionVoucherId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"objId", (Object)reqBo.getInspectionVoucherId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getPurchaseVoucherNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purchaseVoucherNo.keyword", (String)("*" + reqBo.getPurchaseVoucherNo() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getInspectionVoucherCode())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"inspectionVoucherCode.keyword", (String)("*" + reqBo.getInspectionVoucherCode() + "*")));
        }
        if (null != reqBo.getOrderId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)reqBo.getOrderId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getOrderName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderName.keyword", (String)("*" + reqBo.getOrderName() + "*")));
        }
        if (null != reqBo.getSaleVoucherId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"saleVoucherId", (Object)reqBo.getSaleVoucherId()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getSaleVoucherNo())) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"saleVoucherNo.keyword", (String)("*" + reqBo.getSaleVoucherNo() + "*")));
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"psaleVoucherNo.keyword", (String)("*" + reqBo.getSaleVoucherNo() + "*")));
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getCreateOperId()) && cxPur) {
            shouldQueryBuilder = QueryBuilders.boolQuery();
            BoolQueryBuilder org = this.like(reqBo.getOrgList(), reqBo.getOrgListThrough(), "orgPath");
            shouldQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBo.getCreateOperId()));
            shouldQueryBuilder.should((QueryBuilder)org);
            boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
        } else {
            if (StringUtils.isNotBlank((CharSequence)reqBo.getCreateOperId())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBo.getCreateOperId()));
            }
            if (CollectionUtils.isNotEmpty(reqBo.getOrgList()) || CollectionUtils.isNotEmpty(reqBo.getOrgListThrough())) {
                BoolQueryBuilder org = this.like(reqBo.getOrgList(), reqBo.getOrgListThrough(), "orgPath");
                boolQueryBuilder.must((QueryBuilder)org);
            } else if (StringUtils.isNotBlank((CharSequence)reqBo.getPurNo())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"purNo", (String)reqBo.getPurNo()));
            }
            if (StringUtils.isNotBlank((CharSequence)reqBo.getCreateOperId()) && StringUtils.isNotBlank((CharSequence)reqBo.getAcceptorId())) {
                shouldQueryBuilder = QueryBuilders.boolQuery();
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBo.getCreateOperId()));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"acceptorId", (String)reqBo.getAcceptorId()));
                boolQueryBuilder.must((QueryBuilder)shouldQueryBuilder);
            } else if (StringUtils.isNotBlank((CharSequence)reqBo.getCreateOperId())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"createOperId", (String)reqBo.getCreateOperId()));
            }
        }
        if (CollectionUtils.isNotEmpty(reqBo.getOrderSourceList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderSource", reqBo.getOrderSourceList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getInspectionOper())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"inspectionOper.keyword", (String)("*" + reqBo.getInspectionOper() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getSupName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"supName.keyword", (String)("*" + reqBo.getSupName() + "*")));
        }
        if (CollectionUtils.isNotEmpty(reqBo.getPurAccountList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purAccount", reqBo.getPurAccountList()));
        }
        if (CollectionUtils.isNotEmpty(reqBo.getInspectionStateQuery())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"inspectionState", reqBo.getInspectionStateQuery()));
        }
        if (CollectionUtils.isNotEmpty(reqBo.getInspectionStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"inspectionState", reqBo.getInspectionStateList()));
        }
        if (CollectionUtils.isNotEmpty(reqBo.getPurNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"purNo", reqBo.getPurNoList()));
        }
        if (CollectionUtils.isNotEmpty(reqBo.getInspectionVoucherIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"objId", reqBo.getInspectionVoucherIdList()));
        }
        if (null != reqBo.getRelType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"relType", (Object)reqBo.getRelType()));
        }
        if (null != reqBo.getRelState()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"relState", (Object)reqBo.getRelState()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getRelId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"relId", (String)reqBo.getRelId()));
        }
        if (null != reqBo.getCheckState()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"checkState", (Object)reqBo.getCheckState()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getOutOrderNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"outOrderNo", (String)reqBo.getOutOrderNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getProNo())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"proNo", (String)reqBo.getProNo()));
        }
        if (null != reqBo.getPayType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payType", (Object)reqBo.getPayType()));
        }
        if (null != reqBo.getPayStatus()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"payStatus", (Object)reqBo.getPayStatus()));
        }
        if (CollectionUtils.isNotEmpty(reqBo.getInspectionVoucherCodeList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"inspectionVoucherCode", reqBo.getInspectionVoucherCodeList()));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getPurPlaceOrderName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"purPlaceOrderName.keyword", (String)("*" + reqBo.getPurPlaceOrderName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getReceiverName())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"receiverName.keyword", (String)("*" + reqBo.getReceiverName() + "*")));
        }
        if (null != reqBo.getTradeMode()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tradeMode", (Object)reqBo.getTradeMode()));
        }
        if (null != reqBo.getOutInvoiceId() && 0L != reqBo.getOutInvoiceId()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"outInvoiceId", (Object)reqBo.getOutInvoiceId()));
        }
        if (CollectionUtils.isNotEmpty(reqBo.getRelIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"relId", reqBo.getRelIdList()));
        }
        if (CollectionUtils.isNotEmpty(reqBo.getRelInfo())) {
            for (String relInfo : reqBo.getRelInfo()) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"relInfo.keyword", (String)relInfo));
            }
        }
        if (null != reqBo.getCompanyIdWeb()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"companyIdWeb", (Object)reqBo.getCompanyIdWeb()));
        }
        if (CollectionUtils.isNotEmpty(reqBo.getSaleState())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"saleState", reqBo.getSaleState()));
        }
        if (CollectionUtils.isNotEmpty(reqBo.getSupNoList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNo", reqBo.getSupNoList()));
        }
        if (CollectionUtils.isNotEmpty(reqBo.getSupNoRuleList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supNoRule", reqBo.getSupNoRuleList()));
        }
        if (CollectionUtils.isNotEmpty(reqBo.getOrderIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"orderId", reqBo.getOrderIdList()));
        }
        if (null != reqBo.getInspSaleFeeBegin() && 0L != reqBo.getInspSaleFeeBegin() || null != reqBo.getInspSaleFeeEnd() && 0L != reqBo.getInspSaleFeeEnd()) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"inspSaleFee");
            if (null != reqBo.getInspSaleFeeBegin() && 0L != reqBo.getInspSaleFeeBegin()) {
                rangeQueryBuilder.gte((Object)reqBo.getInspSaleFeeBegin());
            }
            if (null != reqBo.getInspSaleFeeEnd() && 0L != reqBo.getInspSaleFeeEnd()) {
                rangeQueryBuilder.lte((Object)reqBo.getInspSaleFeeEnd());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (null != reqBo.getInspPurchaseFeeBegin() && 0L != reqBo.getInspPurchaseFeeBegin() || null != reqBo.getInspPurchaseFeeEnd() && 0L != reqBo.getInspPurchaseFeeEnd()) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"inspPurchaseFee");
            if (null != reqBo.getInspPurchaseFeeBegin() && 0L != reqBo.getInspPurchaseFeeBegin()) {
                rangeQueryBuilder.gte((Object)reqBo.getInspPurchaseFeeBegin());
            }
            if (null != reqBo.getInspPurchaseFeeEnd() && 0L != reqBo.getInspPurchaseFeeEnd()) {
                rangeQueryBuilder.lte((Object)reqBo.getInspPurchaseFeeEnd());
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getOrderCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBo.getOrderCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"orderCreateTime");
            if (StringUtils.isNotBlank((CharSequence)reqBo.getOrderCreateTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)reqBo.getOrderCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBo.getOrderCreateTimeExp())) {
                createTimeExp = DateUtils.strToDateLong((String)reqBo.getOrderCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getInspectionCreateTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBo.getInspectionCreateTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"inspectionTime");
            if (StringUtils.isNotBlank((CharSequence)reqBo.getInspectionCreateTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)reqBo.getInspectionCreateTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBo.getInspectionCreateTimeExp())) {
                createTimeExp = DateUtils.strToDateLong((String)reqBo.getInspectionCreateTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)reqBo.getObjTimeEff()) || StringUtils.isNotBlank((CharSequence)reqBo.getObjTimeExp())) {
            rangeQueryBuilder = QueryBuilders.rangeQuery((String)"objTime");
            if (StringUtils.isNotBlank((CharSequence)reqBo.getInspectionCreateTimeEff())) {
                createTimeEff = DateUtils.strToDateLong((String)reqBo.getObjTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (StringUtils.isNotBlank((CharSequence)reqBo.getInspectionCreateTimeExp())) {
                createTimeExp = DateUtils.strToDateLong((String)reqBo.getObjTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeExp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        SortOrder order = SortOrder.DESC;
        FieldSortBuilder sortQueryFirst = StringUtils.isNotEmpty((CharSequence)reqBo.getOrderBy()) ? ((FieldSortBuilder)SortBuilders.fieldSort((String)reqBo.getOrderBy()).order(order)).unmappedType("date") : ((FieldSortBuilder)SortBuilders.fieldSort((String)"objTime").order(order)).unmappedType("date");
        fieldSortBuilders.add(sortQueryFirst);
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        if (null != reqBo.getIsQuerySupplierId() && reqBo.getIsQuerySupplierId().booleanValue()) {
            uocSearchEsSQLRspBO.setPageNo(1);
            uocSearchEsSQLRspBO.setPageSize(reqBo.getPageSize() * reqBo.getPageNo() * 4);
        } else {
            uocSearchEsSQLRspBO.setPageNo(reqBo.getPageNo());
            uocSearchEsSQLRspBO.setPageSize(reqBo.getPageSize());
        }
        return this.getQueryString(uocSearchEsSQLRspBO);
    }
}

