/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.uoc.common.busi.api.PebExtEsPlanListQueryBusiService;
import com.tydic.uoc.common.busi.bo.PebExtEsPlanListQueryDataBo;
import com.tydic.uoc.common.busi.bo.PebExtEsPlanListQueryReqBO;
import com.tydic.uoc.common.busi.bo.PebExtEsPlanListQueryRspBO;
import com.tydic.uoc.common.busi.bo.UocSearchEsSQLRspBO;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.PebEsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="pebExtEsPlanListQueryBusiService")
public class PebExtEsPlanListQueryBusiServiceImpl
implements PebExtEsPlanListQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(PebExtEsPlanListQueryBusiServiceImpl.class);
    private static Integer maxPageSize;
    private PebEsConfig pebEsConfig;
    private UocElasticsearchUtil uocElasticsearchUtil;

    public PebExtEsPlanListQueryBusiServiceImpl(PebEsConfig pebEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.pebEsConfig = pebEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
    }

    @Value(value="${es.max.page.size:10000}")
    public void setMaxPageSize(Integer maxPageSize) {
        PebExtEsPlanListQueryBusiServiceImpl.maxPageSize = maxPageSize;
    }

    @Override
    public PebExtEsPlanListQueryRspBO qryEsPlanInfo(PebExtEsPlanListQueryReqBO reqBO) {
        PebExtEsPlanListQueryRspBO retBo = new PebExtEsPlanListQueryRspBO();
        String queryString = this.buildQryPlanEsSql(reqBO);
        log.debug("ES\u67e5\u8be2\u8bed\u53e5\u4e3a\uff1a" + queryString);
        String endPoint = "/" + this.pebEsConfig.getPlanIndexName() + "/_search";
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Request request = new Request("POST", endPoint);
            request.setJsonEntity(queryString);
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            System.out.println("ES\u67e5\u8be2\u8ba1\u5212\u4fe1\u606fresult---->" + result);
            if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
                this.resovelRetrunCounts(result, retBo);
            } else {
                this.resovelRetrunData(result, retBo, reqBO.getPageSize(), reqBO.getPageNo());
            }
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            retBo.setRespCode("102024");
            retBo.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
        }
        return retBo;
    }

    private void resovelRetrunData(String result, PebExtEsPlanListQueryRspBO retBo, Integer pageSize, Integer pageNo) {
        retBo.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getJSONObject("total").getInteger("value");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            retBo.setPageNo(1);
            retBo.setTotal(0);
            retBo.setRecordsTotal(total);
            retBo.setRows(new ArrayList());
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f!");
            return;
        }
        ArrayList<PebExtEsPlanListQueryDataBo> rows = new ArrayList<PebExtEsPlanListQueryDataBo>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            PebExtEsPlanListQueryDataBo planDataBO = (PebExtEsPlanListQueryDataBo)JSON.toJavaObject((JSON)objJson, PebExtEsPlanListQueryDataBo.class);
            rows.add(planDataBO);
        }
        int totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        retBo.setTotal(totalPageNo);
        retBo.setRecordsTotal(total);
        retBo.setPageNo(pageNo);
        retBo.setRespDesc("\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        retBo.setRows(rows);
    }

    private void resovelRetrunCounts(String result, PebExtEsPlanListQueryRspBO retBo) {
        retBo.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject aggregationsObj = (JSONObject)resultObj.get((Object)"aggregations");
        JSONObject allInterestsObj = (JSONObject)aggregationsObj.get((Object)"all_interests");
        JSONArray bucketsArray = allInterestsObj.getJSONArray("buckets");
        HashMap<Integer, Integer> tabCountsMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < bucketsArray.size(); ++i) {
            JSONObject bucketsObj = bucketsArray.getJSONObject(i);
            tabCountsMap.put(bucketsObj.getInteger("key"), bucketsObj.getInteger("doc_count"));
        }
        retBo.setTabCountsMap(tabCountsMap);
    }

    private String buildQryPlanEsSql(PebExtEsPlanListQueryReqBO reqBO) {
        FieldSortBuilder sortQueryFirst;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (!CollectionUtils.isEmpty(reqBO.getStateList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"status", reqBO.getStateList()));
        } else if (null != reqBO.getStatus()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"status", (Object)reqBO.getStatus()));
        }
        if (reqBO.getOrderId() != null && reqBO.getOrderId() != 0L) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId", (Object)reqBO.getOrderId()));
        }
        if (!StringUtils.isEmpty((Object)reqBO.getZxlsjhbh())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"zxlsjhbh.keyword", (String)("*" + reqBO.getZxlsjhbh() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBO.getJhmc())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"jhmc.keyword", (String)("*" + reqBO.getJhmc() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBO.getJhtbr())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"jhtbr.keyword", (String)("*" + reqBO.getJhtbr() + "*")));
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCgzxrbh())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"cgzxrbh.keyword", (String)("*" + reqBO.getCgzxrbh() + "*")));
        }
        if (!CollectionUtils.isEmpty(reqBO.getCgzxjgbh())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"cgzxjgbh", reqBO.getCgzxjgbh()));
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCglx())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"cglx", (Object)reqBO.getCglx()));
        }
        if (!StringUtils.isEmpty((Object)reqBO.getWxfl())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"wxfl.keyword", (String)reqBO.getWxfl()));
        }
        if (!StringUtils.isEmpty((Object)reqBO.getSubmitTimeEff()) || !StringUtils.isEmpty((Object)reqBO.getSubmitTimeExp())) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"cjsj");
            if (!StringUtils.isEmpty((Object)reqBO.getSubmitTimeEff())) {
                Long createTimeEff = DateUtils.strToDateLong((String)reqBO.getSubmitTimeEff()).getTime();
                rangeQueryBuilder.gte((Object)createTimeEff);
            }
            if (!StringUtils.isEmpty((Object)reqBO.getSubmitTimeExp())) {
                Long createTimeEcp = DateUtils.strToDateLong((String)reqBO.getSubmitTimeExp()).getTime();
                rangeQueryBuilder.lte((Object)createTimeEcp);
            }
            boolQueryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        SortOrder order = SortOrder.DESC;
        if (null != reqBO.getIsQueryTab() && reqBO.getIsQueryTab().booleanValue()) {
            TermsAggregationBuilder agg = null;
            if (!CollectionUtils.isEmpty(reqBO.getStateList())) {
                agg = (TermsAggregationBuilder)AggregationBuilders.terms((String)"all_interests").field("status");
            }
            JSONObject queryJson = new JSONObject();
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != agg) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
            }
            queryJson.put("size", (Object)0);
            queryJson.put("query", (Object)JSON.parseObject((String)boolQueryBuilder.toString()));
            if (null != agg) {
                queryJson.put("aggs", (Object)JSON.parseObject((String)agg.toString()));
            }
            return queryJson.toJSONString();
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (reqBO.getOrderBy() != null) {
            order = SortOrder.ASC;
            sortQueryFirst = (FieldSortBuilder)SortBuilders.fieldSort((String)reqBO.getOrderBy()).order(order);
        } else {
            sortQueryFirst = ((FieldSortBuilder)SortBuilders.fieldSort((String)"createTime").order(order)).unmappedType("date");
        }
        UocSearchEsSQLRspBO uocSearchEsSQLRspBO = new UocSearchEsSQLRspBO();
        fieldSortBuilders.add(sortQueryFirst);
        uocSearchEsSQLRspBO.setSortQuery(fieldSortBuilders);
        uocSearchEsSQLRspBO.setBoolQueryBuilder(boolQueryBuilder);
        uocSearchEsSQLRspBO.setPageNo(reqBO.getPageNo());
        uocSearchEsSQLRspBO.setPageSize(reqBO.getPageSize());
        return this.getQueryString(uocSearchEsSQLRspBO);
    }

    private String getQueryString(UocSearchEsSQLRspBO uocSearchEsSQLRspBO) {
        if (uocSearchEsSQLRspBO.getPageNo() <= 0) {
            uocSearchEsSQLRspBO.setPageNo(1);
        }
        JSONObject queryJson = new JSONObject();
        if (maxPageSize < uocSearchEsSQLRspBO.getPageSize()) {
            queryJson.put("size", (Object)maxPageSize);
        } else {
            queryJson.put("size", (Object)uocSearchEsSQLRspBO.getPageSize());
        }
        queryJson.put("from", (Object)(uocSearchEsSQLRspBO.getPageSize() * (uocSearchEsSQLRspBO.getPageNo() - 1)));
        String queryString = uocSearchEsSQLRspBO.getBoolQueryBuilder().toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        String sortString = uocSearchEsSQLRspBO.getSortQuery().toString();
        queryJson.put("sort", (Object)JSON.parseArray((String)sortString));
        return queryJson.toJSONString();
    }
}

