/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.common.busi.api.PebExtSyncPlanListBusiService;
import com.tydic.uoc.common.busi.bo.PebExtSyncPlanListReqBO;
import com.tydic.uoc.common.busi.bo.PebExtSyncPlanListRspBO;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.PebEsConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pebExtSyncPlanListBusiService")
public class PebExtSyncPlanListBusiServiceImpl
implements PebExtSyncPlanListBusiService {
    private static final long serialVersionUID = -3632783679445934445L;
    private PebEsConfig pebEsConfig;
    private UocElasticsearchUtil uocElasticsearchUtil;

    @Autowired
    public PebExtSyncPlanListBusiServiceImpl(PebEsConfig pebEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.pebEsConfig = pebEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
    }

    @Override
    public PebExtSyncPlanListRspBO esSyncPlanList(PebExtSyncPlanListReqBO reqBO) {
        PebExtSyncPlanListRspBO retBo = new PebExtSyncPlanListRspBO();
        retBo.setRespCode("0000");
        retBo.setRespDesc(" \u540c\u6b65\u8ba1\u5212\u4fe1\u606f\u5217\u8868\u6210\u529f!");
        if (null != reqBO.getObjType() && 2 == reqBO.getObjType() && StringUtils.isBlank((CharSequence)reqBO.getObjJson())) {
            String endPoint = "/" + this.pebEsConfig.getPlanIndexName() + "/" + this.pebEsConfig.getPlanIndexType() + "/_delete_by_query";
            JSONObject deleteConditionJson = new JSONObject();
            deleteConditionJson.put("planId", (Object)reqBO.getObjId());
            JSONObject termJson = new JSONObject();
            termJson.put("term", (Object)deleteConditionJson);
            JSONObject qryJson = new JSONObject();
            qryJson.put("query", (Object)termJson);
            Boolean aBoolean = this.uocElasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
            if (!aBoolean.booleanValue()) {
                retBo.setRespCode("100001");
                retBo.setRespDesc("\u5220\u9664\u5931\u8d25");
            }
            return retBo;
        }
        Boolean addResult = this.addPlanList(reqBO);
        if (!addResult.booleanValue()) {
            retBo.setRespCode("102040");
            retBo.setRespDesc(" \u540c\u6b65\u8ba1\u5212\u4fe1\u606f\u5217\u8868\u6570\u636e\u5931\u8d25!");
        }
        return retBo;
    }

    private Boolean addPlanList(PebExtSyncPlanListReqBO reqBO) {
        boolean addResult = false;
        String jsonStr = JSONObject.toJSONString((Object)reqBO);
        JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
        String id = this.uocElasticsearchUtil.addData(this.pebEsConfig.getPlanIndexName(), this.pebEsConfig.getPlanIndexType(), String.valueOf(reqBO.getOrderId() + reqBO.getObjId()), jsonObject);
        if (!StringUtils.isEmpty((CharSequence)id)) {
            addResult = true;
        }
        return addResult;
    }
}

