/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.uoc.base.bo.UocProRspListBo;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.DicDictionaryBO;
import com.tydic.uoc.common.atom.api.DicDictionaryService;
import com.tydic.uoc.common.atom.bo.DicValAndpCodeBO;
import com.tydic.uoc.common.atom.bo.SelectDicValBypCodesReqBO;
import com.tydic.uoc.common.atom.bo.SelectDicValBypCodesRspBO;
import com.tydic.uoc.common.busi.api.SelectDicValBypCodesBusiService;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="selectDicValBypCodesBusiService")
public class SelectDicValBypCodesBusiServiceImpl
implements SelectDicValBypCodesBusiService {
    private static final Logger log = LoggerFactory.getLogger(SelectDicValBypCodesBusiServiceImpl.class);
    @Autowired
    private DicDictionaryService pecDicDictionaryService;
    @Autowired
    private CacheClient cacheService;

    @Override
    public SelectDicValBypCodesRspBO selectDicValBypCodes(SelectDicValBypCodesReqBO selectDicValBypCodesReqBO) {
        if (selectDicValBypCodesReqBO == null) {
            throw new UocProBusinessException("100002", "\u5165\u53c2\u3010selectDicValBypCodesReqBO\u3011\u5fc5\u586b");
        }
        if (selectDicValBypCodesReqBO.getPCodes() == null || selectDicValBypCodesReqBO.getPCodes().isEmpty()) {
            throw new UocProBusinessException("100002", "\u5165\u53c2\u3010pCodes\u3011\u5fc5\u586b");
        }
        SelectDicValBypCodesRspBO dicValBypCodesRspBO = new SelectDicValBypCodesRspBO();
        try {
            HashMap<String, DicValAndpCodeBO> dicValAndpCodeBOMap = new HashMap<String, DicValAndpCodeBO>();
            LinkedList<Map<String, DicValAndpCodeBO>> maps = new LinkedList<Map<String, DicValAndpCodeBO>>();
            for (String pCode : selectDicValBypCodesReqBO.getPCodes()) {
                if (StringUtils.isBlank((CharSequence)pCode)) continue;
                Object object = this.cacheService.get(pCode);
                log.debug("\u7f13\u5b58\u4e2d\u7684\u503c====" + JSON.toJSONString((Object)object));
                if (object == null) {
                    this.getDicDictionariesFromDB(pCode, dicValAndpCodeBOMap);
                    continue;
                }
                UocProRspListBo redisRsp = (UocProRspListBo)object;
                List redisBackList = redisRsp.getList();
                log.debug("\u7f13\u5b58\u4e2d\u6709\u503c\uff0c\u76f4\u63a5\u8fd4\u56de");
                if (redisBackList != null && redisBackList.size() > 0) {
                    DicValAndpCodeBO dicValAndpCodeBO = new DicValAndpCodeBO();
                    dicValAndpCodeBO.setPCode(pCode);
                    dicValAndpCodeBO.setDicDictionaries(redisBackList);
                    dicValAndpCodeBOMap.put(pCode, dicValAndpCodeBO);
                    continue;
                }
                this.getDicDictionariesFromDB(pCode, dicValAndpCodeBOMap);
            }
            maps.add(dicValAndpCodeBOMap);
            dicValBypCodesRspBO.setDicValAndpCodeBOs(maps);
            dicValBypCodesRspBO.setRespCode("0000");
            dicValBypCodesRspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            dicValBypCodesRspBO.setRespCode("102031");
            dicValBypCodesRspBO.setRespDesc("\u67e5\u8be2\u5931\u8d25");
            throw new UocProBusinessException("102031", "\u67e5\u8be2\u5931\u8d25");
        }
        return dicValBypCodesRspBO;
    }

    private void getDicDictionariesFromDB(String pCode, Map<String, DicValAndpCodeBO> dicValAndpCodeBOMap) {
        log.debug("\u7f13\u5b58\u4e2d\u6ca1\u6709\u503c\uff0c\u6570\u636e\u5e93\u83b7\u53d6\u4fe1\u606f\uff0c\u5e76\u5b58\u5165redis");
        UocProRspListBo<DicDictionaryBO> dicDictionaries = this.pecDicDictionaryService.selectDictValByCode(pCode);
        this.cacheService.set(pCode, dicDictionaries, 7200);
        if (dicDictionaries != null && !dicDictionaries.getList().isEmpty()) {
            DicValAndpCodeBO dicValAndpCodeBO = new DicValAndpCodeBO();
            dicValAndpCodeBO.setPCode(pCode);
            dicValAndpCodeBO.setDicDictionaries(dicDictionaries.getList());
            dicValAndpCodeBOMap.put(pCode, dicValAndpCodeBO);
        }
    }
}

