/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.atom.api.UocPebCommCreateIntfLogAtomService;
import com.tydic.uoc.common.busi.api.UocCallPlanCenterBusiService;
import com.tydic.uoc.common.busi.bo.UocCallPlanCenterBusiServiceItemBo;
import com.tydic.uoc.common.busi.bo.UocCallPlanCenterBusiServiceReqBo;
import com.tydic.uoc.common.busi.bo.UocCallPlanCenterBusiServiceRspBo;
import com.tydic.uoc.dao.OrdItemMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.po.OrdItemPO;
import com.tydic.uoc.po.OrdSalePO;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocCallPlanCenterBusiServiceImpl
implements UocCallPlanCenterBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocCallPlanCenterBusiServiceImpl.class);
    @Autowired
    private UocPebCommCreateIntfLogAtomService uocPebCommCreateIntfLogAtomService;
    @Autowired
    private OrdItemMapper ordItemMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;

    @Override
    public UocCallPlanCenterBusiServiceRspBo updatePlanData(UocCallPlanCenterBusiServiceReqBo reqBo) {
        Long orderId = reqBo.getOrderId();
        Boolean reverse = reqBo.getDirection();
        this.validateArg(reqBo);
        OrdSalePO qryOrdSale = new OrdSalePO();
        qryOrdSale.setOrderId(orderId);
        OrdSalePO ordSalePo = this.ordSaleMapper.getModelBy(qryOrdSale);
        if (ordSalePo == null) {
            throw new UocProBusinessException("100001", "\u8be5\u8ba2\u5355(" + orderId + ")\u4e0d\u5b58\u5728");
        }
        List qryItem = null;
        Map<Object, Object> countMap = new HashMap();
        if (!ObjectUtil.isEmpty(reqBo.getOrderItems())) {
            qryItem = reqBo.getOrderItems().stream().map(UocCallPlanCenterBusiServiceItemBo::getOrderItemId).collect(Collectors.toList());
            countMap = reqBo.getOrderItems().stream().collect(Collectors.toMap(UocCallPlanCenterBusiServiceItemBo::getOrderItemId, UocCallPlanCenterBusiServiceItemBo::getCount));
        }
        String saleVoucherNo = ordSalePo.getSaleVoucherNo();
        OrdItemPO qryOrdItemPo = new OrdItemPO();
        qryOrdItemPo.setOrderId(orderId);
        if (!ObjectUtil.isEmpty(qryItem)) {
            qryOrdItemPo.setOrdItemIdList(qryItem);
        }
        List itemList = this.ordItemMapper.getList(qryOrdItemPo);
        return new UocCallPlanCenterBusiServiceRspBo();
    }

    private void validateArg(UocCallPlanCenterBusiServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new UocProBusinessException("100001", "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getDirection() == null) {
            throw new UocProBusinessException("100001", "direction\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<UocCallPlanCenterBusiServiceItemBo> orderItems = reqBo.getOrderItems();
        if (!ObjectUtil.isEmpty(orderItems)) {
            for (UocCallPlanCenterBusiServiceItemBo orderItem : orderItems) {
                if (orderItem == null) {
                    throw new UocProBusinessException("100001", "orderItems\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (orderItem.getOrderItemId() == null || orderItem.getOrderItemId() == 0L) {
                    throw new UocProBusinessException("100001", "orderItems\u4e2d\u5bf9\u8c61\u5c5e\u6027orderItemId\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (orderItem.getCount() != null && !orderItem.getCount().equals(BigDecimal.ZERO)) continue;
                throw new UocProBusinessException("100001", "orderItems\u4e2d\u5bf9\u8c61\u5c5e\u6027count\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

