/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.tydic.uoc.base.constants.PecConstant;
import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.common.ability.bo.UocPebUpdatePayStatusReqBO;
import com.tydic.uoc.common.ability.bo.UocPebUpdatePayStatusRspBO;
import com.tydic.uoc.common.atom.api.UocRunProcessAtomService;
import com.tydic.uoc.common.atom.bo.UocProcessRunReqBO;
import com.tydic.uoc.common.atom.bo.UocProcessRunRspBO;
import com.tydic.uoc.common.busi.api.UocPebUpdatePayStatusBusiService;
import com.tydic.uoc.dao.OrdPayMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdPayPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrderPO;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UocPebUpdatePayStatusBusiServiceImpl
implements UocPebUpdatePayStatusBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocPebUpdatePayStatusBusiServiceImpl.class);
    private final OrdPayMapper ordPayMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private UocRunProcessAtomService uocRunProcessAtomService;
    @Autowired
    private OrderMapper orderMapper;

    @Autowired
    public UocPebUpdatePayStatusBusiServiceImpl(OrdPayMapper ordPayMapper) {
        this.ordPayMapper = ordPayMapper;
    }

    @Override
    public UocPebUpdatePayStatusRspBO updatePayStatus(UocPebUpdatePayStatusReqBO reqBO) {
        UocPebUpdatePayStatusRspBO rspBO = new UocPebUpdatePayStatusRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u66f4\u65b0\u652f\u4ed8\u5355\u72b6\u6001\u4fe1\u606f\u6210\u529f");
        OrdPayPO ordPayPO = new OrdPayPO();
        ordPayPO.setOrderId(Long.valueOf(reqBO.getOrderId()));
        ordPayPO.setPayVoucherId(reqBO.getPayVoucherId());
        ordPayPO.setPayState(PecConstant.PAY_STAT_SUCCESS);
        this.ordPayMapper.updateById(ordPayPO);
        if (StringUtils.isNotBlank((CharSequence)reqBO.getPayMod())) {
            OrderPO oldOrd = this.orderMapper.getModelById(Long.parseLong(reqBO.getOrderId()));
            OrderPO update = new OrderPO();
            update.setOrderId(Long.valueOf(reqBO.getOrderId()));
            String ordPayMod = oldOrd.getPayMod();
            if (StringUtils.isBlank((CharSequence)ordPayMod)) {
                update.setPayMod(reqBO.getPayMod());
                this.orderMapper.updateById(update);
            } else if (!ordPayMod.contains(reqBO.getPayMod())) {
                update.setPayMod(ordPayMod + "," + reqBO.getPayMod());
                this.orderMapper.updateById(update);
            }
        }
        if (PecConstant.OrderType.RY.equals(reqBO.getOrderType())) {
            OrdSalePO salePO = new OrdSalePO();
            salePO.setOrderId(ordPayPO.getOrderId());
            salePO = this.ordSaleMapper.getModelBy(salePO);
            if (!salePO.getSaleState().equals(UocConstant.SALE_ORDER_STATUS.PAYING)) {
                return rspBO;
            }
            UocProcessRunReqBO processRunReqBO = new UocProcessRunReqBO();
            processRunReqBO.setSysCode("UOC");
            processRunReqBO.setObjId(salePO.getSaleVoucherId());
            processRunReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
            processRunReqBO.setOrderId(salePO.getOrderId());
            processRunReqBO.setOperId("1");
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            processRunReqBO.setVariables(map);
            UocProcessRunRspBO uocProcessRunRspBO = this.uocRunProcessAtomService.start(processRunReqBO);
            if (!"0000".equals(uocProcessRunRspBO.getRespCode())) {
                throw new UocProBusinessException("102096", "\u72b6\u6001\u673a\u5904\u7406\u5931\u8d25" + uocProcessRunRspBO.getRespDesc());
            }
        }
        return rspBO;
    }
}

