/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.ability.impl;

import com.tydic.uoc.common.ability.api.PebExtQryShipmentQuantityService;
import com.tydic.uoc.common.ability.bo.PebExtRecipientReceivingInfoBO;
import com.tydic.uoc.common.ability.bo.PebExtRecipientReceivingQuantityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtRecipientReceivingQuantityRspBO;
import com.tydic.uoc.common.ability.bo.PebExtShipmentQuantityReqBO;
import com.tydic.uoc.common.ability.bo.PebExtShipmentQuantityRspBO;
import com.tydic.uoc.dao.OrdShipItemMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.po.OrdStakeholderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UOC_GROUP_DEV/2.0.0/com.tydic.uoc.common.ability.api.PebExtQryShipmentQuantityService"})
public class PebExtQryShipmentQuantityServiceImpl
implements PebExtQryShipmentQuantityService {
    private static final Logger log = LoggerFactory.getLogger(PebExtQryShipmentQuantityServiceImpl.class);
    @Autowired
    private OrdShipItemMapper ordShipItemMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    static final BigDecimal ZEROQUANTITY = new BigDecimal(0);

    @PostMapping(value={"qryShipmentQuantity"})
    public PebExtShipmentQuantityRspBO qryShipmentQuantity(@RequestBody PebExtShipmentQuantityReqBO reqBO) {
        PebExtShipmentQuantityRspBO rspBO = new PebExtShipmentQuantityRspBO();
        if (StringUtils.isEmpty((Object)this.ordShipItemMapper.getDeliveryQuantity())) {
            rspBO.setDonatedCount(ZEROQUANTITY);
        }
        rspBO.setDonatedCount(this.ordShipItemMapper.getDeliveryQuantity());
        if (StringUtils.isEmpty((Object)this.ordShipItemMapper.getArrivalQuantity())) {
            rspBO.setDonatedCount(ZEROQUANTITY);
        }
        rspBO.setCollectSuccessfullyCount(this.ordShipItemMapper.getArrivalQuantity());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qryRecipientReceivingQuantity"})
    public PebExtRecipientReceivingQuantityRspBO qryRecipientReceivingQuantity(@RequestBody PebExtRecipientReceivingQuantityReqBO reqBO) {
        PebExtRecipientReceivingQuantityRspBO rspBO = new PebExtRecipientReceivingQuantityRspBO();
        ArrayList<PebExtRecipientReceivingInfoBO> recipientReceivingList = new ArrayList<PebExtRecipientReceivingInfoBO>();
        OrdStakeholderPO qryPurNoListReqPO = new OrdStakeholderPO();
        List OrdStakeholderPOList = this.ordStakeholderMapper.getPurNoList(qryPurNoListReqPO);
        log.info("\u53d7\u8d60\u65b9\u7f16\u7801\u5217\u8868\uff1a{}", (Object)OrdStakeholderPOList);
        if (!CollectionUtils.isEmpty((Collection)OrdStakeholderPOList)) {
            for (OrdStakeholderPO ordStakeholderPO : OrdStakeholderPOList) {
                PebExtRecipientReceivingInfoBO pebExtRecipientReceivingInfoBO = new PebExtRecipientReceivingInfoBO();
                List orderIdList = this.ordStakeholderMapper.getOrderIdList(ordStakeholderPO.getPurNo());
                BigDecimal purCollectSuccessfullyCount = new BigDecimal(0);
                if (!CollectionUtils.isEmpty((Collection)orderIdList)) {
                    purCollectSuccessfullyCount = this.ordShipItemMapper.getArrivalQuantityByOrderId(orderIdList);
                }
                pebExtRecipientReceivingInfoBO.setPurNo(ordStakeholderPO.getPurNo());
                pebExtRecipientReceivingInfoBO.setPurName(ordStakeholderPO.getPurName());
                pebExtRecipientReceivingInfoBO.setPurCollectSuccessfullyCount(purCollectSuccessfullyCount);
                recipientReceivingList.add(pebExtRecipientReceivingInfoBO);
            }
        }
        rspBO.setRecipientReceivingList(recipientReceivingList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

