/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.atom.impl;

import com.tydic.uoc.base.constants.UocConstant;
import com.tydic.uoc.base.constants.UocCoreConstant;
import com.tydic.uoc.base.exception.UocProBusinessException;
import com.tydic.uoc.base.utils.UocMoneyUtil;
import com.tydic.uoc.common.ability.bo.OrdAccessoryRspBO;
import com.tydic.uoc.common.ability.bo.OrdAgreementRspBO;
import com.tydic.uoc.common.ability.bo.OrdInvoiceRspBO;
import com.tydic.uoc.common.ability.bo.OrdLogisticsRelaRspBO;
import com.tydic.uoc.common.ability.bo.OrdPayConfRspBO;
import com.tydic.uoc.common.ability.bo.OrdStakeholderRspBO;
import com.tydic.uoc.common.ability.bo.OrderRspBO;
import com.tydic.uoc.common.ability.bo.UocOrdCancelBO;
import com.tydic.uoc.common.ability.bo.UocPayOrderDetailQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocPayOrderDetailQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocPayOrderDetailRspBO;
import com.tydic.uoc.common.atom.api.UocCoreMainOrderDetailQueryAtomService;
import com.tydic.uoc.common.atom.bo.UocCoreMainOrderDetailQueryReqBO;
import com.tydic.uoc.common.atom.bo.UocCoreMainOrderDetailQueryRspBO;
import com.tydic.uoc.common.busi.api.UocPayOrderDetailQueryBusiService;
import com.tydic.uoc.dao.OrdAccessoryMapper;
import com.tydic.uoc.dao.OrdAgreementMapper;
import com.tydic.uoc.dao.OrdCancelMapper;
import com.tydic.uoc.dao.OrdCruxMapMapper;
import com.tydic.uoc.dao.OrdExtMapMapper;
import com.tydic.uoc.dao.OrdInvoiceMapper;
import com.tydic.uoc.dao.OrdLogisticsRelaMapper;
import com.tydic.uoc.dao.OrdPayConfMapper;
import com.tydic.uoc.dao.OrdSaleMapper;
import com.tydic.uoc.dao.OrdStakeholderMapper;
import com.tydic.uoc.dao.OrderMapper;
import com.tydic.uoc.po.OrdAccessoryPO;
import com.tydic.uoc.po.OrdAgreementPO;
import com.tydic.uoc.po.OrdCancelPO;
import com.tydic.uoc.po.OrdCruxMapPO;
import com.tydic.uoc.po.OrdExtMapPO;
import com.tydic.uoc.po.OrdInvoicePO;
import com.tydic.uoc.po.OrdLogisticsRelaPO;
import com.tydic.uoc.po.OrdPayConfPO;
import com.tydic.uoc.po.OrdSalePO;
import com.tydic.uoc.po.OrdStakeholderPO;
import com.tydic.uoc.po.OrderPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="uocCoreMainOrderDetailQueryAtomService")
public class UocCoreMainOrderDetailQueryAtomServiceImpl
implements UocCoreMainOrderDetailQueryAtomService {
    @Autowired
    OrdCruxMapMapper ordCruxMapMapper;
    @Autowired
    private OrderMapper orderMapper;
    @Autowired
    private OrdStakeholderMapper ordStakeholderMapper;
    @Autowired
    private OrdLogisticsRelaMapper ordLogisticsRelaMapper;
    @Autowired
    private OrdAgreementMapper ordAgreementMapper;
    @Autowired
    private OrdInvoiceMapper ordInvoiceMapper;
    @Autowired
    private OrdPayConfMapper ordPayConfMapper;
    @Autowired
    private OrdExtMapMapper ordExtMapMapper;
    @Autowired
    private OrdAccessoryMapper ordAccessoryMapper;
    @Autowired
    private OrdSaleMapper ordSaleMapper;
    @Autowired
    private OrdCancelMapper ordCancelMapper;
    @Autowired
    private UocPayOrderDetailQueryBusiService uocPayOrderDetailQueryBusiService;

    @Override
    public UocCoreMainOrderDetailQueryRspBO getMainOrderDetail(UocCoreMainOrderDetailQueryReqBO reqBO) {
        UocCoreMainOrderDetailQueryRspBO rspBO = new UocCoreMainOrderDetailQueryRspBO();
        this.validateParams(reqBO);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(reqBO.getQueryLevelList())) {
            for (Integer queryLevel : reqBO.getQueryLevelList()) {
                if (UocCoreConstant.MAIN_ORDER_QUERY_LEVEL.QUERY_ORDER.equals(queryLevel)) {
                    OrderRspBO orderRspBO = this.buildOrderRspBO(reqBO);
                    if (null == orderRspBO) {
                        rspBO.setRespCode("100001");
                        rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u4fe1\u606f:" + reqBO.getOrderId());
                        return rspBO;
                    }
                    rspBO.setOrderRspBO(orderRspBO);
                }
                if (UocCoreConstant.MAIN_ORDER_QUERY_LEVEL.QUERY_STAKE_HOLDER.equals(queryLevel)) {
                    rspBO.setOrdStakeholderRspBO(this.buildOrdStakeholderRspBO(reqBO));
                }
                if (UocCoreConstant.MAIN_ORDER_QUERY_LEVEL.QUERY_LOGISTICS_RELA.equals(queryLevel)) {
                    rspBO.setOrdLogisticsRelaRspBOList(this.buildOrdLogisticsRelaRspBO(reqBO));
                }
                if (UocCoreConstant.MAIN_ORDER_QUERY_LEVEL.QUERY_INVOICE.equals(queryLevel)) {
                    rspBO.setOrdInvoiceRspBO(this.buildOrdInvoiceRspBO(reqBO));
                }
                if (UocCoreConstant.MAIN_ORDER_QUERY_LEVEL.QUERY_AGREEMENT.equals(queryLevel)) {
                    rspBO.setOrdAgreementRspBO(this.buildOrdAgreementRspBO(reqBO));
                }
                if (UocCoreConstant.MAIN_ORDER_QUERY_LEVEL.QUERY_ACCESSORY.equals(queryLevel)) {
                    rspBO.setOrderAccessoryList(this.buildAdjustAccessoryList(reqBO));
                }
                if (UocCoreConstant.MAIN_ORDER_QUERY_LEVEL.QUERY_CANCEL_ORDER.equals(queryLevel)) {
                    rspBO.setUocOrdCancelBO(this.buildOrdCancelRspBO(reqBO));
                }
                if (!UocCoreConstant.MAIN_ORDER_QUERY_LEVEL.QUERY_PAY_INFO.equals(queryLevel)) continue;
                rspBO.setOrdPayConfRspBO(this.buildOrdPayConfRspBO(reqBO));
            }
        } else {
            OrderRspBO orderRspBO = this.buildOrderRspBO(reqBO);
            if (null == orderRspBO) {
                rspBO.setRespCode("100001");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8be5\u8ba2\u5355\u7684\u4fe1\u606f:" + reqBO.getOrderId());
                return rspBO;
            }
            rspBO.setOrderRspBO(orderRspBO);
            rspBO.setOrdStakeholderRspBO(this.buildOrdStakeholderRspBO(reqBO));
            rspBO.setOrdLogisticsRelaRspBOList(this.buildOrdLogisticsRelaRspBO(reqBO));
            rspBO.setOrdInvoiceRspBO(this.buildOrdInvoiceRspBO(reqBO));
            rspBO.setOrdAgreementRspBO(this.buildOrdAgreementRspBO(reqBO));
            rspBO.setOrderAccessoryList(this.buildAdjustAccessoryList(reqBO));
            rspBO.setUocOrdCancelBO(this.buildOrdCancelRspBO(reqBO));
            rspBO.setOrdPayConfRspBO(this.buildOrdPayConfRspBO(reqBO));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateParams(UocCoreMainOrderDetailQueryReqBO reqBO) {
        if (null == reqBO) {
            throw new UocProBusinessException("100001", "\u4e3b\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u3010reqBO\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u4e3b\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0L == reqBO.getOrderId()) {
            throw new UocProBusinessException("100001", "\u4e3b\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u539f\u5b50\u670d\u52a1\u5165\u53c2\u8ba2\u5355ID\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u96f6");
        }
    }

    private OrderRspBO buildOrderRspBO(UocCoreMainOrderDetailQueryReqBO reqBO) {
        OrderPO orderPO = this.orderMapper.getModelById(reqBO.getOrderId().longValue());
        if (null == orderPO) {
            return null;
        }
        OrderRspBO orderRspBO = new OrderRspBO();
        OrdExtMapPO ordExtMapPO = new OrdExtMapPO();
        ordExtMapPO.setOrderId(reqBO.getOrderId());
        ordExtMapPO.setObjId(reqBO.getOrderId());
        ordExtMapPO.setObjType(UocCoreConstant.OBJ_TYPE.ORDER);
        List extMapPOList = this.ordExtMapMapper.getList(ordExtMapPO);
        HashMap<String, String> orderExtraMap = new HashMap<String, String>(16);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)extMapPOList)) {
            for (OrdExtMapPO extMapPO : extMapPOList) {
                orderExtraMap.put(extMapPO.getFieldCode(), extMapPO.getFieldValue());
                if (orderExtraMap.get("evaluateState") != null) {
                    orderRspBO.setEvaluateState(String.valueOf(orderExtraMap.get("evaluateState")));
                }
                if (extMapPO.getFieldCode().equals("adjust_price_time")) {
                    orderRspBO.setAdjustPriceTime(extMapPO.getFieldValue());
                }
                if (extMapPO.getFieldCode().equals("paymentDays")) {
                    orderRspBO.setPaymentDays(extMapPO.getFieldValue());
                }
                if (extMapPO.getFieldCode().equals("busiMode")) {
                    orderRspBO.setBusiMode(extMapPO.getFieldValue());
                    continue;
                }
                orderRspBO.setBusiMode("0");
            }
        }
        BeanUtils.copyProperties((Object)orderPO, (Object)orderRspBO);
        UocPayOrderDetailQueryReqBO payReqBO = new UocPayOrderDetailQueryReqBO();
        payReqBO.setObjType(UocConstant.OBJ_TYPE.SALE);
        payReqBO.setObjId(reqBO.getSaleVoucherId());
        payReqBO.setOrderId(orderPO.getOrderId());
        UocPayOrderDetailQueryRspBO payRspBO = this.uocPayOrderDetailQueryBusiService.getPayOrderDetail(payReqBO);
        if ("0000".equals(payRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)payRspBO.getPayOrderDetailRspBOList())) {
            orderRspBO.setPayState(((UocPayOrderDetailRspBO)payRspBO.getPayOrderDetailRspBOList().get(0)).getOrdPayRspBO().getPayState());
        }
        try {
            orderRspBO.setTotalPurchaseMoney(UocMoneyUtil.long2BigDecimal((Long)orderRspBO.getTotalPurchaseFee()));
            orderRspBO.setTotalSaleMoney(UocMoneyUtil.long2BigDecimal((Long)orderRspBO.getTotalSaleFee()));
        }
        catch (Exception e) {
            throw new UocProBusinessException("100001", "\u8ba2\u5355\u3010uoc_order\u3011\u91d1\u989d\u8f6c\u6362\u5931\u8d25");
        }
        orderRspBO.setExtraMap(this.buildOrderExtraInfoMap(reqBO));
        return orderRspBO;
    }

    private OrdStakeholderRspBO buildOrdStakeholderRspBO(UocCoreMainOrderDetailQueryReqBO reqBO) {
        OrdStakeholderPO ordStakeholderPO = this.ordStakeholderMapper.getModelById(reqBO.getOrderId().longValue());
        OrdLogisticsRelaPO ordLogisticsRelaPO = new OrdLogisticsRelaPO();
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        OrdSalePO salePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (null != salePO) {
            ordLogisticsRelaPO.setOrderId(reqBO.getOrderId());
            ordLogisticsRelaPO.setContactId(salePO.getContactId());
            OrdLogisticsRelaPO relaPO = this.ordLogisticsRelaMapper.getModelBy(ordLogisticsRelaPO);
            OrdStakeholderRspBO ordStakeholderRspBO = new OrdStakeholderRspBO();
            if (null != ordStakeholderPO) {
                BeanUtils.copyProperties((Object)ordStakeholderPO, (Object)ordStakeholderRspBO);
            }
            if (null != relaPO) {
                ordStakeholderRspBO.setPurAddress(relaPO.getContactAddress());
                ordStakeholderRspBO.setProvince(relaPO.getContactProvinceId());
                ordStakeholderRspBO.setCity(relaPO.getContactCityId());
                ordStakeholderRspBO.setCounty(relaPO.getContactCountyId());
                ordStakeholderRspBO.setTown(relaPO.getContactTownId());
            }
            return ordStakeholderRspBO;
        }
        return null;
    }

    private List<OrdLogisticsRelaRspBO> buildOrdLogisticsRelaRspBO(UocCoreMainOrderDetailQueryReqBO reqBO) {
        ArrayList<OrdLogisticsRelaRspBO> ordLogisticsRelaRspBOList = new ArrayList<OrdLogisticsRelaRspBO>();
        OrdLogisticsRelaPO logisticsRelaPO = new OrdLogisticsRelaPO();
        OrdSalePO ordSalePO = new OrdSalePO();
        ordSalePO.setOrderId(reqBO.getOrderId());
        OrdSalePO salePO = this.ordSaleMapper.getModelBy(ordSalePO);
        if (null != salePO) {
            logisticsRelaPO.setOrderId(reqBO.getOrderId());
            logisticsRelaPO.setContactId(salePO.getContactId());
            List logisticsRelaMapperList = this.ordLogisticsRelaMapper.getList(logisticsRelaPO);
            OrdLogisticsRelaRspBO ordLogisticsRelaRspBO = new OrdLogisticsRelaRspBO();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)logisticsRelaMapperList)) {
                for (OrdLogisticsRelaPO ordLogisticsRelaPO : logisticsRelaMapperList) {
                    BeanUtils.copyProperties((Object)ordLogisticsRelaPO, (Object)ordLogisticsRelaRspBO);
                    ordLogisticsRelaRspBOList.add(ordLogisticsRelaRspBO);
                }
            }
            return ordLogisticsRelaRspBOList;
        }
        return null;
    }

    private OrdInvoiceRspBO buildOrdInvoiceRspBO(UocCoreMainOrderDetailQueryReqBO reqBO) {
        OrdInvoicePO invoicePO = new OrdInvoicePO();
        invoicePO.setOrderId(reqBO.getOrderId());
        invoicePO = this.ordInvoiceMapper.getModelByPO(invoicePO);
        OrdInvoiceRspBO ordInvoiceRspBO = new OrdInvoiceRspBO();
        if (null == invoicePO) {
            return null;
        }
        BeanUtils.copyProperties((Object)invoicePO, (Object)ordInvoiceRspBO);
        return ordInvoiceRspBO;
    }

    private List<OrdPayConfRspBO> buildOrdPayConfRspBO(UocCoreMainOrderDetailQueryReqBO reqBO) {
        OrdPayConfPO payConfPO = new OrdPayConfPO();
        payConfPO.setOrderId(reqBO.getOrderId());
        List payConfPOList = this.ordPayConfMapper.selectByCondition(payConfPO);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)payConfPOList)) {
            return Collections.emptyList();
        }
        return payConfPOList.stream().map(item -> {
            OrdPayConfRspBO ordPayConfRspBO = new OrdPayConfRspBO();
            BeanUtils.copyProperties((Object)item, (Object)ordPayConfRspBO);
            return ordPayConfRspBO;
        }).collect(Collectors.toList());
    }

    private Map<String, Object> buildOrderExtraInfoMap(UocCoreMainOrderDetailQueryReqBO reqBO) {
        HashMap<String, Object> orderExtraMap = new HashMap(16);
        OrdCruxMapPO saleOrdCruxMapCondition = new OrdCruxMapPO();
        saleOrdCruxMapCondition.setOrderId(reqBO.getOrderId());
        saleOrdCruxMapCondition.setObjId(reqBO.getOrderId());
        saleOrdCruxMapCondition.setObjType(UocConstant.OBJ_TYPE.ORDER);
        OrdCruxMapPO saleOrdCruxMapPO = this.ordCruxMapMapper.getModelBy(saleOrdCruxMapCondition);
        if (saleOrdCruxMapPO != null) {
            orderExtraMap = this.getExtraMap(saleOrdCruxMapPO);
        }
        OrdExtMapPO ordExtMapCondition = new OrdExtMapPO();
        ordExtMapCondition.setOrderId(reqBO.getOrderId());
        ordExtMapCondition.setObjId(reqBO.getOrderId());
        ordExtMapCondition.setObjType(UocCoreConstant.OBJ_TYPE.ORDER);
        List ordExtMapList = this.ordExtMapMapper.getList(ordExtMapCondition);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)ordExtMapList)) {
            for (OrdExtMapPO ordExtMap : ordExtMapList) {
                orderExtraMap.put(ordExtMap.getFieldCode(), ordExtMap.getFieldValue());
            }
        }
        return orderExtraMap;
    }

    private Map<String, Object> getExtraMap(OrdCruxMapPO ordCruxMapPO) {
        HashMap<String, Object> extraMap = new HashMap<String, Object>(16);
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode1())) {
            extraMap.put(ordCruxMapPO.getFieldCode1(), ordCruxMapPO.getFieldValue1());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode2())) {
            extraMap.put(ordCruxMapPO.getFieldCode2(), ordCruxMapPO.getFieldValue2());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode3())) {
            extraMap.put(ordCruxMapPO.getFieldCode3(), ordCruxMapPO.getFieldValue3());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode4())) {
            extraMap.put(ordCruxMapPO.getFieldCode4(), ordCruxMapPO.getFieldValue4());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode5())) {
            extraMap.put(ordCruxMapPO.getFieldCode5(), ordCruxMapPO.getFieldValue5());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode6())) {
            extraMap.put(ordCruxMapPO.getFieldCode6(), ordCruxMapPO.getFieldValue6());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode7())) {
            extraMap.put(ordCruxMapPO.getFieldCode7(), ordCruxMapPO.getFieldValue7());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode8())) {
            extraMap.put(ordCruxMapPO.getFieldCode8(), ordCruxMapPO.getFieldValue8());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode9())) {
            extraMap.put(ordCruxMapPO.getFieldCode9(), ordCruxMapPO.getFieldValue9());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode10())) {
            extraMap.put(ordCruxMapPO.getFieldCode10(), ordCruxMapPO.getFieldValue10());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode11())) {
            extraMap.put(ordCruxMapPO.getFieldCode11(), ordCruxMapPO.getFieldValue11());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode12())) {
            extraMap.put(ordCruxMapPO.getFieldCode12(), ordCruxMapPO.getFieldValue12());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode13())) {
            extraMap.put(ordCruxMapPO.getFieldCode13(), ordCruxMapPO.getFieldValue13());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode14())) {
            extraMap.put(ordCruxMapPO.getFieldCode14(), ordCruxMapPO.getFieldValue14());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode15())) {
            extraMap.put(ordCruxMapPO.getFieldCode1(), ordCruxMapPO.getFieldValue15());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode16())) {
            extraMap.put(ordCruxMapPO.getFieldCode16(), ordCruxMapPO.getFieldValue16());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode17())) {
            extraMap.put(ordCruxMapPO.getFieldCode17(), ordCruxMapPO.getFieldValue17());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode18())) {
            extraMap.put(ordCruxMapPO.getFieldCode18(), ordCruxMapPO.getFieldValue18());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode19())) {
            extraMap.put(ordCruxMapPO.getFieldCode19(), ordCruxMapPO.getFieldValue19());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode20())) {
            extraMap.put(ordCruxMapPO.getFieldCode20(), ordCruxMapPO.getFieldValue20());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode21())) {
            extraMap.put(ordCruxMapPO.getFieldCode21(), ordCruxMapPO.getFieldValue21());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode22())) {
            extraMap.put(ordCruxMapPO.getFieldCode22(), ordCruxMapPO.getFieldValue22());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode23())) {
            extraMap.put(ordCruxMapPO.getFieldCode23(), ordCruxMapPO.getFieldValue23());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode24())) {
            extraMap.put(ordCruxMapPO.getFieldCode24(), ordCruxMapPO.getFieldValue24());
        }
        if (!StringUtils.isEmpty((Object)ordCruxMapPO.getFieldCode25())) {
            extraMap.put(ordCruxMapPO.getFieldCode25(), ordCruxMapPO.getFieldValue25());
        }
        return extraMap;
    }

    private List<OrdAccessoryRspBO> buildAdjustAccessoryList(UocCoreMainOrderDetailQueryReqBO reqBO) {
        OrdAccessoryPO ordAccessoryPO = new OrdAccessoryPO();
        ordAccessoryPO.setOrderId(reqBO.getOrderId());
        ordAccessoryPO.setObjectId(reqBO.getOrderId());
        ordAccessoryPO.setObjectType(UocCoreConstant.OBJ_TYPE.ORDER);
        List ordAccessoryPOList = this.ordAccessoryMapper.getList(ordAccessoryPO);
        ArrayList<OrdAccessoryRspBO> ordAccessoryRspBOList = new ArrayList<OrdAccessoryRspBO>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ordAccessoryPOList)) {
            for (OrdAccessoryPO accessoryPO : ordAccessoryPOList) {
                OrdAccessoryRspBO ordAccessoryRspBO = new OrdAccessoryRspBO();
                BeanUtils.copyProperties((Object)accessoryPO, (Object)ordAccessoryRspBO);
                ordAccessoryRspBOList.add(ordAccessoryRspBO);
            }
        }
        return ordAccessoryRspBOList;
    }

    private OrdAgreementRspBO buildOrdAgreementRspBO(UocCoreMainOrderDetailQueryReqBO reqBO) {
        OrdAgreementRspBO ordAgreementRspBO = new OrdAgreementRspBO();
        OrdAgreementPO agreementPO = new OrdAgreementPO();
        agreementPO.setOrderId(reqBO.getOrderId());
        List ordAgreementPOList = this.ordAgreementMapper.selectByCondition(agreementPO);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ordAgreementPOList)) {
            BeanUtils.copyProperties(ordAgreementPOList.get(0), (Object)ordAgreementRspBO);
            return ordAgreementRspBO;
        }
        return null;
    }

    private UocOrdCancelBO buildOrdCancelRspBO(UocCoreMainOrderDetailQueryReqBO reqBO) {
        UocOrdCancelBO uocOrdCancelBO = new UocOrdCancelBO();
        OrdCancelPO ordCancelPO = new OrdCancelPO();
        ordCancelPO.setOrderId(reqBO.getOrderId());
        ordCancelPO.setOrderBy("create_time desc");
        List ordCancelPOS = this.ordCancelMapper.getList(ordCancelPO);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)ordCancelPOS)) {
            BeanUtils.copyProperties(ordCancelPOS.get(0), (Object)uocOrdCancelBO);
            uocOrdCancelBO.setCancelId(((OrdCancelPO)ordCancelPOS.get(0)).getId());
            return uocOrdCancelBO;
        }
        return null;
    }
}

