/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uoc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.busi.api.UocEsQryShipListBusiService;
import com.tydic.uoc.common.busi.bo.UocEsQryShipListReqBO;
import com.tydic.uoc.common.busi.bo.UocEsQryShipListRspBO;
import com.tydic.uoc.common.utils.UocBuildEsQrySqlConditionUtil;
import com.tydic.uoc.common.utils.UocElasticsearchUtil;
import com.tydic.uoc.config.UocEsConfig;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="uocEsQryShipListBusiService")
public class UocEsQryShipListBusiServiceImpl
implements UocEsQryShipListBusiService {
    private static final Logger log = LoggerFactory.getLogger(UocEsQryShipListBusiServiceImpl.class);
    private final UocEsConfig uocEsConfig;
    private final UocElasticsearchUtil uocElasticsearchUtil;
    private final UocBuildEsQrySqlConditionUtil buildEsQrySqlContidiontUtil;

    @Autowired
    public UocEsQryShipListBusiServiceImpl(UocEsConfig uocEsConfig, UocElasticsearchUtil uocElasticsearchUtil) {
        this.uocEsConfig = uocEsConfig;
        this.uocElasticsearchUtil = uocElasticsearchUtil;
        this.buildEsQrySqlContidiontUtil = new UocBuildEsQrySqlConditionUtil();
    }

    @Override
    public UocEsQryShipListRspBO esQryShipList(UocEsQryShipListReqBO reqBO) {
        UocEsQryShipListRspBO rspBO = new UocEsQryShipListRspBO();
        String qryString = this.buildEsQrySqlContidiontUtil.buildQryShipEsSql(reqBO);
        log.debug("ES\u67e5\u8be2\u53d1\u8d27\u5355\u6761\u4ef6---->{}", (Object)qryString);
        String endPoint = "/" + this.uocEsConfig.getShipIndexName() + "/_search";
        NStringEntity entity = new NStringEntity(qryString, ContentType.APPLICATION_JSON);
        String result = null;
        Request request = new Request("POST", endPoint);
        request.setJsonEntity(qryString);
        try {
            Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest(request);
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            String ioExceptionStr = JSON.toJSONString((Object)e.getCause());
            if (ioExceptionStr.contains("index_not_found_exception")) {
                boolean index = this.uocElasticsearchUtil.createIndex(this.uocEsConfig.getShipIndexName());
                if (!index) {
                    log.error("\u81ea\u52a8\u521b\u5efa\u53d1\u8d27\u7d22\u5f15\u5931\u8d25");
                    rspBO.setRespCode("100001");
                    rspBO.setRespDesc("\u81ea\u52a8\u521b\u5efa\u53d1\u8d27\u7d22\u5f15\u5931\u8d25");
                    return rspBO;
                }
                try {
                    Response response = this.uocElasticsearchUtil.getLowLevelClient().performRequest(request);
                    result = EntityUtils.toString((HttpEntity)response.getEntity());
                }
                catch (IOException childE) {
                    log.error("ioException", (Throwable)childE);
                    rspBO.setRespCode("102070");
                    rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u53d1\u8d27\u5217\u8868\u4fe1\u606f\u5f02\u5e38!");
                    return rspBO;
                }
            }
            log.error("ioException", (Throwable)e);
            rspBO.setRespCode("102070");
            rspBO.setRespDesc("ES\u8c03\u7528\u67e5\u8be2\u53d1\u8d27\u5355\u5217\u8868\u4fe1\u606f\u9a8c\u6536!");
            return rspBO;
        }
        this.resovelRetrunData(result, rspBO, reqBO.getPageSize(), reqBO.getPageNo());
        return rspBO;
    }

    private void resovelRetrunData(String result, UocEsQryShipListRspBO rspBO, Integer pageSize, Integer pageNo) {
        rspBO.setRespCode("0000");
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getJSONObject("total").getInteger("value");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject == null || listObject.size() < 1) {
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            rspBO.setRecordsTotal(total);
            rspBO.setRows(new ArrayList());
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u53d1\u8d27\u5355\u4fe1\u606f!");
            return;
        }
        ArrayList<UocPebUpperOrderAbilityBO> rows = new ArrayList<UocPebUpperOrderAbilityBO>();
        for (int i = 0; i < listObject.size(); ++i) {
            JSONObject hitObj = listObject.getJSONObject(i);
            JSONObject data = (JSONObject)hitObj.get((Object)"_source");
            String objJsonStr = data.getString("objJson");
            JSONObject objJson = JSONObject.parseObject((String)objJsonStr);
            UocPebUpperOrderAbilityBO upperOrderAbilityBO = (UocPebUpperOrderAbilityBO)JSON.toJavaObject((JSON)objJson, UocPebUpperOrderAbilityBO.class);
            rows.add(upperOrderAbilityBO);
        }
        int totalPageNo = total % pageSize == 0 ? total / pageSize : total / pageSize + 1;
        rspBO.setTotal(totalPageNo);
        rspBO.setRecordsTotal(total);
        rspBO.setPageNo(pageNo);
        rspBO.setRespDesc("\u67e5\u8be2\u53d1\u8d27\u5355\u5217\u8868\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(rows);
    }
}

