/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader;

import com.taobao.pandora.boot.loader.Launcher;
import com.taobao.pandora.loader.archive.Archive;
import com.taobao.pandora.loader.util.UrlUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.jar.Manifest;

public abstract class ExecutableArchiveLauncher
extends Launcher {
    private final Archive archive;

    public ExecutableArchiveLauncher() {
        try {
            this.archive = this.createArchive();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected ExecutableArchiveLauncher(Archive archive) {
        this.archive = archive;
    }

    protected final Archive getArchive() {
        return this.archive;
    }

    @Override
    protected String getMainClass() throws Exception {
        Manifest manifest = this.archive.getManifest();
        String mainClass = null;
        if (manifest != null) {
            mainClass = manifest.getMainAttributes().getValue("Start-Class");
        }
        if (mainClass == null) {
            throw new IllegalStateException("No 'Start-Class' manifest entry specified in " + this);
        }
        return mainClass;
    }

    @Override
    protected List<Archive> getClassPathArchives() throws Exception {
        ArrayList<Archive> archives = new ArrayList<Archive>(this.archive.getNestedArchives(new Archive.EntryFilter(){

            @Override
            public boolean matches(Archive.Entry entry) {
                return ExecutableArchiveLauncher.this.isNestedArchive(entry);
            }
        }));
        this.sortArchivesByIndex(archives);
        this.postProcessClassPathArchives(archives);
        return archives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortArchivesByIndex(List<Archive> archives) throws IOException {
        HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
        URL url = this.getArchive().getResource("BOOT-INF/INDEX.LIST");
        if (url == null) {
            return;
        }
        int order = 1;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
            String jarName = null;
            while ((jarName = bufferedReader.readLine()) != null) {
                if (orderMap.containsKey(jarName)) continue;
                orderMap.put(jarName, order++);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        final HashMap<String, Integer> finalOrderMap = orderMap;
        Collections.sort(archives, new Comparator<Archive>(){

            private int getOrder(Archive a) {
                try {
                    String jarName = UrlUtils.getSuffixFileName(a.getUrl());
                    if ("classes".equals(jarName)) {
                        return 0;
                    }
                    Integer order = (Integer)finalOrderMap.get(jarName);
                    if (order != null) {
                        return order;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                return Integer.MAX_VALUE;
            }

            @Override
            public int compare(Archive a1, Archive a2) {
                return this.getOrder(a1) - this.getOrder(a2);
            }
        });
    }

    protected abstract boolean isNestedArchive(Archive.Entry var1);

    protected void postProcessClassPathArchives(List<Archive> archives) throws Exception {
    }
}

