/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader;

import com.taobao.pandora.boot.loader.BaseLaunchURLClassLoader;
import com.taobao.pandora.loader.jar.Handler;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Map;
import java.util.jar.JarFile;

public class ReLaunchURLClassLoader
extends BaseLaunchURLClassLoader {
    private static LockProvider LOCK_PROVIDER = ReLaunchURLClassLoader.setupLockProvider();
    private final ClassLoader rootClassLoader;
    private final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();

    public ReLaunchURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.rootClassLoader = this.findRootClassLoader(parent);
    }

    private ClassLoader findRootClassLoader(ClassLoader classLoader) {
        while (classLoader != null) {
            if (classLoader.getParent() == null) {
                return classLoader;
            }
            classLoader = classLoader.getParent();
        }
        return null;
    }

    public void setClassCache(Map<String, Class<?>> classCache) {
        this.classCache = classCache;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.rootClassLoader != null) {
            url = this.rootClassLoader.getResource(name);
        }
        return url == null ? this.findResource(name) : url;
    }

    @Override
    public URL findResource(String name) {
        URL uRL;
        Handler.setUseFastConnectionExceptions(true);
        try {
            uRL = super.findResource(name);
        }
        catch (Throwable throwable) {
            try {
                Handler.setUseFastConnectionExceptions(false);
                throw throwable;
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        Handler.setUseFastConnectionExceptions(false);
        return uRL;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        Handler.setUseFastConnectionExceptions(true);
        try {
            Enumeration<URL> enumeration = super.findResources(name);
            return enumeration;
        }
        finally {
            Handler.setUseFastConnectionExceptions(false);
        }
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.rootClassLoader == null) {
            return this.findResources(name);
        }
        return new ResourceEnumeration(this.rootClassLoader.getResources(name), this.findResources(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = LOCK_PROVIDER.getLock(this, name);
        synchronized (object) {
            if (this.classCache != null && this.classCache.containsKey(name)) {
                return (Class)this.classCache.get(name);
            }
            Class<?> loadedClass = this.findLoadedClass(name);
            if (loadedClass == null) {
                Handler.setUseFastConnectionExceptions(true);
                try {
                    loadedClass = this.doLoadClass(name);
                }
                finally {
                    Handler.setUseFastConnectionExceptions(false);
                }
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            super.recordClass(loadedClass);
            return loadedClass;
        }
    }

    private Class<?> doLoadClass(String name) throws ClassNotFoundException {
        try {
            if (this.rootClassLoader != null) {
                return this.rootClassLoader.loadClass(name);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.findPackage(name);
            Class<?> cls = this.findClass(name);
            return cls;
        }
        catch (Exception ex) {
            try {
                return this.systemClassLoader.loadClass(name);
            }
            catch (Exception exception) {
                return super.loadClass(name, false);
            }
        }
    }

    private void findPackage(String name) throws ClassNotFoundException {
        String packageName;
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1 && this.getPackage(packageName = name.substring(0, lastDot)) == null) {
            try {
                this.definePackageForFindClass(name, packageName);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void definePackageForFindClass(final String name, final String packageName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws ClassNotFoundException {
                    String packageEntryName = packageName.replace('.', '/') + "/";
                    String classEntryName = name.replace('.', '/') + ".class";
                    for (URL url : ReLaunchURLClassLoader.this.getURLs()) {
                        try {
                            JarFile jarFile;
                            URLConnection connection = url.openConnection();
                            if (!(connection instanceof JarURLConnection) || (jarFile = ((JarURLConnection)connection).getJarFile()).getEntry(classEntryName) == null || jarFile.getEntry(packageEntryName) == null || jarFile.getManifest() == null) continue;
                            ReLaunchURLClassLoader.this.definePackage(packageName, jarFile.getManifest(), url);
                            return null;
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }, AccessController.getContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    private static LockProvider setupLockProvider() {
        try {
            ClassLoader.registerAsParallelCapable();
            return new Java7LockProvider();
        }
        catch (NoSuchMethodError ex) {
            return new LockProvider();
        }
    }

    private static class ResourceEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL> rootResources;
        private final Enumeration<URL> localResources;

        ResourceEnumeration(Enumeration<URL> rootResources, Enumeration<URL> localResources) {
            this.rootResources = rootResources;
            this.localResources = localResources;
        }

        @Override
        public boolean hasMoreElements() {
            try {
                Handler.setUseFastConnectionExceptions(true);
                boolean bl = this.rootResources.hasMoreElements() || this.localResources.hasMoreElements();
                return bl;
            }
            finally {
                Handler.setUseFastConnectionExceptions(false);
            }
        }

        @Override
        public URL nextElement() {
            if (this.rootResources.hasMoreElements()) {
                return this.rootResources.nextElement();
            }
            return this.localResources.nextElement();
        }
    }

    private static class Java7LockProvider
    extends LockProvider {
        private Java7LockProvider() {
        }

        @Override
        public Object getLock(ReLaunchURLClassLoader classLoader, String className) {
            return classLoader.getClassLoadingLock(className);
        }
    }

    private static class LockProvider {
        private LockProvider() {
        }

        public Object getLock(ReLaunchURLClassLoader classLoader, String className) {
            return classLoader;
        }
    }
}

