/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.pandora.boot.loader;

import com.sun.management.UnixOperatingSystemMXBean;
import com.taobao.pandora.boot.loader.util.AnsiLog;
import com.taobao.pandora.boot.loader.util.ClassLoaderUtils;
import com.taobao.pandora.boot.loader.util.StringUtils;
import com.taobao.pandora.loader.archive.Archive;
import com.taobao.pandora.loader.archive.ExplodedArchive;
import com.taobao.pandora.loader.archive.JarFileArchive;
import com.taobao.pandora.loader.jar.JarFile;
import com.taobao.pandora.loader.util.ArchiveUtils;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class SarLoaderUtils {
    private static final String JAR_PLUGIN = ".jar.plugin";
    private static final String PLUGINS = "plugins/";
    private static final String SLASH = "/";
    private static final String SEPARATOR = "!/";
    private static final String SAR_GUIDE_PROPERTIES = "com/taobao/pandora/guide.properties";
    private static final String PLUGIN_GUIDE_PROPERTIES = "com/taobao/pandora/plugin.guide.properties";
    private static final String LIB = "lib/";
    private static final Pattern SAR_FILE_PATTERN = Pattern.compile("BOOT-INF/lib/taobao-hsf\\.sar-all(?:[^/]*\\.jar)?");
    private static final Pattern SAR_DIR_PATTERN = Pattern.compile("BOOT-INF/lib/taobao-hsf\\.sar-all(?:[^/]*\\.jar)?/");
    private static final String LOG4J_DEFAULTINITOVERRIDE = "log4j.defaultInitOverride";
    private static volatile Boolean sarLoaded = null;
    private static volatile long t1 = System.nanoTime();
    private static final String SYSTEM_PROPERTY_JAVA_AWT_HEADLESS = "java.awt.headless";

    public static Archive findFromClassPath(URL[] urls) throws Exception {
        URL resource;
        URLClassLoader classLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader().getParent());
        ArrayList<URL> resources = Collections.list(classLoader.getResources(SAR_GUIDE_PROPERTIES));
        if (resources.isEmpty()) {
            return null;
        }
        if (resources.size() > 1) {
            System.out.println("Found more than one taobao-hsf.sar from classpath, please check your config! urls:");
            for (URL url : resources) {
                System.out.println(url);
            }
        }
        if ((resource = resources.get(0)) != null) {
            String resourceStr = resource.toString();
            String pandoraLocationUrl = resourceStr.substring(0, resourceStr.length() - SAR_GUIDE_PROPERTIES.length());
            return ArchiveUtils.createArchiveFromUrl(new URL(pandoraLocationUrl));
        }
        return null;
    }

    static Archive findEmbeddedSar(Archive archive) throws Exception {
        if (archive == null) {
            return null;
        }
        List<Archive> archives = archive.getNestedArchives(new Archive.EntryFilter(){

            @Override
            public boolean matches(Archive.Entry entry) {
                String entryName = entry.getName();
                return entry.isDirectory() && SAR_DIR_PATTERN.matcher(entryName).matches() || !entry.isDirectory() && SAR_FILE_PATTERN.matcher(entryName).matches();
            }
        });
        return archives != null && !archives.isEmpty() ? archives.get(0) : null;
    }

    public static Archive findExternalSar() throws Exception {
        String pandoraLocation = System.getProperty("pandora.location");
        if (pandoraLocation == null) {
            return null;
        }
        File sar = new File(pandoraLocation);
        if (!sar.exists()) {
            if (pandoraLocation.trim().startsWith("~")) {
                AnsiLog.error("[PANDORA ERROR] Please use full file path in '-Dpandora.location=', '~' only works in shell.");
                AnsiLog.error("[PANDORA ERROR] Try to set '-Dpandora.location={}'", pandoraLocation.replaceFirst("^~", System.getProperty("user.home")));
            }
            return null;
        }
        return sar.isDirectory() ? new ExplodedArchive(sar) : new JarFileArchive(sar);
    }

    public static Archive findFromSystemClassLoader() throws Exception {
        URL[] urls = ClassLoaderUtils.getUrls(ClassLoader.getSystemClassLoader());
        return SarLoaderUtils.findFromClassPath(urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Class<?>> getClassCache(Archive sar, ClassLoader bizClassLoader) throws Exception {
        JarFile.registerUrlProtocolHandler();
        SarLoaderUtils.printBanner(bizClassLoader);
        SarLoaderUtils.configHostType();
        SarLoaderUtils.configTddlVersionCheck();
        SarLoaderUtils.configureHeadlessProperty();
        Map<String, Archive> pluginsFromSar = SarLoaderUtils.loadPlugins(sar);
        List<URL> pluginJarUrls = Collections.emptyList();
        if (!SarLoaderUtils.ignorePackagedPlugins()) {
            pluginJarUrls = new ArrayList();
            Enumeration<URL> pluginPropertiesResources = bizClassLoader.getResources(PLUGIN_GUIDE_PROPERTIES);
            while (pluginPropertiesResources.hasMoreElements()) {
                URL guidePropertiesUrl = pluginPropertiesResources.nextElement();
                String pluginArtifactId = SarLoaderUtils.readPluginArtifactId(guidePropertiesUrl);
                if (pluginArtifactId == null || pluginsFromSar.containsKey(pluginArtifactId)) continue;
                pluginJarUrls.add(ArchiveUtils.createArchiveFromUrl(guidePropertiesUrl).getUrl());
            }
        }
        URL url = sar.getUrl();
        List<Archive> jars = sar.getNestedArchives(new Archive.EntryFilter(){

            @Override
            public boolean matches(Archive.Entry entry) {
                String entryName = entry.getName();
                if (entryName.length() > SarLoaderUtils.LIB.length() && entryName.charAt(SarLoaderUtils.LIB.length()) == '.') {
                    System.out.println("entryName is a hidden directory in sar, ignore: " + entryName);
                    return false;
                }
                return !entry.isDirectory() && entryName.startsWith(SarLoaderUtils.LIB);
            }
        });
        URL[] urls = new URL[jars.size()];
        for (int i = 0; i < jars.size(); ++i) {
            urls[i] = jars.get(i).getUrl();
        }
        URLClassLoader classLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader().getParent());
        String defaultInitOverride = System.getProperty(LOG4J_DEFAULTINITOVERRIDE);
        if (defaultInitOverride == null) {
            System.out.println("Set log4j.defaultInitOverride to true.");
            System.setProperty(LOG4J_DEFAULTINITOVERRIDE, "true");
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            URL[] pluginUrls = pluginJarUrls.toArray(new URL[pluginJarUrls.size()]);
            Class<?> pandora = classLoader.loadClass("com.taobao.pandora.PandoraContainer");
            Thread.currentThread().setContextClassLoader(pandora.getClassLoader());
            Constructor<?> constructor = pandora.getConstructor(URL.class, URL[].class, ClassLoader.class);
            Object instance = constructor.newInstance(url, pluginUrls, bizClassLoader);
            SarLoaderUtils.invokeStart(instance);
            SarLoaderUtils.checkFileDescriptorCount();
            Map<String, Class<?>> map = SarLoaderUtils.invokeGetExportedClasses(instance);
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static void configTddlVersionCheck() {
        if (System.getProperty("tddl.version.check") == null) {
            System.setProperty("tddl.version.check", "false");
        }
    }

    private static void configHostType() {
        System.setProperty("pandora.host.type", System.getProperty("pandora.host.type", "PANDORABOOT"));
    }

    private static void configureHeadlessProperty() {
        System.setProperty(SYSTEM_PROPERTY_JAVA_AWT_HEADLESS, System.getProperty(SYSTEM_PROPERTY_JAVA_AWT_HEADLESS, "true"));
    }

    private static void printBanner(ClassLoader classLoader) {
        if (!"false".equalsIgnoreCase(System.getProperty("pandora.boot.printBanner", "true"))) {
            try {
                Class<?> clazz = classLoader.loadClass("com.taobao.pandora.boot.PandoraBootBanner");
                Method method = clazz.getMethod("printBanner", System.out.getClass());
                method.invoke(null, System.out);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void invokeStart(Object pandoraContainer) throws Exception {
        Method start = pandoraContainer.getClass().getDeclaredMethod("start", new Class[0]);
        start.invoke(pandoraContainer, new Object[0]);
    }

    private static Map<String, Class<?>> invokeGetExportedClasses(Object pandoraContainer) throws Exception {
        Method cache = pandoraContainer.getClass().getDeclaredMethod("getExportedClasses", new Class[0]);
        return (Map)cache.invoke(pandoraContainer, new Object[0]);
    }

    private static boolean isExternalSarPresent() {
        File sar;
        String pandoraLocation = System.getProperty("pandora.location");
        return pandoraLocation != null && pandoraLocation.length() > 0 && (sar = new File(pandoraLocation)).exists();
    }

    private static boolean ignorePackagedPlugins() {
        return SarLoaderUtils.isExternalSarPresent() && Boolean.getBoolean("pandora.ignore.packaged.plugins");
    }

    public static boolean unneedLoadSar() {
        return sarLoaded != null;
    }

    public static long t1() {
        return t1;
    }

    public static void markSarLoaderUtils(ClassLoader classLoader, String fieldName, Object value) {
        try {
            Class<?> sarLauncherClass = classLoader.loadClass(SarLoaderUtils.class.getName());
            Field declaredField = sarLauncherClass.getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            declaredField.set(null, value);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String readPluginArtifactId(URL url) {
        try {
            Properties properties = new Properties();
            properties.load(url.openStream());
            return properties.getProperty("artifactId");
        }
        catch (IOException e) {
            System.err.println("can not read properties from url:" + url + "exception:" + e);
            return null;
        }
    }

    private static Map<String, Archive> loadPlugins(Archive containerArchive) {
        HashMap<String, Archive> result = new HashMap<String, Archive>();
        try {
            List<Archive> pluginArchives = containerArchive.getNestedArchives(new PluginEntryFilter());
            for (Archive archive : pluginArchives) {
                String moduleName = SarLoaderUtils.findModuleName(archive.getUrl());
                if (moduleName == null) continue;
                result.put(moduleName, archive);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("load plugin from archive error! archive:" + containerArchive, e);
        }
        return result;
    }

    private static String findModuleName(URL pluginUrl) {
        String pluginPath = pluginUrl.toExternalForm();
        if (StringUtils.contains(pluginPath, PLUGINS)) {
            String pluginName = StringUtils.substringAfterLast(pluginPath, PLUGINS);
            if (pluginName.endsWith(JAR_PLUGIN)) {
                return StringUtils.removeEnd(pluginName, JAR_PLUGIN);
            }
            if (pluginName.endsWith(".jar.plugin!/")) {
                return StringUtils.removeEnd(pluginName, ".jar.plugin!/");
            }
            if (pluginName.endsWith(SEPARATOR)) {
                return StringUtils.removeEnd(pluginName, SEPARATOR);
            }
            if (pluginName.endsWith(SLASH)) {
                return StringUtils.removeEnd(pluginName, SLASH);
            }
        }
        System.err.println("pluginPath is not a valid plugin:" + pluginPath);
        return null;
    }

    public static void checkFileDescriptorCount() {
        long openFileDescriptorCount;
        UnixOperatingSystemMXBean unixOperatingSystemMXBean;
        long maxFileDescriptorCount;
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystemMXBean instanceof UnixOperatingSystemMXBean && (maxFileDescriptorCount = (unixOperatingSystemMXBean = (UnixOperatingSystemMXBean)operatingSystemMXBean).getMaxFileDescriptorCount()) - (openFileDescriptorCount = unixOperatingSystemMXBean.getOpenFileDescriptorCount()) < 100L) {
            AnsiLog.error("Please make sure your os File Descriptor limit config is right. maxFileDescriptorCount: {}, openFileDescriptorCount: {}", maxFileDescriptorCount, openFileDescriptorCount);
        }
    }

    private static class PluginEntryFilter
    implements Archive.EntryFilter {
        private PluginEntryFilter() {
        }

        @Override
        public boolean matches(Archive.Entry entry) {
            String entryName = entry.getName();
            if (entryName.startsWith(SarLoaderUtils.PLUGINS)) {
                int slashCount = StringUtils.countMatches(entryName, SarLoaderUtils.SLASH);
                if (entry.isDirectory() && slashCount == 2) {
                    if (entryName.length() > SarLoaderUtils.PLUGINS.length() && entryName.charAt(SarLoaderUtils.PLUGINS.length()) == '.') {
                        System.out.println("entryName is a hidden directory in sar, ignore: " + entryName);
                        return false;
                    }
                    return true;
                }
                return slashCount == 1 && entryName.endsWith(SarLoaderUtils.JAR_PLUGIN);
            }
            return false;
        }
    }
}

