/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.document.impl.ability;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.document.api.ability.DocDetailUploadAbilityService;
import com.tydic.document.api.ability.bo.DocDetailUploadAbilityReqBo;
import com.tydic.document.api.ability.bo.DocDetailUploadAbilityRspBo;
import com.tydic.document.api.busi.DocDetailUploadBusiService;
import com.tydic.document.api.busi.bo.DocDetailUploadBusiReqBo;
import com.tydic.document.api.busi.bo.DocDetailUploadBusiRspBo;
import com.tydic.document.common.exception.DocBusinessException;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="docDetailUploadAbilityService")
@HSFProvider(serviceVersion="1.0", serviceGroup="DOCUMENT_GROUP", serviceInterface=DocDetailUploadAbilityService.class)
public class DocDetailUploadAbilityServiceImpl
implements DocDetailUploadAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DocDetailUploadAbilityServiceImpl.class);
    @Autowired
    private DocDetailUploadBusiService docDetailUploadBusiService;

    public DocDetailUploadAbilityRspBo docDetailUpload(DocDetailUploadAbilityReqBo reqBo) {
        log.info("===============\u6587\u4ef6\u8be6\u60c5\u4e0a\u4f20\u670d\u52a1\u5f00\u59cb==============");
        log.info("\u5165\u53c2\uff1a" + reqBo);
        DocDetailUploadAbilityRspBo retBo = new DocDetailUploadAbilityRspBo();
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("4003");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        String content = this.readInputStream(reqBo);
        DocDetailUploadBusiReqBo busiReqBo = new DocDetailUploadBusiReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)busiReqBo);
        busiReqBo.setContent(content);
        DocDetailUploadBusiRspBo busiRetBo = this.docDetailUploadBusiService.uploadDocDetail(busiReqBo);
        BeanUtils.copyProperties((Object)busiRetBo, (Object)retBo);
        if (!"0000".equals(busiRetBo.getRespCode())) {
            log.error("\u8c03\u7528busi\u670d\u52a1\u5165\u5e93\u6587\u4ef6\u8be6\u60c5\u5931\u8d25\uff1a" + busiRetBo.getRespDesc());
            return retBo;
        }
        log.info("\u51fa\u53c2\uff1a" + retBo);
        log.info("===============\u6587\u4ef6\u8be6\u60c5\u4e0a\u4f20\u670d\u52a1\u7ed3\u675f==============");
        return retBo;
    }

    private String readInputStream(DocDetailUploadAbilityReqBo reqBo) {
        String result;
        InputStream inputStream;
        MultipartFile file = reqBo.getFile();
        String filename = file.getOriginalFilename();
        assert (filename != null);
        String suffix = filename.substring(filename.lastIndexOf(".") + 1);
        if (!"md".equals(suffix)) {
            throw new DocBusinessException("8001", "\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u4e3a\u4e0d\u652f\u6301\u7684\u683c\u5f0f\uff1a" + suffix + ", \u8bf7\u4e0a\u4f20\u683c\u5f0f\u4e3a.md\u7684\u6587\u4ef6");
        }
        try {
            inputStream = file.getInputStream();
        }
        catch (IOException e) {
            throw new DocBusinessException("8001", "\u83b7\u53d6\u6587\u4ef6\u6d41\u65f6\u5f02\u5e38\uff1a" + e);
        }
        try {
            result = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            throw new DocBusinessException("8001", "\u89e3\u6790\u6587\u4ef6\u65f6\u5f02\u5e38\uff1a" + e);
        }
        return result;
    }
}

