/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.document.impl.busi;

import com.tydic.document.api.busi.DocDetailUploadBusiService;
import com.tydic.document.api.busi.bo.DocDetailUploadBusiReqBo;
import com.tydic.document.api.busi.bo.DocDetailUploadBusiRspBo;
import com.tydic.document.api.constants.DocDictionaryValueConstants;
import com.tydic.document.common.exception.DocBusinessException;
import com.tydic.document.dao.DocInfoDocDetailContentMapper;
import com.tydic.document.dao.DocInfoDocDetailMapper;
import com.tydic.document.dao.DocInfoDocTypeMenuMapper;
import com.tydic.document.dao.po.DocInfoDocDetailContentPo;
import com.tydic.document.dao.po.DocInfoDocDetailPo;
import com.tydic.document.dao.po.DocInfoDocTypeMenuPo;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="docDetailUploadBusiService")
public class DocDetailUploadBusiServiceImpl
implements DocDetailUploadBusiService {
    private static final Logger log = LoggerFactory.getLogger(DocDetailUploadBusiServiceImpl.class);
    @Autowired
    private DocInfoDocDetailMapper docInfoDocDetailMapper;
    @Autowired
    private DocInfoDocTypeMenuMapper docInfoDocTypeMenuMapper;
    @Autowired
    private DocInfoDocDetailContentMapper docInfoDocDetailContentMapper;

    public DocDetailUploadBusiRspBo uploadDocDetail(DocDetailUploadBusiReqBo reqBo) {
        log.info("\u6587\u6863\u8be6\u60c5\u4e0a\u4f20 Busi\u670d\u52a1\uff1a " + reqBo);
        DocDetailUploadBusiRspBo retBo = new DocDetailUploadBusiRspBo();
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("2002");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        Long detailId = this.saveDocDetail(reqBo);
        this.saveDetailContent(detailId, reqBo.getContent());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Long saveDocDetail(DocDetailUploadBusiReqBo reqBo) {
        DocInfoDocTypeMenuPo menuPo = this.docInfoDocTypeMenuMapper.selectByPrimaryKey(reqBo.getMenuId());
        if (null == menuPo) {
            throw new DocBusinessException("6001", "\u83dc\u5355ID\uff08" + reqBo.getMenuId() + "\uff09\u4e0d\u5b58\u5728");
        }
        DocInfoDocDetailPo detailPo = new DocInfoDocDetailPo();
        detailPo.setTypeId(menuPo.getTypeId());
        detailPo.setMenuId(reqBo.getMenuId());
        detailPo.setDetailName(reqBo.getFileName());
        List<DocInfoDocDetailPo> detailPos = this.docInfoDocDetailMapper.selectByCondition(detailPo);
        if (!CollectionUtils.isEmpty(detailPos)) {
            throw new DocBusinessException("6001", "\u6587\u4ef6\uff08" + reqBo.getFileName() + "\uff09\u5df2\u5b58\u5728");
        }
        Date nowTime = this.docInfoDocTypeMenuMapper.getDbDate();
        BeanUtils.copyProperties((Object)reqBo, (Object)detailPo);
        detailPo.setCreateTime(nowTime);
        detailPo.setDetailStatus(DocDictionaryValueConstants.DOC_INFO_STATUS_EFFECTIVE);
        int result = this.docInfoDocDetailMapper.insertSelective(detailPo);
        if (result < 1) {
            throw new DocBusinessException("6001", "\u6587\u6863\u8be6\u60c5\u5165\u5e93\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        return detailPo.getDetailId();
    }

    private void saveDetailContent(Long detailId, String content) {
        DocInfoDocDetailContentPo contentPo = new DocInfoDocDetailContentPo();
        contentPo.setDetailId(detailId);
        contentPo.setDetailContent(content);
        int result = this.docInfoDocDetailContentMapper.insert(contentPo);
        if (result < 1) {
            throw new DocBusinessException("6001", "\u6587\u6863\u8be6\u60c5\u5185\u5bb9\u5165\u5e93\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
    }
}

