/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.document.utils;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.ohaotian.plugin.file.FileClient;
import java.io.InputStream;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DocFileUtil {
    @Resource
    FileClient fileClient;
    private static FileClient fileClients;
    private static final String PLUGIN_FILE_TYPE_OSS = "OSS";
    private static String basePrefix;
    private static String bucketName;
    private static String endPoint;
    private static String accesskey;
    private static String accessKeySecret;
    private static String type;
    private static final String HTTP = "http://";
    private static final String BACKSLASH = "/";
    private static final String POINT = ".";

    @PostConstruct
    public void init() {
        fileClients = this.fileClient;
    }

    @Value(value="${doc.file.upload.folder}")
    public void setBasePrefix(String basePrefix) {
        DocFileUtil.basePrefix = basePrefix;
    }

    @Value(value="${oss.bucketName}")
    public void setBucketName(String bucketName) {
        DocFileUtil.bucketName = bucketName;
    }

    @Value(value="${oss.endpoint}")
    public void setEndPoint(String endPoint) {
        DocFileUtil.endPoint = endPoint;
    }

    @Value(value="${oss.accesskey}")
    public void setAccesskey(String accesskey) {
        DocFileUtil.accesskey = accesskey;
    }

    @Value(value="${oss.accessKeySecret}")
    public void setAccessKeySecret(String accessKeySecret) {
        DocFileUtil.accessKeySecret = accessKeySecret;
    }

    @Value(value="${plugin.file.type}")
    public void setType(String type) {
        DocFileUtil.type = type;
    }

    public static String fileUpload(InputStream fileStream, String fileTypePath, String fileName) {
        System.out.println("\u6587\u6863\u4e2d\u5fc3-\u6587\u4ef6-\u5de5\u5177\u7c7b\uff1a\u5373\u5c06\u8fdb\u884c\u6587\u4ef6\u4e0a\u4f20");
        String ossPath = basePrefix + BACKSLASH + fileTypePath;
        System.out.println("\u6587\u6863\u4e2d\u5fc3-\u6587\u4ef6-\u5de5\u5177\u7c7b\uff1a\u672c\u6b21\u6587\u4ef6\u7684\u4fdd\u5b58\u8def\u5f84\u4e3a\uff1a" + ossPath);
        System.out.println("\u51c6\u5907\u4e0a\u4f20\u6587\u4ef6-------------------------");
        String filePath = fileClients.uploadFileByInputStream(ossPath, fileName, fileStream);
        System.out.println("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u4fdd\u5b58\u5230\u8def\u5f84(" + filePath + ")\u4e2d");
        return fileTypePath + BACKSLASH + fileName;
    }

    public static void fileDelete(String suffix) {
        System.out.println("\u6587\u6863\u4e2d\u5fc3-\u6587\u4ef6-\u5de5\u5177\u7c7b\uff1a\u5373\u5c06\u5220\u9664\u6587\u4ef6");
        if (PLUGIN_FILE_TYPE_OSS.equals(type)) {
            String endpoint = HTTP + endPoint;
            OSS ossClient = new OSSClientBuilder().build(endpoint, accesskey, accessKeySecret);
            String file = basePrefix + BACKSLASH + suffix;
            System.out.println("\u672c\u6b21\u6267\u884c\u7684\u64cd\u4f5c\u662f\u5220\u9664OSS\u4e0a\u7684\u6587\u4ef6\u5220\u9664\uff0c\u5220\u9664\u7684\u6587\u4ef6\u662f\uff1a" + file);
            ossClient.deleteObject(bucketName, file);
            ossClient.shutdown();
        }
        System.out.println("\u6587\u6863\u4e2d\u5fc3-\u6587\u4ef6-\u5de5\u5177\u7c7b\uff1a\u6587\u4ef6\u5220\u9664\u7ed3\u675f");
    }

    public static String getAbsolutePath(String suffix) {
        System.out.println("\u5546\u6237\u4e2d\u5fc3-\u6587\u4ef6-\u5de5\u5177\u7c7b\uff1a\u5730\u5740\u62fc\u63a5");
        System.out.println("\u4f20\u5165\u7684\u5730\u5740\u4e3a\uff1a" + suffix);
        return HTTP + bucketName + POINT + endPoint + BACKSLASH + basePrefix + BACKSLASH + suffix;
    }

    public static String getRandomName() {
        StringBuilder randomStr = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            randomStr.append((int)(1.0 + Math.random() * 9.0));
        }
        return System.currentTimeMillis() + "_" + randomStr;
    }

    public static enum GroupType {
        IMG(1, "img");

        private final Integer code;
        private final String value;

        private GroupType(Integer code, String value) {
            this.code = code;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public Integer getCode() {
            return this.code;
        }

        public static GroupType getGroupType(Integer code) {
            for (GroupType groupType : GroupType.values()) {
                if (!groupType.code.equals(code)) continue;
                return groupType;
            }
            return null;
        }
    }
}

