/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.tydic.fsc.busibase.atom.api.FscUpdateSaleOrderPayStateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscUpdateSaleOrderPayStateAtomReqBo;
import com.tydic.fsc.busibase.atom.bo.FscUpdateSaleOrderPayStateAtomRspBo;
import com.tydic.fsc.busibase.external.api.bo.FscUocUpdateSaleOrderPayStateAtomReqBo;
import com.tydic.fsc.busibase.external.api.uoc.FscUocUpdateSaleOrderPayStateAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscUpdateSaleOrderPayStateAtomServiceImpl
implements FscUpdateSaleOrderPayStateAtomService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscUocUpdateSaleOrderPayStateAtomService fscUocUpdateSaleOrderPayStateAtomService;
    public static final Integer SALE_ORDER_PAY_STATE_NOT_PAY = 1400;

    @Override
    public FscUpdateSaleOrderPayStateAtomRspBo updateOrderPayState(FscUpdateSaleOrderPayStateAtomReqBo reqBo) {
        List<FscOrderPO> fscOrderPOs;
        List shouldPayPOS;
        List<FscShouldPayPO> fscShouldPayPOS;
        if (CollectionUtils.isNotEmpty(reqBo.getFscOrderIds()) && CollectionUtils.isNotEmpty(fscShouldPayPOS = this.fscShouldPayMapper.getByFscOrderIds(reqBo.getFscOrderIds())) && CollectionUtils.isNotEmpty(shouldPayPOS = fscShouldPayPOS.stream().filter(fscShouldPayPO -> FscConstants.ShouldObjectType.SALE_ORDER.equals(fscShouldPayPO.getObjectType()) && FscConstants.ShouldPayType.ADVANCE_PAY.equals(fscShouldPayPO.getShouldPayType())).collect(Collectors.toList())) && CollectionUtils.isNotEmpty(fscOrderPOs = this.getFscOrderPO(shouldPayPOS.stream().map(FscShouldPayPO::getFscOrderId).collect(Collectors.toList())))) {
            Map<Long, Integer> fscOrderStateMap = fscOrderPOs.stream().collect(Collectors.toMap(FscOrderPO::getFscOrderId, FscOrderPO::getOrderState));
            for (FscShouldPayPO shouldPayPO : shouldPayPOS) {
                try {
                    FscUocUpdateSaleOrderPayStateAtomReqBo fscUocUpdateSaleOrderPayStateAtomReqBo = new FscUocUpdateSaleOrderPayStateAtomReqBo();
                    fscUocUpdateSaleOrderPayStateAtomReqBo.setSaleOrderId(shouldPayPO.getObjectId());
                    if (null == fscOrderStateMap.get(shouldPayPO.getFscOrderId())) continue;
                    Integer orderPayState = fscOrderStateMap.get(shouldPayPO.getFscOrderId());
                    if (FscConstants.FscPayOrderState.CANCEL.equals(orderPayState)) {
                        orderPayState = SALE_ORDER_PAY_STATE_NOT_PAY;
                    }
                    fscUocUpdateSaleOrderPayStateAtomReqBo.setPayState(orderPayState);
                    this.fscUocUpdateSaleOrderPayStateAtomService.updateOrderPayState(fscUocUpdateSaleOrderPayStateAtomReqBo);
                }
                catch (Exception exception) {}
            }
        }
        return new FscUpdateSaleOrderPayStateAtomRspBo();
    }

    private List<FscOrderPO> getFscOrderPO(List<Long> fscOrderIds) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(fscOrderIds);
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        return this.fscOrderMapper.getList(fscOrderPO);
    }
}

