package com.tydic.dyc.oc.service.domainservice.bo;


import com.tydic.dyc.base.bo.BaseExtendBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocCreateOrderServiceReqAgrBo
 * 说明:协议信息
 * 时间:2022/4/1 20:29
 * 作者:田桂银
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocCreateOrderServiceReqAgrBo extends BaseExtendBo {

    private static final long serialVersionUID = 8917560628672058290L;


    //协议Id",required = true)
    private String agreementId;

    //协议模式 1：平台协议 2：单位协议",required = true)
    private Integer agreementCode;

    //协议版本号",required = true)
    private String agreementVersion;

    //平台协议编号")
    private String plaAgreementCode;

    //企业协议编号")
    private String entAgreementCode;

    //协议名称")
    private String agreementName;

    //是否存在加价项 0：否 1：是")
    private Integer isAddPrice;

    //配置状态 0：已分配 1：待分配 ")
    private Integer assignStatus;

    //是否公式调价 0：否 1：是")
    private Integer isAdjustPriceFormula;

    //是否手动修改采购单价 0:否 1：是")
    private Integer isModifyBuyPrice;

    //调价公式名称")
    private String adjustPriceFormulaName;

    //调价公式值")
    private String adjustPriceFormulaValue;

    //税率 ")
    private String taxRate;

    //币种，0：人民币 默认0")
    private Integer currency;

    //协议生效日期")
    private Date effDate;

    //协议失效日期")
    private Date expDate;

    //预付款(对项目单位)")
    private BigDecimal prePayEnt;

    //投料款(对项目单位)")
    private BigDecimal matPayEnt;

    //进度款(对项目单位)")
    private BigDecimal proPayEnt;

    //到货验收款(对项目单位)")
    private BigDecimal verPayEnt;

    //试运行验收款(对项目单位)")
    private BigDecimal pilPayEnt;

    //质保金(对项目单位)")
    private BigDecimal quaPayEnt;

    //投料款(对供应商)")
    private BigDecimal matPaySup;

    //进度款(对供应商)")
    private BigDecimal proPaySup;

    //到货验收款(对供应商)")
    private BigDecimal verPaySup;

    //试运行验收款(对供应商)")
    private BigDecimal pilPaySup;

    //质保金(对供应商)")
    private BigDecimal quaPaySup;

    //预付款(对供应商)")
    private BigDecimal prePaySup;

    //供货周期 单位天")
    private Integer supplyCycle;

    //质保期(月)")
    private Integer warantty;

    //是否配送 0:否,1是 默认值：是 ")
    private Integer isDispatch;

    //成交服务费比率 选项：0, 2.5, 5.0")
    private BigDecimal serviceRate;

    //结算单位id")
    private Long unitAccountId;

    //结算单位名称")
    private String unitAccountName;

    //铺货单位id")
    private Long supplierId;

    //铺货单位名称")
    private String supplierName;

    //供货商id")
    private Long vendorId;

    //供货商名称")
    private String vendorName;

    //供货商联系人")
    private String vendorContact;

    //供货商联系电话")
    private String vendorPhone;

    //铺货部门id")
    private Long vendorDepartmentId;

    //铺货部门名称")
    private String vendorDepartmentName;

    //协议创建日期")
    private Date createTime;

    //0：无，1：事前调价，2：事中调价 默认值：0",required = true)
    private Integer adjustPrice;

    //铺货联系人")
    private String vendorContactPerson;

    //铺货联系方式")
    private String vendorContactWay;

    //铺货联系地址")
    private String vendorContactAddress;

    //协议经办人")
    private Long producerId;

    //协议经办人名字")
    private String producerName;

    //协议经办人电话")
    private String producerPhone;

    //交易模式 1：贸易模式 2：搓合模式")
    private Integer tradeMode;

    //应用范围类型：0：全部:1：省份、2：行业:3：分子公司:4：项目单位 默认值：无")
    private Integer scopeType;

    //合同id")
    private Long contractId;

    //合同编号")
    private String contractNo;
    
    /**
     *合同号
     */
    private String relCode;
    /**
     *合同名称
     */
    private String relName;
    
    //项目类型（1:物资 2:工程 3:服务）
    private Integer agreementVariety;
    //项目类型（1:物资 2:工程 3:服务）
    private String agreementVarietyStr;
    //合同来源类别6:原始合同 7:续约合同 8:补充合同
    private Integer agrSrc;
    private String agrSrcStr;

    /**
     * 铺货单位ID
     */
    private String managementOrgId;
    /**
     * 铺货单位名称
     */
    private String managementOrgName;


    /**项目名称，编号，id*/
    private String agrSrcName;
    private String agrSrcCode;
    private String agrSrcId;
}


