package com.tydic.dyc.oc.model.order.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 标题:UocOrderStateChgLogQryBo
 * 说明:订单状态变更记录领域对象
 * 时间:2022-02-21 19:10
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocOrderStateChgLogQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  -5708327962685152275L;

	//id")
	private Long id;

	//单据id")
	private Long objId;

	//单据类型:1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单     99.其他")
	private Integer objType;

	//订单id")
	private Long orderId;

	//修改前状态")
	private Integer oldState;

	//修改后状态")
	private Integer newState;

	//变更时间")
	private Date chgTime;

	//变更时间 开始")
	private Date chgTimeStart;

	//变更时间 结束")
	private Date chgTimeEnd;

	//变更工号")
	private String operId;

	//状态变更原因")
	private Integer chgReson;

	//状态变更说明")
	private String chgDesc;

	//排序")
	private String orderBy;

}
