package com.tydic.dyc.oc.service.saleorder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealRelFraAgrReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocDealRelFraAgrRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @description 大兴关联框架协议订单号接口
 * @author Luokan
 * @date 2024/08/13
 **/
@HTServiceImpl
public class UocDealRelFraAgrServiceImpl implements UocDealRelFraAgrService{

    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocDealRelFraAgrRspBO dealRelFraAgr(UocDealRelFraAgrReqBO reqBO) {
        UocDealRelFraAgrRspBO rspBO = new UocDealRelFraAgrRspBO();
        //提交任务
        this.commitTask(reqBO);
        //保存附件
        if (!CollectionUtils.isEmpty(reqBO.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = JSONArray.parseArray(JSON.toJSONString(reqBO.getOrderAccessoryBoList())).toJavaList(UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBO.getOrderId());
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setCreateOperId(reqBO.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                uocOrderAccessory.setObjId(reqBO.getSaleOrderId());
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.AGR_ORDER);
            });
            this.iUocSaleOrderModel.insertAccessoryList(uocOrderAccessoryList);
        }
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    private void commitTask(UocDealRelFraAgrReqBO reqBO) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBO.getTaskId());
        taskInfos.add(task);
        uocCommonDo.setCompleteTaskInfos(taskInfos);
        uocCommonDo.setUserId(reqBO.getUserId());
        uocCommonDo.setOrderId(reqBO.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }
}
